/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.ai.BlockBreakerManager;
import com.example.soundattract.config.SoundAttractConfigData;
import java.util.EnumSet;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1352;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_7923;

public class BlockBreakerPosGoal
extends class_1352 {
    private final class_1308 miner;
    private final class_2338 destinationPos;
    private final double reachDistance = 4.9;
    private final double timeToBreakMultiplier;
    private final boolean toolOnly;
    private final boolean properToolOnly;
    private final boolean properToolRequired;
    private class_2338 targetPos = null;
    private class_2680 targetState = null;
    private int tickToBreak = 0;
    private int breakingTick = 0;
    private int prevBreakProgress = 0;

    public BlockBreakerPosGoal(class_1308 miner, class_2338 destination, double timeToBreakMultiplier, boolean toolOnly, boolean properToolOnly, boolean properToolRequired) {
        this.miner = miner;
        this.destinationPos = destination;
        this.timeToBreakMultiplier = timeToBreakMultiplier <= 0.0 ? 1.0 : timeToBreakMultiplier;
        this.toolOnly = toolOnly;
        this.properToolOnly = properToolOnly;
        this.properToolRequired = properToolRequired;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        SoundAttractConfigData cfg = SoundAttractMod.CONFIG;
        if (!cfg.enableBlockBreaking) {
            return false;
        }
        if (this.destinationPos == null) {
            return false;
        }
        if (this.toolOnly && !this.isHoldingTool()) {
            return false;
        }
        this.targetPos = BlockBreakerPosGoal.findFirstBlockingBlock(this.miner.method_37908(), this.miner, this.destinationPos);
        if (this.targetPos == null) {
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] {}: No blocking block found toward {}.", (Object)this.miner.method_5477().getString(), (Object)this.destinationPos);
            }
            return false;
        }
        this.targetState = this.miner.method_37908().method_8320(this.targetPos);
        if (!this.passesRules(this.targetState, this.targetPos)) {
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] {}: Target {} rejected by rules.", (Object)this.miner.method_5477().getString(), (Object)this.targetPos);
            }
            return false;
        }
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] {}: Starting to break {} to reach {}.", new Object[]{this.miner.method_5477().getString(), this.targetPos, this.destinationPos});
        }
        return true;
    }

    public boolean method_6266() {
        if (this.targetPos == null) {
            return false;
        }
        if (this.destinationPos == null) {
            return false;
        }
        class_1937 world = this.miner.method_37908();
        if (world.method_22347(this.targetPos)) {
            return false;
        }
        if (this.properToolOnly && this.targetState != null && !this.canBreakBlock(this.targetState)) {
            return false;
        }
        class_2338 ahead = BlockBreakerPosGoal.findFirstBlockingBlock(world, this.miner, this.destinationPos);
        return ahead != null;
    }

    public void method_6269() {
        if (this.targetPos != null) {
            this.initBlockBreak();
            this.miner.method_19540(true);
            double distSq = this.miner.method_19538().method_1025(class_243.method_24953((class_2382)this.targetPos));
            if (distSq > 24.010000000000005) {
                this.miner.method_5942().method_6337((double)this.targetPos.method_10263() + 0.5, (double)this.targetPos.method_10264() + 0.5, (double)this.targetPos.method_10260() + 0.5, 1.0);
            }
        }
    }

    public void method_6270() {
        class_1937 class_19372;
        if (this.targetPos != null && (class_19372 = this.miner.method_37908()) instanceof class_3218) {
            class_3218 sw = (class_3218)class_19372;
            sw.method_8517(this.miner.method_5628(), this.targetPos, -1);
        }
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] {}: Stopping block breaking.", (Object)this.miner.method_5477().getString());
        }
        this.targetPos = null;
        this.targetState = null;
        this.tickToBreak = 0;
        this.breakingTick = 0;
        this.prevBreakProgress = 0;
        this.miner.method_19540(false);
        BlockBreakerManager.scheduleRemove(this.miner, this);
    }

    public void method_6268() {
        class_3218 sw;
        if (this.targetPos == null || this.targetState == null) {
            return;
        }
        class_1937 world = this.miner.method_37908();
        if (world.method_22347(this.targetPos)) {
            return;
        }
        if (this.properToolOnly && !this.canBreakBlock(this.targetState)) {
            return;
        }
        double distSqToTarget = this.miner.method_19538().method_1025(class_243.method_24953((class_2382)this.targetPos));
        if (distSqToTarget > 24.010000000000005) {
            if (this.miner.method_5942().method_6357() || this.miner.method_5942().method_6355() == null || !this.miner.method_5942().method_6355().equals((Object)this.targetPos)) {
                this.miner.method_5942().method_6337((double)this.targetPos.method_10263() + 0.5, (double)this.targetPos.method_10264() + 0.5, (double)this.targetPos.method_10260() + 0.5, 1.0);
            }
            if (world instanceof class_3218) {
                class_3218 sw2 = (class_3218)world;
                sw2.method_8517(this.miner.method_5628(), this.targetPos, -1);
            }
            return;
        }
        ++this.breakingTick;
        this.miner.method_5988().method_20248((double)this.targetPos.method_10263() + 0.5, (double)this.targetPos.method_10264() + 0.5, (double)this.targetPos.method_10260() + 0.5);
        int progress = (int)((float)this.breakingTick / (float)Math.max(1, this.tickToBreak) * 10.0f);
        if (progress != this.prevBreakProgress) {
            this.prevBreakProgress = progress;
            if (world instanceof class_3218) {
                sw = (class_3218)world;
                sw.method_8517(this.miner.method_5628(), this.targetPos, progress);
            }
        }
        if (this.breakingTick % 6 == 0) {
            this.miner.method_6104(class_1268.field_5808);
        }
        if (this.breakingTick % 4 == 0) {
            class_2498 group = this.targetState.method_26231();
            world.method_8396(null, this.targetPos, group.method_10596(), class_3419.field_15245, (group.method_10597() + 1.0f) / 8.0f, group.method_10599() * 0.5f);
        }
        if (this.breakingTick >= this.tickToBreak && world instanceof class_3218) {
            sw = (class_3218)world;
            sw.method_8517(this.miner.method_5628(), this.targetPos, -1);
            sw.method_8651(this.targetPos, true, (class_1297)this.miner);
            this.targetPos = BlockBreakerPosGoal.findFirstBlockingBlock(world, this.miner, this.destinationPos);
            if (this.targetPos != null) {
                this.targetState = world.method_8320(this.targetPos);
                if (this.passesRules(this.targetState, this.targetPos)) {
                    this.initBlockBreak();
                } else {
                    this.targetPos = null;
                    this.targetState = null;
                }
            }
        }
    }

    private void initBlockBreak() {
        this.targetState = this.miner.method_37908().method_8320(this.targetPos);
        this.tickToBreak = this.computeTicksToBreak(this.targetState);
        this.breakingTick = 0;
        this.prevBreakProgress = 0;
    }

    private int computeTicksToBreak(class_2680 state) {
        float hardness = state.method_26214((class_1922)this.miner.method_37908(), this.targetPos);
        if (hardness == 0.0f) {
            return 1;
        }
        double base = 20.0 * (double)hardness * this.timeToBreakMultiplier;
        if (state.method_29291() && !this.isSuitableFor(state)) {
            base *= 4.0;
        }
        return Math.max(1, (int)Math.ceil(base));
    }

    private boolean canBreakBlock(class_2680 state) {
        if (!state.method_29291() || !this.properToolRequired) {
            return true;
        }
        return this.isSuitableFor(state);
    }

    private boolean isSuitableFor(class_2680 state) {
        return this.miner.method_6047().method_7951(state) || this.miner.method_6079().method_7951(state);
    }

    private boolean isHoldingTool() {
        return !this.miner.method_6047().method_7960() || !this.miner.method_6079().method_7960();
    }

    private boolean passesRules(class_2680 state, class_2338 pos) {
        boolean listed;
        SoundAttractConfigData cfg = SoundAttractMod.CONFIG;
        if (pos.method_10264() > cfg.blockBreakMaxY) {
            return false;
        }
        if (state.method_31709() && cfg.blockBreakBlacklistTileEntities) {
            return false;
        }
        class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
        String idStr = id.toString();
        boolean bl = listed = cfg.blockBreakBlockList != null && cfg.blockBreakBlockList.stream().map(String::trim).anyMatch(s -> !s.isEmpty() && s.equals(idStr));
        if (!cfg.blockBreakListAsWhitelist && listed) {
            return false;
        }
        return !cfg.blockBreakListAsWhitelist || listed;
    }

    private static class_2338 findFirstBlockingBlock(class_1937 world, class_1308 mob, class_2338 dest) {
        class_243 end;
        if (world == null || mob == null || dest == null) {
            return null;
        }
        class_243 start = mob.method_33571();
        class_3965 hit = world.method_17742(new class_3959(start, end = class_243.method_24953((class_2382)dest), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)mob));
        if (hit != null && hit.method_17783() != class_239.class_240.field_1333) {
            return hit.method_17777();
        }
        class_243 mobPos = mob.method_19538();
        class_243 destCenter = class_243.method_24953((class_2382)dest);
        class_243 dir = destCenter.method_1020(mobPos);
        double length = dir.method_1033();
        if (length < 0.001) {
            return null;
        }
        class_243 step = dir.method_1029().method_1021(0.5);
        int maxSteps = (int)Math.ceil(length / 0.5);
        class_243 probeFeet = new class_243(mobPos.field_1352, mob.method_23318(), mobPos.field_1350);
        class_243 probeEye = new class_243(mobPos.field_1352, mob.method_23320(), mobPos.field_1350);
        for (int i = 0; i < maxSteps; ++i) {
            probeFeet = probeFeet.method_1019(step);
            probeEye = probeEye.method_1019(step);
            class_2338 feetPos = class_2338.method_49638((class_2374)probeFeet);
            class_2338 eyePos = class_2338.method_49638((class_2374)probeEye);
            if (BlockBreakerPosGoal.isObstacle(world, feetPos)) {
                return feetPos;
            }
            if (!BlockBreakerPosGoal.isObstacle(world, eyePos)) continue;
            return eyePos;
        }
        return null;
    }

    private static boolean isObstacle(class_1937 world, class_2338 pos) {
        class_2680 st = world.method_8320(pos);
        return !st.method_26215() && !st.method_26220((class_1922)world, pos).method_1110();
    }
}

