/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.ai.AttractionGoal;
import com.example.soundattract.ai.BlockBreakerManager;
import com.example.soundattract.ai.BlockBreakerPosGoal;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.mixin.MobEntityAccessor;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.class_1308;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;

public class FollowLeaderGoal
extends class_1352 {
    private final class_1308 mob;
    private final double moveSpeed;
    private class_1308 leader;
    private AttractionGoal leaderAttractionGoal;
    private class_2338 leaderObjectivePos;
    private class_2338 myStableDestination;
    private int updateTimer;
    private int timeToLive;
    private static final int MAX_TIME_TO_LIVE = 10;
    private BlockBreakerPosGoal followerBreaker = null;
    private class_243 lastPosVec = null;
    private int stuckTicks = 0;

    public FollowLeaderGoal(class_1308 mob, double moveSpeed) {
        this.mob = mob;
        this.moveSpeed = moveSpeed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (this.mob.method_5968() != null) {
            return false;
        }
        this.leader = MobGroupManager.getLeader(this.mob);
        if (this.leader == null || this.leader == this.mob || !this.leader.method_5805()) {
            return false;
        }
        this.leaderAttractionGoal = AttractionGoal.getAttractionGoal(this.leader);
        if (this.leaderAttractionGoal == null || !this.leaderAttractionGoal.isPursuingSound()) {
            return false;
        }
        return this.leaderAttractionGoal.getTargetSoundPos() != null;
    }

    public boolean method_6266() {
        return this.timeToLive > 0 && this.mob.method_5968() == null && this.leader != null && this.leader.method_5805();
    }

    public void method_6269() {
        this.updateTimer = 0;
        this.timeToLive = 10;
        this.leaderObjectivePos = this.leaderAttractionGoal.getTargetSoundPos();
        this.myStableDestination = this.calculateMyStableDestination(this.leaderObjectivePos);
        this.startMovingToDestination();
    }

    public void method_6270() {
        this.mob.method_5942().method_6340();
        if (this.followerBreaker != null) {
            BlockBreakerManager.scheduleRemove(this.mob, this.followerBreaker);
            this.followerBreaker = null;
        }
        this.leader = null;
        this.leaderAttractionGoal = null;
        this.leaderObjectivePos = null;
        this.myStableDestination = null;
        this.lastPosVec = null;
        this.stuckTicks = 0;
    }

    public void method_6268() {
        class_2338 currentLeaderObjective;
        this.timeToLive = this.leaderAttractionGoal != null && this.leaderAttractionGoal.isPursuingSound() ? 10 : --this.timeToLive;
        if (this.leaderObjectivePos != null) {
            this.mob.method_5988().method_19615(class_243.method_24953((class_2382)this.leaderObjectivePos));
        }
        if (this.leaderAttractionGoal.isPursuingSound() && ++this.updateTimer % 20 == 0 && (currentLeaderObjective = this.leaderAttractionGoal.getTargetSoundPos()) != null && !currentLeaderObjective.equals((Object)this.leaderObjectivePos) && (this.leaderObjectivePos == null || this.leaderObjectivePos.method_10262((class_2382)currentLeaderObjective) > 100.0)) {
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[FollowLeaderGoal] {} updating target to {}. Recalculating destination.", (Object)this.mob.method_5477().getString(), (Object)currentLeaderObjective);
            }
            this.leaderObjectivePos = currentLeaderObjective;
            this.myStableDestination = this.calculateMyStableDestination(this.leaderObjectivePos);
            this.startMovingToDestination();
        }
        if (this.myStableDestination != null && !this.mob.method_5942().method_23966() && this.mob.method_24515().method_10262((class_2382)this.myStableDestination) > 4.0) {
            this.startMovingToDestination();
        }
        if (SoundAttractMod.CONFIG.enableBlockBreaking && this.leaderObjectivePos != null) {
            boolean trulyStuck;
            double distSqToLeaderTarget = this.mob.method_19538().method_1025(class_243.method_24953((class_2382)this.leaderObjectivePos));
            class_243 curPos = this.mob.method_19538();
            if (this.lastPosVec != null && curPos.method_1025(this.lastPosVec) < 0.01) {
                ++this.stuckTicks;
                if (SoundAttractMod.CONFIG.debugLogging && this.stuckTicks % 10 == 0) {
                    SoundAttractMod.LOGGER.info("[FollowLeaderGoal] {} appears stuck for {} ticks near {} while following leader toward {}", new Object[]{this.mob.method_5477().getString(), this.stuckTicks, this.mob.method_24515(), this.leaderObjectivePos});
                }
            } else {
                this.stuckTicks = 0;
                this.lastPosVec = curPos;
            }
            boolean navIdleAndFar = this.mob.method_5942().method_6357() && distSqToLeaderTarget > 4.0;
            boolean bl = trulyStuck = this.stuckTicks >= 10;
            if (this.followerBreaker != null) {
                boolean running = false;
                try {
                    running = ((MobEntityAccessor)this.mob).getGoalSelector().method_35115().stream().anyMatch(w -> w.method_19058() == this.followerBreaker && w.method_19056());
                }
                catch (ClassCastException e) {
                    SoundAttractMod.LOGGER.error("[FollowLeaderGoal] Failed to access running goals for {}", (Object)this.mob.method_5477().getString(), (Object)e);
                }
                if (!running) {
                    this.followerBreaker = null;
                }
            }
            if (this.followerBreaker == null && (navIdleAndFar || trulyStuck)) {
                BlockBreakerPosGoal breaker = new BlockBreakerPosGoal(this.mob, this.leaderObjectivePos, SoundAttractMod.CONFIG.blockBreakTimeMultiplier, SoundAttractMod.CONFIG.blockBreakToolOnly, SoundAttractMod.CONFIG.blockBreakProperToolOnly, SoundAttractMod.CONFIG.blockBreakProperToolRequired);
                BlockBreakerManager.scheduleAdd(this.mob, breaker, 0);
                this.followerBreaker = breaker;
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[FollowLeaderGoal] Scheduling BlockBreakerPosGoal for follower {} toward leader target {} (navIdleAndFar={}, stuckTicks={})", new Object[]{this.mob.method_5477().getString(), this.leaderObjectivePos, navIdleAndFar, this.stuckTicks});
                }
                this.stuckTicks = 0;
            }
        }
    }

    private void startMovingToDestination() {
        if (this.myStableDestination != null) {
            this.mob.method_5942().method_6337((double)this.myStableDestination.method_10263() + 0.5, (double)this.myStableDestination.method_10264(), (double)this.myStableDestination.method_10260() + 0.5, this.moveSpeed);
        }
    }

    private class_2338 calculateMyStableDestination(class_2338 leaderTarget) {
        if (leaderTarget == null) {
            return null;
        }
        double arrivalDistance = SoundAttractMod.CONFIG.arrivalDistance;
        long seed = this.mob.method_5667().getMostSignificantBits() ^ leaderTarget.method_10063();
        Random rand = new Random(seed);
        double angle = rand.nextDouble() * 2.0 * Math.PI;
        double radius = arrivalDistance * (0.5 + rand.nextDouble() * 0.5);
        return class_2338.method_49637((double)((double)leaderTarget.method_10263() + Math.cos(angle) * radius), (double)leaderTarget.method_10264(), (double)((double)leaderTarget.method_10260() + Math.sin(angle) * radius));
    }
}

