/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.mixin;

import com.example.soundattract.FovEvents;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.StealthDetectionEvents;
import com.example.soundattract.accessor.FleeOnDamageAccessor;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_5354;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityDamageMixin {
    @Inject(method={"damage"}, at={@At(value="HEAD")})
    private void soundattract_onDamageTriggerStealthReactions(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        boolean isUnexpectedHit;
        class_1657 player;
        class_1297 attacker;
        class_1308 mob;
        block22: {
            block21: {
                LivingEntityDamageMixin livingEntityDamageMixin = this;
                if (!(livingEntityDamageMixin instanceof class_1308)) {
                    return;
                }
                mob = (class_1308)livingEntityDamageMixin;
                attacker = source.method_5529();
                if (!(attacker instanceof class_1657)) break block21;
                player = (class_1657)attacker;
                if (attacker != mob) break block22;
            }
            return;
        }
        if (player.method_7337() || player.method_7325() || !player.method_5805()) {
            isUnexpectedHit = false;
        } else {
            boolean inFov = FovEvents.isTargetInFov(mob, (class_1297)player, false);
            double range = StealthDetectionEvents.computeFullDetectionRange(mob, player, mob.method_37908());
            boolean inRange = (double)mob.method_5739((class_1297)player) <= range;
            boolean bl = isUnexpectedHit = !inFov || !inRange;
        }
        if (!isUnexpectedHit) {
            return;
        }
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[DamageMixin] Unexpected hit on {} by {}. Deciding reaction...", (Object)mob.method_5477().getString(), (Object)player.method_5477().getString());
        }
        if (mob instanceof class_1588 || mob instanceof class_5354) {
            double distance = mob.method_5739((class_1297)player);
            if (distance >= 5.0) {
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("... Target is HOSTILE and far away. Setting flee location.", (Object)mob.method_5477().getString());
                }
                if (mob instanceof FleeOnDamageAccessor) {
                    FleeOnDamageAccessor accessor = (FleeOnDamageAccessor)mob;
                    accessor.soundattract_setFleeFromLocation(attacker.method_19538());
                }
            } else if (mob instanceof class_1548) {
                class_1548 creeper = (class_1548)mob;
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("... Target is a Creeper at close range. IGNITING.", (Object)mob.method_5477().getString());
                }
                creeper.method_7004();
            } else if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("... Target is HOSTILE and close. Allowing reflex revenge.", (Object)mob.method_5477().getString());
            }
        } else {
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("... Target is PASSIVE. Setting flee location.", (Object)mob.method_5477().getString());
            }
            if (mob instanceof FleeOnDamageAccessor) {
                FleeOnDamageAccessor accessor = (FleeOnDamageAccessor)mob;
                accessor.soundattract_setFleeFromLocation(attacker.method_19538());
            }
        }
    }

    @ModifyVariable(method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, at=@At(value="HEAD"), argsOnly=true)
    private float soundattract_modifyDamageAmount(float originalAmount, class_1282 source) {
        class_1309 target = (class_1309)this;
        float modifiedDamage = FovEvents.getModifiedDamage(target, source, originalAmount);
        if (modifiedDamage > originalAmount && SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[DamageMixin] Backstab bonus applied to {}. Damage: {} -> {}", new Object[]{target.method_5477().getString(), Float.valueOf(originalAmount), Float.valueOf(modifiedDamage)});
        }
        return modifiedDamage;
    }
}

