/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.util;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundTracker;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public final class WorkerScheduler {
    private static final int DEFAULT_QUEUE_CAPACITY = 1024;
    private static final int DEFAULT_THREADS = Math.max(1, Math.min(32, Runtime.getRuntime().availableProcessors() - 1));
    private static final ConcurrentLinkedQueue<SoundScoreResult> SOUND_RESULTS = new ConcurrentLinkedQueue();
    private static final ConcurrentLinkedQueue<GroupComputeResult> GROUP_RESULTS = new ConcurrentLinkedQueue();
    private static volatile ThreadPoolExecutor EXECUTOR;

    private WorkerScheduler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureInitialized() {
        if (EXECUTOR != null) {
            return;
        }
        Class<WorkerScheduler> clazz = WorkerScheduler.class;
        synchronized (WorkerScheduler.class) {
            if (EXECUTOR != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            int threads = DEFAULT_THREADS;
            int capacity = 1024;
            if (SoundAttractMod.CONFIG != null) {
                int cfgThreads = SoundAttractMod.CONFIG.workerThreads;
                threads = cfgThreads <= 0 ? DEFAULT_THREADS : Math.max(1, Math.min(64, cfgThreads));
                int cfgCap = SoundAttractMod.CONFIG.workerQueueCapacity;
                capacity = cfgCap <= 0 ? 1024 : Math.max(64, Math.min(16384, cfgCap));
            }
            ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(capacity);
            ThreadFactory tf = new ThreadFactory(){
                private final AtomicInteger idx = new AtomicInteger(1);

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "SoundAttract-Worker-" + this.idx.getAndIncrement());
                    t.setDaemon(true);
                    t.setPriority(5);
                    return t;
                }
            };
            ThreadPoolExecutor.DiscardOldestPolicy rejector = new ThreadPoolExecutor.DiscardOldestPolicy(){

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                    if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                        SoundAttractMod.LOGGER.debug("[WorkerScheduler] Queue saturated. Discarding oldest task.");
                    }
                    super.rejectedExecution(r, e);
                }
            };
            EXECUTOR = new ThreadPoolExecutor(threads, threads, 60L, TimeUnit.SECONDS, queue, tf, rejector);
            EXECUTOR.allowCoreThreadTimeOut(true);
            if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[WorkerScheduler] Initialized with {} threads, capacity {}.", (Object)threads, (Object)capacity);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void shutdown() {
        ThreadPoolExecutor exec = EXECUTOR;
        if (exec != null) {
            exec.shutdownNow();
            EXECUTOR = null;
        }
        SOUND_RESULTS.clear();
        GROUP_RESULTS.clear();
    }

    public static void submitSoundTask(Callable<SoundScoreResult> task) {
        Objects.requireNonNull(task, "task");
        WorkerScheduler.ensureInitialized();
        EXECUTOR.execute(() -> {
            block3: {
                try {
                    SoundScoreResult result = (SoundScoreResult)task.call();
                    if (result != null) {
                        SOUND_RESULTS.add(result);
                    }
                }
                catch (Throwable t) {
                    if (SoundAttractMod.CONFIG == null || !SoundAttractMod.CONFIG.debugLogging) break block3;
                    SoundAttractMod.LOGGER.warn("[WorkerScheduler] Sound task failed: {}", (Object)t.toString());
                }
            }
        });
    }

    public static void submitGroupTask(Callable<GroupComputeResult> task) {
        Objects.requireNonNull(task, "task");
        WorkerScheduler.ensureInitialized();
        EXECUTOR.execute(() -> {
            block3: {
                try {
                    GroupComputeResult result = (GroupComputeResult)task.call();
                    if (result != null) {
                        GROUP_RESULTS.add(result);
                    }
                }
                catch (Throwable t) {
                    if (SoundAttractMod.CONFIG == null || !SoundAttractMod.CONFIG.debugLogging) break block3;
                    SoundAttractMod.LOGGER.warn("[WorkerScheduler] Group task failed: {}", (Object)t.toString());
                }
            }
        });
    }

    public static int drainSoundResults(Consumer<SoundScoreResult> applier, long budgetMillis) {
        return WorkerScheduler.drainQueue(SOUND_RESULTS, applier, budgetMillis);
    }

    public static int drainGroupResults(Consumer<GroupComputeResult> applier, long budgetMillis) {
        return WorkerScheduler.drainQueue(GROUP_RESULTS, applier, budgetMillis);
    }

    private static <T> int drainQueue(ConcurrentLinkedQueue<T> q, Consumer<T> applier, long budgetMillis) {
        T item;
        Objects.requireNonNull(applier, "applier");
        long start = System.nanoTime();
        int applied = 0;
        while ((item = q.poll()) != null) {
            long elapsedMs;
            block4: {
                try {
                    applier.accept(item);
                }
                catch (Throwable t) {
                    if (SoundAttractMod.CONFIG == null || !SoundAttractMod.CONFIG.debugLogging) break block4;
                    SoundAttractMod.LOGGER.warn("[WorkerScheduler] Result apply failed: {}", (Object)t.toString());
                }
            }
            ++applied;
            if (budgetMillis <= 0L || (elapsedMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)) < budgetMillis) continue;
            break;
        }
        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
            long elapsedMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            SoundAttractMod.LOGGER.debug("[WorkerScheduler] Drained {} results in {} ms. Remaining: {}", new Object[]{applied, elapsedMs, q.size()});
        }
        return applied;
    }

    public static final class GroupComputeResult {
        public final Object data;

        public GroupComputeResult(Object data) {
            this.data = data;
        }
    }

    public static final class SoundScoreResult {
        public final UUID mobUuid;
        public final String dimensionKey;
        public final SoundTracker.SoundRecord best;
        public final long createdAtNanos;

        public SoundScoreResult(UUID mobUuid, String dimensionKey, SoundTracker.SoundRecord best) {
            this.mobUuid = mobUuid;
            this.dimensionKey = dimensionKey;
            this.best = best;
            this.createdAtNanos = System.nanoTime();
        }

        public UUID getMobUuid() {
            return this.mobUuid;
        }

        public SoundTracker.SoundRecord getBest() {
            return this.best;
        }

        public String getDimensionKey() {
            return this.dimensionKey;
        }
    }
}

