/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.config.SoundAttractConfig;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class SoundMessage {
    private final ResourceLocation soundId;
    private final double x;
    private final double y;
    private final double z;
    private final ResourceLocation dimension;
    private final Optional<UUID> sourcePlayerUUID;
    private final int range;
    private final double weight;
    private final String animatorClass;
    private final String taczType;
    private final String pointBlankType;
    public static final ResourceLocation VOICE_CHAT_SOUND_ID = ResourceLocation.fromNamespaceAndPath((String)"soundattract", (String)"voice_chat");

    public SoundMessage(ResourceLocation soundId, double x, double y, double z, ResourceLocation dimension, Optional<UUID> sourcePlayerUUID, int range, double weight, String animatorClass, String taczType, String pointBlankType) {
        this.soundId = soundId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
        this.sourcePlayerUUID = sourcePlayerUUID;
        this.range = range;
        this.weight = weight;
        this.animatorClass = animatorClass;
        this.taczType = taczType;
        this.pointBlankType = pointBlankType;
    }

    public SoundMessage(ResourceLocation soundId, double x, double y, double z, ResourceLocation dimension, Optional<UUID> sourcePlayerUUID, int range, double weight, String animatorClass) {
        this(soundId, x, y, z, dimension, sourcePlayerUUID, range, weight, animatorClass, null, null);
    }

    public SoundMessage(ResourceLocation soundId, double x, double y, double z, ResourceLocation dimension, Optional<UUID> sourcePlayerUUID) {
        this(soundId, x, y, z, dimension, sourcePlayerUUID, -1, 1.0, null, null, null);
    }

    public SoundMessage(ResourceLocation soundId, double x, double y, double z, ResourceLocation dimension, Optional<UUID> sourcePlayerUUID, int range) {
        this(soundId, x, y, z, dimension, sourcePlayerUUID, range, 1.0, null, null, null);
    }

    public SoundMessage(ResourceLocation soundId, double x, double y, double z, ResourceLocation dimension, Optional<UUID> sourcePlayerUUID, int range, double weight) {
        this(soundId, x, y, z, dimension, sourcePlayerUUID, range, weight, null, null, null);
    }

    public static void encode(SoundMessage msg, FriendlyByteBuf buf) {
        buf.m_130085_(msg.soundId);
        buf.writeDouble(msg.x);
        buf.writeDouble(msg.y);
        buf.writeDouble(msg.z);
        buf.m_130085_(msg.dimension);
        buf.writeBoolean(msg.sourcePlayerUUID.isPresent());
        msg.sourcePlayerUUID.ifPresent(arg_0 -> ((FriendlyByteBuf)buf).m_130077_(arg_0));
        buf.writeInt(msg.range);
        buf.writeDouble(msg.weight);
        buf.writeBoolean(msg.animatorClass != null);
        if (msg.animatorClass != null) {
            buf.m_130070_(msg.animatorClass);
        }
        buf.writeBoolean(msg.taczType != null);
        if (msg.taczType != null) {
            buf.m_130070_(msg.taczType);
        }
        buf.writeBoolean(msg.pointBlankType != null);
        if (msg.pointBlankType != null) {
            buf.m_130070_(msg.pointBlankType);
        }
    }

    public static SoundMessage decode(FriendlyByteBuf buf) {
        ResourceLocation soundId = buf.m_130281_();
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        ResourceLocation dimension = buf.m_130281_();
        Optional<UUID> sourcePlayerUUID = buf.readBoolean() ? Optional.of(buf.m_130259_()) : Optional.empty();
        int range = buf.readInt();
        double weight = buf.readDouble();
        String animatorClass = buf.readBoolean() ? buf.m_130277_() : null;
        String taczType = buf.readBoolean() ? buf.m_130277_() : null;
        String pointBlankType = buf.readBoolean() ? buf.m_130277_() : null;
        return new SoundMessage(soundId, x, y, z, dimension, sourcePlayerUUID, range, weight, animatorClass, taczType, pointBlankType);
    }

    public static void handle(SoundMessage msg, Supplier<NetworkEvent.Context> ctx) {
        block6: {
            try {
                ResourceLocation loc = msg.soundId;
                if (!(SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.isEmpty() || loc != null && SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.contains(loc) || msg.soundId.equals((Object)VOICE_CHAT_SOUND_ID))) {
                    if (ctx != null && ctx.get() != null) {
                        ctx.get().setPacketHandled(true);
                    }
                    return;
                }
                Runnable logic = () -> {
                    ServerLevel serverLevel;
                    ServerPlayer sender = ctx != null && ctx.get() != null ? ((NetworkEvent.Context)ctx.get()).getSender() : null;
                    ServerLevel serverLevel2 = serverLevel = sender != null ? sender.m_284548_() : ServerLifecycleHooks.getCurrentServer().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)msg.dimension));
                    if (serverLevel == null) {
                        SoundAttractMod.LOGGER.warn("[SoundMessage] serverLevel is null for {}", (Object)msg.dimension);
                        return;
                    }
                    if (!serverLevel.m_46472_().m_135782_().equals((Object)msg.dimension)) {
                        SoundAttractMod.LOGGER.warn("[SoundMessage] dimension mismatch ({} \u2260 {})", (Object)serverLevel.m_46472_().m_135782_(), (Object)msg.dimension);
                        return;
                    }
                    BlockPos pos = BlockPos.m_274561_((double)msg.x, (double)msg.y, (double)msg.z);
                    if (pos.equals((Object)BlockPos.f_121853_) && sender != null) {
                        pos = sender.m_20183_();
                    }
                    String dimString = msg.dimension.toString();
                    int lifetime = (Integer)SoundAttractConfig.COMMON.soundLifetimeTicks.get();
                    if (msg.soundId.equals((Object)VOICE_CHAT_SOUND_ID)) {
                        if (msg.range > 0) {
                            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                                SoundAttractMod.LOGGER.info("[SoundMessage] Adding VC sound at {} dim={} range={} weight={}", new Object[]{pos, dimString, msg.range, msg.weight});
                            }
                            SoundTracker.addSound(null, pos, dimString, msg.range, msg.weight, lifetime, VOICE_CHAT_SOUND_ID.toString());
                        }
                    } else {
                        SoundAttractConfig.SoundDefaultEntry def;
                        SoundEvent se = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(msg.soundId);
                        double range = msg.range;
                        double weight = msg.weight;
                        if (range < 0.0 && (def = SoundAttractConfig.SOUND_DEFAULT_ENTRIES_CACHE.get(msg.soundId)) != null) {
                            range = def.range();
                            weight = def.weight();
                        }
                        if (range < 0.0) {
                            if ("shoot".equals(msg.taczType)) {
                                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                                    SoundAttractMod.LOGGER.info("[SoundMessage] Skipping fallback for gun-shot {}", (Object)msg.soundId);
                                }
                                return;
                            }
                            range = 10.0;
                            weight = 1.0;
                            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                                SoundAttractMod.LOGGER.info("[SoundMessage] Using fallback range/weight for {}: range={}, weight={}", new Object[]{msg.soundId, range, weight});
                            }
                        }
                        if (se != null) {
                            SoundTracker.addSound(se, pos, dimString, range, weight, lifetime);
                        } else {
                            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                                SoundAttractMod.LOGGER.info("[SoundMessage] No SoundEvent for {} on server; using explicit id.", (Object)msg.soundId);
                            }
                            SoundTracker.addSound(null, pos, dimString, range, weight, lifetime, msg.soundId.toString());
                        }
                    }
                };
                if (ctx != null && ctx.get() != null) {
                    ctx.get().enqueueWork(logic);
                    ctx.get().setPacketHandled(true);
                } else {
                    logic.run();
                }
            }
            catch (Exception e) {
                SoundAttractMod.LOGGER.error("[SoundMessage] Exception for soundId={}", (Object)msg.soundId, (Object)e);
                if (ctx == null || ctx.get() == null) break block6;
                ctx.get().setPacketHandled(true);
            }
        }
    }

    public String getPointBlankType() {
        return this.pointBlankType;
    }

    private static String buildPointBlankIntegrationMetadata(String type, String gunId) {
        String trimmedGun;
        String trimmedType = type == null || type.isBlank() ? null : type.trim();
        String string = trimmedGun = gunId == null || gunId.isBlank() ? null : gunId.trim();
        if (trimmedType == null && trimmedGun == null) {
            return null;
        }
        if (trimmedType == null) {
            return trimmedGun;
        }
        if (trimmedGun == null) {
            return trimmedType;
        }
        return trimmedType + ";" + trimmedGun;
    }
}

