/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class BlockBreakerManager {
    private static final Map<Mob, GoalAction> PENDING_ACTIONS = new ConcurrentHashMap<Mob, GoalAction>();

    public static void scheduleAdd(Mob mob, Goal goal, int priority) {
        PENDING_ACTIONS.put(mob, new GoalAction(ActionType.ADD, goal, priority));
    }

    public static void scheduleRemove(Mob mob, Goal goal) {
        if (goal != null) {
            PENDING_ACTIONS.put(mob, new GoalAction(ActionType.REMOVE, goal, 0));
        }
    }

    public static void processPendingActions() {
        if (PENDING_ACTIONS.isEmpty()) {
            return;
        }
        for (Mob mob : PENDING_ACTIONS.keySet()) {
            GoalAction action = PENDING_ACTIONS.remove(mob);
            if (action == null || !mob.m_6084_() || mob.m_213877_()) continue;
            if (action.type == ActionType.ADD) {
                mob.f_21345_.m_148105_().stream().filter(wrappedGoal -> wrappedGoal.m_26015_().getClass().equals(action.goal.getClass())).findFirst().ifPresent(wrappedGoal -> mob.f_21345_.m_25363_(wrappedGoal.m_26015_()));
                mob.f_21345_.m_25352_(action.priority, action.goal);
                continue;
            }
            if (action.type != ActionType.REMOVE) continue;
            mob.f_21345_.m_25363_(action.goal);
        }
    }

    private record GoalAction(ActionType type, Goal goal, int priority) {
    }

    private static enum ActionType {
        ADD,
        REMOVE;

    }
}

