/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration;

import insane96mcp.enhancedai.modules.mobs.miner.MinerMobs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;

public class EnhancedAICompat {
    private static final boolean IS_ENHANCED_AI_LOADED = ModList.get().isLoaded("enhancedai");
    private static final int DEFAULT_MAX_Y = 256;
    private static final boolean DEFAULT_BLACKLIST_TILES = true;
    private static final boolean DEFAULT_BLACKLIST_AS_WHITELIST = false;
    private static final TagKey<Block> EMPTY_BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("soundattract", "empty_block_tag"));

    public static int getMaxY() {
        if (IS_ENHANCED_AI_LOADED) {
            return MinerMobsProxy.getMaxY();
        }
        return 256;
    }

    public static boolean shouldBlacklistTileEntities() {
        if (IS_ENHANCED_AI_LOADED) {
            return MinerMobsProxy.blacklistTileEntities();
        }
        return true;
    }

    public static boolean isBlacklistAsWhitelist() {
        if (IS_ENHANCED_AI_LOADED) {
            return MinerMobsProxy.isBlacklistAsWhitelist();
        }
        return false;
    }

    public static TagKey<Block> getBlockBlacklistTag() {
        if (IS_ENHANCED_AI_LOADED) {
            return MinerMobsProxy.getBlockBlacklistTag();
        }
        return EMPTY_BLACKLIST;
    }

    private static class MinerMobsProxy {
        private MinerMobsProxy() {
        }

        static int getMaxY() {
            return MinerMobs.maxY;
        }

        static boolean blacklistTileEntities() {
            return MinerMobs.blacklistTileEntities;
        }

        static boolean isBlacklistAsWhitelist() {
            return MinerMobs.blockBlacklistAsWhitelist;
        }

        static TagKey<Block> getBlockBlacklistTag() {
            return MinerMobs.BLOCK_BLACKLIST;
        }
    }
}

