/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundAttractNetwork;
import com.example.soundattract.SoundMessage;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1113;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7923;

public class SoundAttractClientEvents {
    public static void onPlaySoundEvent(class_1113 soundInstance) {
        if (soundInstance == null) {
            return;
        }
        class_638 clientWorld = class_310.method_1551().field_1687;
        class_746 clientPlayer = class_310.method_1551().field_1724;
        if (clientWorld == null || clientPlayer == null) {
            SoundAttractMod.LOGGER.warn("[SoundAttractClientEvents] Client world or player is null in onPlaySoundEvent, skipping event.");
            return;
        }
        class_2960 soundRL = soundInstance.method_4775();
        if (soundRL == null || soundRL.equals((Object)SoundMessage.VOICE_CHAT_SOUND_ID)) {
            return;
        }
        class_3414 se = (class_3414)class_7923.field_41172.method_10223(soundRL);
        if (se == null) {
            return;
        }
        double x = soundInstance.method_4784();
        double y = soundInstance.method_4779();
        double z = soundInstance.method_4778();
        class_2960 dim = clientWorld.method_27983().method_29177();
        Optional<UUID> sourcePlayerUUID = Optional.empty();
        int calculatedRange = -1;
        double calculatedWeight = 1.0;
        if (se != null && se.method_14833().method_12832().contains("step") && clientPlayer.method_5649(x, y, z) < 2.25) {
            sourcePlayerUUID = Optional.of(clientPlayer.method_5667());
            class_243 motion = clientPlayer.method_18798();
            double horizontalSpeedSq = motion.field_1352 * motion.field_1352 + motion.field_1350 * motion.field_1350;
            boolean isOnGround = clientPlayer.method_24828();
            boolean isSneaking = clientPlayer.method_5715();
            boolean isSprinting = clientPlayer.method_5624();
            PlayerAction currentAction = PlayerAction.IDLE;
            if (isSneaking) {
                if (horizontalSpeedSq > 1.0E-6 && horizontalSpeedSq <= 9.0E-4) {
                    currentAction = PlayerAction.CRAWLING;
                } else if (horizontalSpeedSq > 9.0E-4 && horizontalSpeedSq <= 0.004791600000000001) {
                    currentAction = PlayerAction.SNEAKING;
                }
            } else if (isSprinting && !isOnGround) {
                currentAction = PlayerAction.SPRINT_JUMPING;
            } else if (isSprinting && horizontalSpeedSq > 0.046655999999999996) {
                currentAction = PlayerAction.SPRINTING;
            } else if (isOnGround && horizontalSpeedSq > 1.0E-6 && horizontalSpeedSq <= 0.046655999999999996) {
                currentAction = PlayerAction.WALKING;
            }
            switch (currentAction.ordinal()) {
                case 1: {
                    calculatedRange = 2;
                    calculatedWeight = 1.0;
                    break;
                }
                case 2: {
                    calculatedRange = 3;
                    calculatedWeight = 1.0;
                    break;
                }
                case 3: {
                    calculatedRange = 8;
                    calculatedWeight = 1.0;
                    break;
                }
                case 4: {
                    calculatedRange = 12;
                    calculatedWeight = 1.0;
                    break;
                }
                case 5: {
                    calculatedRange = 16;
                    calculatedWeight = 1.0;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        SoundMessage msg = new SoundMessage(soundRL, x, y, z, dim, sourcePlayerUUID, calculatedRange, calculatedWeight);
        SoundAttractNetwork.sendSoundMessageToServer(msg);
    }

    public static void registerVoiceChatIntegration() {
    }

    private static int parseIntOr(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private static double parseDoubleOr(String s, double def) {
        try {
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static enum PlayerAction {
        IDLE,
        CRAWLING,
        SNEAKING,
        WALKING,
        SPRINTING,
        SPRINT_JUMPING;

    }
}

