/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.ConfigReloadListener;
import com.example.soundattract.FovEvents;
import com.example.soundattract.SoundAttractNetwork;
import com.example.soundattract.SoundAttractionEvents;
import com.example.soundattract.SoundMessage;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.StealthDetectionEvents;
import com.example.soundattract.ai.MobCellAssignmentHooks;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.config.ConfigLoader;
import com.example.soundattract.config.SoundAttractConfigData;
import com.example.soundattract.enchantment.ModEnchantments;
import com.example.soundattract.integration.PlasmoIntegration;
import com.example.soundattract.integration.PointBlankIntegrationHandler;
import com.example.soundattract.integration.VanillaIntegrationEvents;
import com.example.soundattract.loot.ModLootTables;
import com.example.soundattract.network.FabricSimpleNbtSync;
import com.example.soundattract.util.WorkerScheduler;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1308;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundAttractMod
implements ModInitializer {
    public static final String MOD_ID = "soundattract";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"soundattract");
    public static SoundAttractConfigData CONFIG;
    private long lastTickTimeNanos = 0L;
    private double averageTickTimeNanos = 5.0E7;
    private final double tpsSmoothingFactor = 0.05;
    private PlasmoIntegration plasmo;

    public void onInitialize() {
        CONFIG = ConfigLoader.load();
        if (CONFIG == null) {
            LOGGER.error("Failed to load SoundAttractMod configuration! Using default or limited functionality.");
            CONFIG = new SoundAttractConfigData();
        }
        if (SoundAttractMod.CONFIG.debugLogging) {
            LOGGER.info("[SoundAttract] Initializing. Environment: {}, Thread: {}", (Object)FabricLoader.getInstance().getEnvironmentType(), (Object)Thread.currentThread().getName());
            LOGGER.info("[SoundAttract] Debug logging is ENABLED.");
        }
        ModEnchantments.register();
        ModLootTables.register();
        MobCellAssignmentHooks.register();
        ConfigReloadListener.registerCommand();
        VanillaIntegrationEvents.register();
        FovEvents.buildCaches();
        StealthDetectionEvents.register();
        this.PointBlankIntegrationHandler();
        if (FabricLoader.getInstance().isModLoaded("plasmovoice")) {
            if (SoundAttractMod.CONFIG.debugLogging) {
                LOGGER.info("[SoundAttract] Plasmo Voice mod found. Preparing integration.");
            }
            this.plasmo = new PlasmoIntegration();
        }
        this.registerServerLifecycleEvents();
        this.registerTickEvents();
        this.registerEntityEvents();
        if (SoundAttractMod.CONFIG.debugLogging) {
            LOGGER.info("[SoundAttract] Initialization complete.");
            LOGGER.info("[DEBUG] Registered Packet IDs (Server Perspective):");
            LOGGER.info("[DEBUG]   SOUND_MESSAGE_ID: {}", (Object)SoundAttractNetwork.SOUND_MESSAGE_ID);
        }
    }

    private void PointBlankIntegrationHandler() {
        if (FabricLoader.getInstance().isModLoaded("pointblank")) {
            if (SoundAttractMod.CONFIG.enablePointBlankIntegration) {
                if (SoundAttractMod.CONFIG.debugLogging) {
                    LOGGER.info("[SoundAttract] Point Blank mod found and integration is enabled. Registering server-side event listeners.");
                }
                try {
                    PointBlankIntegrationHandler.register();
                }
                catch (Throwable e) {
                    LOGGER.error("Failed to register Point Blank integration events. This may be a mixin conflict or an API change.", e);
                }
            } else if (SoundAttractMod.CONFIG.debugLogging) {
                LOGGER.info("[SoundAttract] Point Blank integration is disabled in the config.");
            }
        } else if (SoundAttractMod.CONFIG.debugLogging) {
            LOGGER.info("[SoundAttract] Point Blank mod not found, skipping integration.");
        }
    }

    private void registerServerLifecycleEvents() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (SoundAttractMod.CONFIG.debugLogging) {
                LOGGER.info("[SoundAttract] Server started. Registering NBT sync and network handlers.");
            }
            FabricSimpleNbtSync.registerServerReceiver(LOGGER);
            if (SoundAttractMod.CONFIG.debugLogging) {
                LOGGER.info("[SoundAttract] Registering SOUND_MESSAGE_ID receiver.");
            }
            ServerPlayNetworking.registerGlobalReceiver((class_2960)SoundAttractNetwork.SOUND_MESSAGE_ID, (s, player, handler, buf, responseSender) -> {
                SoundMessage msg = SoundMessage.decode(buf);
                s.execute(() -> SoundMessage.handle(msg, player));
            });
        });
    }

    private void registerTickEvents() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            long cfgMs;
            if (this.lastTickTimeNanos == 0L) {
                this.lastTickTimeNanos = System.nanoTime();
            } else {
                double tps;
                long currentTimeNanos = System.nanoTime();
                long elapsedNanos = currentTimeNanos - this.lastTickTimeNanos;
                this.lastTickTimeNanos = currentTimeNanos;
                this.averageTickTimeNanos = this.averageTickTimeNanos * 0.95 + (double)elapsedNanos * 0.05;
                SoundAttractMod.CONFIG.lastKnownTps = tps = Math.min(20.0, 1.0E9 / this.averageTickTimeNanos);
            }
            for (class_3218 level : server.method_3738()) {
                SoundAttractionEvents.onServerTick(level);
            }
            SoundTracker.tick();
            long applyBudgetMs = 2L;
            if (CONFIG != null && (cfgMs = SoundAttractMod.CONFIG.workerTaskBudgetMs) > 0L) {
                applyBudgetMs = Math.min(20L, cfgMs);
            }
            WorkerScheduler.drainGroupResults(MobGroupManager::applyGroupResult, applyBudgetMs);
            WorkerScheduler.drainSoundResults(SoundTracker::applySoundScoreResult, applyBudgetMs);
        });
        ServerTickEvents.END_WORLD_TICK.register(world -> SoundAttractionEvents.onWorldTick(world));
    }

    private void registerEntityEvents() {
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                SoundAttractionEvents.onEntityJoinWorld(mob);
            }
        });
    }
}

