/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.DynamicScanCooldownManager;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.ai.AttractionGoal;
import com.example.soundattract.ai.BlockBreakerManager;
import com.example.soundattract.ai.FollowLeaderGoal;
import com.example.soundattract.ai.FollowerEdgeRelayGoal;
import com.example.soundattract.ai.LeaderAttractionGoal;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.ai.RaidManager;
import com.example.soundattract.mixin.MobEntityAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;

public class SoundAttractionEvents {
    private static final double IDLE_THRESHOLD_SQ = 1.0E-6;
    private static final double CRAWLING_THRESHOLD_SQ = 9.0E-4;
    private static final double SNEAKING_SPEED_SQ = 0.0043560000000000005;
    private static final double WALKING_SPEED_SQ = 0.046655999999999996;

    public static void onServerTick(class_3218 serverWorld) {
        MobGroupManager.scheduleNearbyCellsForPlayers(serverWorld, serverWorld.method_8510());
        DynamicScanCooldownManager.tickScheduler(serverWorld, serverWorld.method_8510());
        long tickStart = System.nanoTime();
        if (SoundAttractMod.CONFIG == null) {
            SoundAttractMod.LOGGER.error("[SoundAttractionEvents] CONFIG is null in onServerTick! Skipping tick.");
            return;
        }
        if (!DynamicScanCooldownManager.shouldScanThisTick(0L, serverWorld.method_8510())) {
            return;
        }
        try {
            long scanEnd;
            HashSet<String> attractedTypes = new HashSet<String>();
            for (String o : SoundAttractMod.CONFIG.attractedEntities) {
                attractedTypes.add(o.toString());
            }
            int mobCount = 0;
            int nullMobTypeCount = 0;
            if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Starting entity scan in onServerTick");
            }
            HashMap<String, Map> stackedMobs = new HashMap<String, Map>();
            int checkedEntities = 0;
            int skippedEntities = 0;
            if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Scanning entities manually with stacking and spatial partitioning");
            }
            long scanStart = System.nanoTime();
            for (class_1297 entity : serverWorld.method_27909()) {
                ++checkedEntities;
                if (!(entity instanceof class_1308)) continue;
                class_1308 mob2 = (class_1308)entity;
                try {
                    String mobTypeId;
                    if (mob2 == null) {
                        ++skippedEntities;
                        SoundAttractMod.LOGGER.warn("[SoundAttractionEvents] Manual scan: null MobEntity encountered");
                        continue;
                    }
                    class_2338 pos = null;
                    try {
                        pos = mob2.method_24515();
                    }
                    catch (Exception ex) {
                        ++skippedEntities;
                        SoundAttractMod.LOGGER.error("[SoundAttractionEvents] Manual scan: Exception getting block pos", (Throwable)ex);
                        continue;
                    }
                    if (pos == null || !serverWorld.method_8621().method_11952(pos) || !attractedTypes.contains(mobTypeId = class_7923.field_41177.method_10221((Object)mob2.method_5864()).toString())) continue;
                    long cellKey = (long)(pos.method_10263() >> 4 << 32) | (long)(pos.method_10260() >> 4) & 0xFFFFFFFFL;
                    stackedMobs.computeIfAbsent(mobTypeId, k -> new HashMap()).computeIfAbsent(cellKey, k -> new ArrayList()).add(mob2);
                }
                catch (Exception ex) {
                    ++skippedEntities;
                    SoundAttractMod.LOGGER.error("[SoundAttractionEvents] Manual scan: Exception processing entity", (Throwable)ex);
                }
            }
            long stackStart = scanEnd = System.nanoTime();
            ArrayList<class_1308> mobEntities = new ArrayList<class_1308>();
            for (Map.Entry typeEntry : stackedMobs.entrySet()) {
                for (Map.Entry cellEntry : ((Map)typeEntry.getValue()).entrySet()) {
                    List group = (List)cellEntry.getValue();
                    if (group.isEmpty()) continue;
                    mobEntities.add((class_1308)group.get(0));
                }
            }
            long stackEnd = System.nanoTime();
            if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[SoundAttractionEvents] mobEntities.size: {}, checked: {}, skipped: {}", new Object[]{mobEntities.size(), checkedEntities, skippedEntities});
            }
            long processStart = System.nanoTime();
            for (class_1308 mob3 : mobEntities) {
                try {
                    SoundTracker.submitAsyncSoundScore((class_1937)serverWorld, mob3, mob3.method_24515());
                }
                catch (Throwable t) {
                    if (SoundAttractMod.CONFIG == null || !SoundAttractMod.CONFIG.debugLogging) continue;
                    SoundAttractMod.LOGGER.debug("[SoundAttractionEvents] submitAsyncSoundScore failed for mob {}: {}", (Object)mob3.method_5667(), (Object)t.toString());
                }
            }
            for (SoundTracker.SoundRecord sound : SoundTracker.getRecentSounds()) {
                List<class_1308> mobs = SoundTracker.getMobsForSound((class_1937)serverWorld, sound, mob -> MobGroupManager.isEdgeMobEntity(mob) || MobGroupManager.getLeader(mob) == mob || MobGroupManager.isDeserter(mob));
                if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Processing sound at {} (range={}) found {} eligible mobs", new Object[]{sound.pos, sound.range, mobs.size()});
                }
                for (class_1308 mob4 : mobs) {
                    boolean isLeader = MobGroupManager.getLeader(mob4) == mob4;
                    boolean isEdge = MobGroupManager.isEdgeMobEntity(mob4);
                    boolean isDeserter = MobGroupManager.isDeserter(mob4);
                    if (isDeserter) {
                        AttractionGoal.handleSoundAttraction(mob4, sound);
                        if (SoundAttractMod.CONFIG == null || !SoundAttractMod.CONFIG.debugLogging) continue;
                        SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Deserter {} acts on sound {}", (Object)mob4.method_5667(), (Object)sound.pos);
                        continue;
                    }
                    if (isEdge) {
                        class_1308 leader;
                        if (SoundAttractMod.CONFIG.edgeMobSmartBehavior || (leader = MobGroupManager.getLeader(mob4)) == null || leader == mob4 || !(leader.method_5858((class_1297)mob4) <= sound.range * sound.range)) continue;
                        AttractionGoal.handleRelayToLeader(leader, sound, mob4);
                        if (SoundAttractMod.CONFIG == null || !SoundAttractMod.CONFIG.debugLogging) continue;
                        SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Edge {} relays sound {} to leader {} immediately", new Object[]{mob4.method_5667(), sound.pos, leader.method_5667()});
                        continue;
                    }
                    if (!isLeader) continue;
                }
            }
            if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[SoundAttractionEvents] mobEntities.size: {}, checked: {}, skipped: {}", new Object[]{mobEntities.size(), checkedEntities, skippedEntities});
                if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[SoundAttractionEvents] AttractedTypes size: {}, Stacked mob groups: {}, Null mob types: {}, Attracted mob count: {}", new Object[]{attractedTypes.size(), mobEntities.size(), nullMobTypeCount, mobCount});
                }
            }
            DynamicScanCooldownManager.update(serverWorld.method_8510(), mobEntities.size());
            SoundTracker.tick();
            for (SoundTracker.SoundRecord sound : SoundTracker.RECENT_SOUNDS) {
                MobGroupManager.scheduleCellsForSound(sound.pos, sound.range, serverWorld, serverWorld.method_8510());
            }
            BlockBreakerManager.processPendingActions();
        }
        catch (Exception e) {
            SoundAttractMod.LOGGER.error("[SoundAttractionEvents] Exception in onServerTick", (Throwable)e);
        }
    }

    public static void onWorldTick(class_3218 serverWorld) {
        SoundTracker.pruneIrrelevantSounds((class_1937)serverWorld);
        RaidManager.tick(serverWorld);
        DynamicScanCooldownManager.update(serverWorld.method_8510(), 0);
        if (DynamicScanCooldownManager.shouldScanThisTick(0L, serverWorld.method_8510())) {
            MobGroupManager.updateGroups(serverWorld);
        }
        BlockBreakerManager.processPendingActions();
    }

    public static void onEntityJoinWorld(class_1308 mob) {
        class_2960 entityId = class_7923.field_41177.method_10221((Object)mob.method_5864());
        if (entityId == null) {
            return;
        }
        String entityIdStr = entityId.toString();
        if (!SoundAttractMod.CONFIG.attractedEntities.contains(entityIdStr)) {
            return;
        }
        double moveSpeed = SoundAttractMod.CONFIG.mobMoveSpeed;
        boolean edgeSmart = SoundAttractMod.CONFIG.edgeMobSmartBehavior;
        if (edgeSmart) {
            boolean followerGoalExists;
            boolean leaderGoalExists = ((MobEntityAccessor)mob).getGoalSelector().method_35115().stream().anyMatch(prioritizedGoal -> prioritizedGoal.method_19058() instanceof LeaderAttractionGoal);
            if (!leaderGoalExists) {
                ((MobEntityAccessor)mob).getGoalSelector().method_6277(0, (class_1352)new LeaderAttractionGoal(mob, moveSpeed));
            }
            if (!(followerGoalExists = ((MobEntityAccessor)mob).getGoalSelector().method_35115().stream().anyMatch(prioritizedGoal -> prioritizedGoal.method_19058() instanceof FollowerEdgeRelayGoal))) {
                ((MobEntityAccessor)mob).getGoalSelector().method_6277(0, (class_1352)new FollowerEdgeRelayGoal(mob, moveSpeed));
            }
        } else {
            boolean attractionGoalExists = ((MobEntityAccessor)mob).getGoalSelector().method_35115().stream().anyMatch(prioritizedGoal -> prioritizedGoal.method_19058() instanceof AttractionGoal);
            if (!attractionGoalExists) {
                ((MobEntityAccessor)mob).getGoalSelector().method_6277(4, (class_1352)new AttractionGoal(mob, moveSpeed));
            }
        }
        boolean followLeaderGoalExists = ((MobEntityAccessor)mob).getGoalSelector().method_35115().stream().anyMatch(prioritizedGoal -> prioritizedGoal.method_19058() instanceof FollowLeaderGoal);
        if (!followLeaderGoalExists) {
            ((MobEntityAccessor)mob).getGoalSelector().method_6277(4, (class_1352)new FollowLeaderGoal(mob, moveSpeed));
        }
    }

    public static void onEntityJoinWorld(class_1308 mob, class_3218 level) {
        if (level.method_8608()) {
            return;
        }
        HashSet<String> attractedTypes = new HashSet<String>();
        for (String o : SoundAttractMod.CONFIG.attractedEntities) {
            attractedTypes.add(o.toString());
        }
        String mobTypeId = class_7923.field_41177.method_10221((Object)mob.method_5864()).toString();
        if (attractedTypes.contains(mobTypeId)) {
            MobGroupManager.updateGroups(level);
        }
    }

    public static class SoundMapping {
        public final class_2960 soundEvent;
        public final int range;
        public final double weight;

        public SoundMapping(class_2960 soundEvent, int range, double weight) {
            this.soundEvent = soundEvent;
            this.range = range;
            this.weight = weight;
        }

        public static SoundMapping forAnimator(Class<?> animatorClass) {
            return null;
        }
    }

    private static enum PlayerAction {
        IDLE,
        CRAWLING,
        SNEAKING,
        WALKING,
        SPRINTING,
        SPRINT_JUMPING;

    }
}

