/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.FovEvents;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.accessor.StealthTargetingAccessor;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.config.MobProfile;
import com.example.soundattract.config.PlayerProfile;
import com.example.soundattract.config.PlayerStance;
import com.example.soundattract.enchantment.EnchantmentConceal;
import com.example.soundattract.enchantment.ModEnchantments;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_4050;
import net.minecraft.class_4057;
import net.minecraft.class_7923;

public class StealthDetectionEvents {
    private static final Map<UUID, GunshotInfo> playerGunshotInfo = new ConcurrentHashMap<UUID, GunshotInfo>();
    private static final Set<UUID> suppressedEdgeDetections = new HashSet<UUID>();
    private static final Map<UUID, Double> camoCache = new HashMap<UUID, Double>();
    private static final Map<UUID, Long> camoCacheTick = new HashMap<UUID, Long>();

    public static void recordSuppressedEdgeDetection(class_1308 mob) {
        if (mob != null) {
            suppressedEdgeDetections.add(mob.method_5667());
        }
    }

    public static boolean consumeSuppressedEdgeDetection(class_1308 mob) {
        return mob != null && suppressedEdgeDetections.remove(mob.method_5667());
    }

    public static void recordPlayerGunshot(class_1657 player, double detectionRange) {
        if (player == null || SoundAttractMod.CONFIG == null) {
            return;
        }
        long timestamp = player.method_37908().method_8510();
        playerGunshotInfo.put(player.method_5667(), new GunshotInfo(detectionRange, timestamp));
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[StealthDetection] Recorded gunshot flash for {} with range {} at tick {}", new Object[]{player.method_5477().getString(), String.format("%.2f", detectionRange), timestamp});
        }
    }

    private static Optional<Double> getActiveGunshotRange(class_1657 player) {
        long duration;
        GunshotInfo info = playerGunshotInfo.get(player.method_5667());
        if (info == null || SoundAttractMod.CONFIG == null) {
            return Optional.empty();
        }
        long currentTime = player.method_37908().method_8510();
        if (currentTime - info.timestamp < (duration = (long)SoundAttractMod.CONFIG.gunshotDetectionDurationTicks)) {
            return Optional.of(info.detectionRange);
        }
        playerGunshotInfo.remove(player.method_5667());
        return Optional.empty();
    }

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            int checkInterval = SoundAttractMod.CONFIG != null ? SoundAttractMod.CONFIG.stealthCheckInterval : 10;
            long tick = server.method_30002().method_8510();
            if (tick % (long)checkInterval != 0L) {
                return;
            }
            for (class_3218 world : server.method_3738()) {
                boolean isNight = world.method_8532() > 13000L && world.method_8532() < 23000L;
                HashSet mobs = new HashSet();
                for (class_1657 player : world.method_18456()) {
                    class_2338 playerPos = player.method_24515();
                    int playerChunkX = playerPos.method_10263() >> 4;
                    int playerChunkZ = playerPos.method_10260() >> 4;
                    for (int dx = -1; dx <= 1; ++dx) {
                        for (int dz = -1; dz <= 1; ++dz) {
                            int chunkX = playerChunkX + dx;
                            int chunkZ = playerChunkZ + dz;
                            class_3215 chunkManager = world.method_14178();
                            class_2818 chunk = chunkManager.method_21730(chunkX, chunkZ);
                            if (chunk == null) continue;
                            class_238 chunkBox = new class_238((double)chunk.method_12004().method_8326(), 0.0, (double)chunk.method_12004().method_8328(), (double)chunk.method_12004().method_8327(), (double)world.method_31605(), (double)chunk.method_12004().method_8329());
                            List mobsInChunk = world.method_8390(class_1308.class, chunkBox, mob -> true);
                            mobs.addAll(mobsInChunk);
                        }
                    }
                }
                if (mobs.contains(null) && SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.warn("[StealthDetectionEvents] getEntitiesByClass returned a null mob entity");
                }
                for (class_1308 mob2 : mobs) {
                    try {
                        boolean isCurrentlyDetectable;
                        class_1657 player;
                        class_1309 patt0$temp = mob2.method_5968();
                        if (!(patt0$temp instanceof class_1657) || !(player = (class_1657)patt0$temp).method_5805() || !(mob2 instanceof StealthTargetingAccessor)) continue;
                        StealthTargetingAccessor accessor = (StealthTargetingAccessor)mob2;
                        boolean bl = isCurrentlyDetectable = FovEvents.isTargetInFov(mob2, (class_1297)player, true) && (double)mob2.method_5739((class_1297)player) <= StealthDetectionEvents.computeFullDetectionRange(mob2, player, (class_1937)world);
                        if (isCurrentlyDetectable) {
                            accessor.soundattract_setLosingTargetTicks(0);
                            continue;
                        }
                        int currentTicks = accessor.soundattract_getLosingTargetTicks();
                        accessor.soundattract_setLosingTargetTicks(currentTicks += checkInterval);
                        int gracePeriodTicks = SoundAttractMod.CONFIG.targetLossGracePeriodTicks;
                        if (currentTicks < gracePeriodTicks) continue;
                        mob2.method_5980(null);
                        accessor.soundattract_setLosingTargetTicks(0);
                        if (!SoundAttractMod.CONFIG.debugLogging) continue;
                        SoundAttractMod.LOGGER.info("[StealthDetectionEvents] {} lost sight of {} for ~{} ticks. Clearing target.", new Object[]{mob2.method_5477().getString(), player.method_5477().getString(), gracePeriodTicks});
                    }
                    catch (Exception ex) {
                        if (!SoundAttractMod.CONFIG.debugLogging) continue;
                        SoundAttractMod.LOGGER.error("[StealthDetectionEvents] Exception in mob tick for mob " + (mob2 != null ? mob2.method_5477().getString() : "null"), (Throwable)ex);
                    }
                }
            }
        });
    }

    public static boolean canMobDetectPlayer(class_1308 mob, class_1657 player) {
        boolean canSee;
        block10: {
            if (mob == null || player == null) {
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.warn("[CanDetectPlayer] Called with null mob or player. Defaulting to detectable.");
                }
                return true;
            }
            if (player.method_7337() || player.method_7325() || !player.method_5805()) {
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[CanDetectPlayer] Player {} is creative/spectator/dead \u2192 NOT detectable by {}.", (Object)player.method_5476().getString(), (Object)mob.method_5476().getString());
                }
                return false;
            }
            canSee = FovEvents.hasSmartLineOfSight(mob, (class_1297)player);
            if (SoundAttractMod.CONFIG.debugLogging && !canSee) {
                SoundAttractMod.LOGGER.info("[CanDetectPlayer] mob.canSee() returned false for {}.", (Object)player.method_5477().getString());
            }
            try {
                if (SoundAttractMod.CONFIG.edgeMobSmartBehavior && canSee) {
                    boolean isEdge = MobGroupManager.isEdgeMobEntity(mob);
                    boolean isDeserter = MobGroupManager.isDeserter(mob);
                    double detectRange = StealthDetectionEvents.computeFullDetectionRange(mob, player, mob.method_37908());
                    if (isEdge && !isDeserter && (double)mob.method_5739((class_1297)player) <= detectRange) {
                        StealthDetectionEvents.recordSuppressedEdgeDetection(mob);
                        if (SoundAttractMod.CONFIG.debugLogging) {
                            SoundAttractMod.LOGGER.info("[CanDetectPlayer] Suppressing EDGE mob {} despite detectability; signaling RAID.", (Object)mob.method_5477().getString());
                        }
                        return false;
                    }
                }
            }
            catch (Throwable t) {
                if (!SoundAttractMod.CONFIG.debugLogging) break block10;
                SoundAttractMod.LOGGER.warn("[CanDetectPlayer] Edge suppression check failed: {}", (Object)t.toString());
            }
        }
        return canSee;
    }

    public static double computeFullDetectionRange(class_1308 mob, class_1657 player, class_1937 level) {
        boolean isMoving;
        int i;
        boolean isDay;
        double range;
        PlayerStance stance = StealthDetectionEvents.determinePlayerStance(player);
        Optional<Double> gunshotRangeOpt = StealthDetectionEvents.getActiveGunshotRange(player);
        if (gunshotRangeOpt.isPresent()) {
            range = gunshotRangeOpt.get();
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[StealthDetection] Player {} has active gunshot flash. Initial range: {}", (Object)player.method_5477().getString(), (Object)String.format("%.2f", range));
            }
            double standingRange = SoundAttractMod.CONFIG.standingDetectionRange;
            double poseReduction = Math.max(0.0, standingRange - (switch (stance) {
                case PlayerStance.CRAWLING -> SoundAttractMod.CONFIG.crawlDetectionRange;
                case PlayerStance.SNEAKING -> SoundAttractMod.CONFIG.sneakDetectionRange;
                default -> standingRange;
            }));
            range -= poseReduction;
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[StealthDetection] Gunshot range adjusted by pose {}. Reduction: {}, New range: {}.", new Object[]{stance, String.format("%.2f", poseReduction), String.format("%.2f", range)});
            }
        } else {
            Optional overrideOpt;
            MobProfile profile = SoundAttractMod.CONFIG.getMatchingProfile(mob);
            Optional<Object> optional = overrideOpt = profile != null ? profile.getDetectionOverride(stance) : Optional.empty();
            if (overrideOpt.isPresent()) {
                range = (Double)overrideOpt.get();
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[StealthDetection] Applied mob profile override for mob {} with stance {} \u2192 range {}", new Object[]{mob.method_5477().getString(), stance, String.format("%.2f", range)});
                }
            } else {
                Optional pOverrideOpt;
                PlayerProfile pProfile = SoundAttractMod.CONFIG.getMatchingPlayerProfile(player);
                Optional<Object> optional2 = pOverrideOpt = pProfile != null ? pProfile.getDetectionOverride(stance) : Optional.empty();
                if (pOverrideOpt.isPresent()) {
                    range = (Double)pOverrideOpt.get();
                    if (SoundAttractMod.CONFIG.debugLogging) {
                        SoundAttractMod.LOGGER.info("[StealthDetection] Applied player profile override for {} with stance {} \u2192 range {}", new Object[]{player.method_5477().getString(), stance, String.format("%.2f", range)});
                    }
                } else {
                    double camo;
                    double base;
                    if (stance == PlayerStance.CRAWLING) {
                        base = SoundAttractMod.CONFIG.crawlDetectionRange;
                        camo = SoundAttractMod.CONFIG.crawlDetectionRangeCamouflage;
                    } else if (stance == PlayerStance.SNEAKING) {
                        base = SoundAttractMod.CONFIG.sneakDetectionRange;
                        camo = SoundAttractMod.CONFIG.sneakDetectionRangeCamouflage;
                    } else {
                        base = SoundAttractMod.CONFIG.standingDetectionRange;
                        camo = SoundAttractMod.CONFIG.standingDetectionRangeCamouflage;
                    }
                    CamouflageFactorResult camoResult = stance == PlayerStance.CRAWLING ? StealthDetectionEvents.getCrawlingCamouflageFactor(player, level) : (stance == PlayerStance.SNEAKING ? StealthDetectionEvents.getSneakingCamouflageFactor(player, level) : StealthDetectionEvents.getStandingCamouflageFactor(player, level));
                    double factor = camoResult.factor;
                    double d = factor <= 0.0 ? base : (range = factor >= 1.0 ? camo : base - (base - camo) * factor);
                }
            }
        }
        if (player.method_6059(class_1294.field_5905)) {
            double invisFactor = SoundAttractMod.CONFIG.invisibilityStealthFactor;
            range *= invisFactor;
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[StealthDetection] {} is invisible \u2192 multiply by {} to get {}", new Object[]{player.method_5477().getString(), String.format("%.2f", invisFactor), String.format("%.2f", range)});
            }
        }
        int effectiveLight = 0;
        class_2338 feet = player.method_24515();
        class_2338 eyes = feet.method_10084();
        long dayTime = level.method_8532() % 24000L;
        boolean bl = isDay = dayTime < 12000L;
        if (level.method_22340(feet)) {
            effectiveLight = Math.max(effectiveLight, level.method_8314(class_1944.field_9282, feet));
            if (isDay && level.method_8311(feet)) {
                effectiveLight = Math.max(effectiveLight, level.method_8314(class_1944.field_9284, feet));
            }
        }
        if (level.method_22340(eyes)) {
            effectiveLight = Math.max(effectiveLight, level.method_8314(class_1944.field_9282, eyes));
            if (isDay && level.method_8311(eyes)) {
                effectiveLight = Math.max(effectiveLight, level.method_8314(class_1944.field_9284, eyes));
            }
        }
        for (class_1799 s : List.of(player.method_6047(), player.method_6079())) {
            class_1792 factor = s.method_7909();
            if (!(factor instanceof class_1747)) continue;
            class_1747 bi = (class_1747)factor;
            class_2680 def = bi.method_7711().method_9564();
            if (!level.method_22340(feet)) continue;
            int emit = def.method_26213();
            effectiveLight = Math.max(effectiveLight, emit);
        }
        double neutral = SoundAttractMod.CONFIG.neutralLightLevel;
        double sensitivity = SoundAttractMod.CONFIG.lightLevelSensitivity;
        double lightEffect = ((double)effectiveLight - neutral) * (sensitivity / 15.0);
        double lightFactor = 1.0 + lightEffect;
        lightFactor = Math.max(SoundAttractMod.CONFIG.minLightFactor, lightFactor);
        lightFactor = Math.min(SoundAttractMod.CONFIG.maxLightFactor, lightFactor);
        range *= lightFactor;
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[StealthDetection] Light: effective={}, factor={}, range={}", new Object[]{effectiveLight, String.format("%.2f", lightFactor), String.format("%.2f", range)});
        }
        if (SoundAttractMod.CONFIG.enableHeldItemPenalty) {
            int heldCount = 0;
            if (!player.method_6047().method_7960()) {
                ++heldCount;
            }
            if (!player.method_6079().method_7960()) {
                ++heldCount;
            }
            double penalty = SoundAttractMod.CONFIG.heldItemPenaltyFactor;
            for (i = 0; i < heldCount; ++i) {
                range *= penalty;
            }
            if (SoundAttractMod.CONFIG.debugLogging && heldCount > 0) {
                SoundAttractMod.LOGGER.info("[StealthDetection] Held\u2010item penalty: {} items \u00d7{} \u2192 {}", new Object[]{heldCount, String.format("%.2f", penalty), String.format("%.2f", range)});
            }
        }
        if (SoundAttractMod.CONFIG.enableEnchantmentPenalty) {
            int enchantedArmorPieces = 0;
            for (class_1799 armor : player.method_31548().field_7548) {
                if (armor.method_7960() || !armor.method_7942() || StealthDetectionEvents.hasConcealmentEnchant(armor)) continue;
                ++enchantedArmorPieces;
            }
            double armorFactor = SoundAttractMod.CONFIG.armorEnchantmentPenaltyFactor;
            for (i = 0; i < enchantedArmorPieces; ++i) {
                range *= armorFactor;
            }
            if (SoundAttractMod.CONFIG.debugLogging && enchantedArmorPieces > 0) {
                SoundAttractMod.LOGGER.info("[StealthDetection] Enchanted armor penalty: {} pieces \u00d7{} \u2192 {}", new Object[]{enchantedArmorPieces, String.format("%.2f", armorFactor), String.format("%.2f", range)});
            }
            int enchantedHeldItems = 0;
            if (!player.method_6047().method_7960() && player.method_6047().method_7942() && !StealthDetectionEvents.hasConcealmentEnchant(player.method_6047())) {
                ++enchantedHeldItems;
            }
            if (!player.method_6079().method_7960() && player.method_6079().method_7942() && !StealthDetectionEvents.hasConcealmentEnchant(player.method_6079())) {
                ++enchantedHeldItems;
            }
            double heldEnchantFactor = SoundAttractMod.CONFIG.heldItemEnchantmentPenaltyFactor;
            for (int i2 = 0; i2 < enchantedHeldItems; ++i2) {
                range *= heldEnchantFactor;
            }
            if (SoundAttractMod.CONFIG.debugLogging && enchantedHeldItems > 0) {
                SoundAttractMod.LOGGER.info("[StealthDetection] Enchanted held\u2010item penalty: {} items \u00d7{} \u2192 {}", new Object[]{enchantedHeldItems, String.format("%.2f", heldEnchantFactor), String.format("%.2f", range)});
            }
        }
        if (level.method_8311(player.method_24515()) && level.method_8419()) {
            double rf = SoundAttractMod.CONFIG.rainStealthFactor;
            range *= rf;
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[StealthDetection] Raining bonus \u00d7{} \u2192 {}", (Object)String.format("%.2f", rf), (Object)String.format("%.2f", range));
            }
        }
        if (level.method_8546()) {
            double tf = SoundAttractMod.CONFIG.thunderStealthFactor;
            range *= tf;
            if (SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[StealthDetection] Thundering bonus \u00d7{} \u2192 {}", (Object)String.format("%.2f", tf), (Object)String.format("%.2f", range));
            }
        }
        boolean bl2 = isMoving = player.method_18798().method_1027() > SoundAttractMod.CONFIG.movementThreshold;
        if (stance != PlayerStance.SNEAKING && stance != PlayerStance.CRAWLING) {
            if (isMoving) {
                double mPen = SoundAttractMod.CONFIG.movementStealthPenalty;
                range *= mPen;
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[StealthDetection] Moving penalty (stance={}): \u00d7{} \u2192 {}", new Object[]{stance.name(), String.format("%.2f", mPen), String.format("%.2f", range)});
                }
            } else {
                double sBonus = SoundAttractMod.CONFIG.stationaryStealthBonusFactor;
                range *= sBonus;
                if (SoundAttractMod.CONFIG.debugLogging) {
                    SoundAttractMod.LOGGER.info("[StealthDetection] Stationary bonus (stance={}): \u00d7{} \u2192 {}", new Object[]{stance.name(), String.format("%.2f", sBonus), String.format("%.2f", range)});
                }
            }
        }
        return Math.max(0.0, range);
    }

    private static PlayerStance determinePlayerStance(class_1657 player) {
        boolean crawlingLike;
        class_4050 pose = player.method_18376();
        float poseHeight = player.method_18377((class_4050)pose).field_18068;
        boolean bl = crawlingLike = pose == class_4050.field_18079 || pose == class_4050.field_18077 || pose == class_4050.field_18080 || player.method_5681() || poseHeight <= 1.0f;
        if (crawlingLike) {
            if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[DetermineStance] Player {} treated as CRAWLING (pose={}, isSwimming={}, height={})", new Object[]{player.method_5477().getString(), pose, player.method_5681(), String.format("%.2f", Float.valueOf(poseHeight))});
            }
            return PlayerStance.CRAWLING;
        }
        if (player.method_5715()) {
            return PlayerStance.SNEAKING;
        }
        return PlayerStance.STANDING;
    }

    private static boolean hasConcealmentEnchant(class_1799 stack) {
        if (stack.method_7960() || !stack.method_7942() || ModEnchantments.CONCEAL == null) {
            return false;
        }
        EnchantmentConceal conceal = ModEnchantments.CONCEAL;
        if (conceal == null) {
            if (SoundAttractMod.CONFIG.debugLogging && !stack.method_7960() && stack.method_7942()) {
                SoundAttractMod.LOGGER.warn("[HasConceal] Conceal enchant not resolved for item {}", (Object)stack.method_7964().getString());
            }
            return false;
        }
        return class_1890.method_8225((class_1887)conceal, (class_1799)stack) > 0;
    }

    private static double getStealthCamouflageFactor(class_1657 player, class_1937 level, double mobDist) {
        boolean isCrawl = StealthDetectionEvents.isCrawling(player);
        CamouflageFactorResult camoResult = isCrawl ? StealthDetectionEvents.getCrawlingCamouflageFactor(player, level) : (player.method_5715() ? StealthDetectionEvents.getSneakingCamouflageFactor(player, level) : StealthDetectionEvents.getStandingCamouflageFactor(player, level));
        double factor = camoResult.factor;
        if (SoundAttractMod.CONFIG.camouflageDistanceScaling) {
            double maxDist = SoundAttractMod.CONFIG.camouflageDistanceMax;
            double minEff = SoundAttractMod.CONFIG.camouflageDistanceMinEffectiveness;
            double scale = Math.max(minEff, Math.min(1.0, mobDist / maxDist));
            factor *= 1.0 - scale;
        }
        if (SoundAttractMod.CONFIG.camouflageMovementPenalty) {
            double penalty = 0.0;
            if (player.method_5624()) {
                penalty = SoundAttractMod.CONFIG.camouflageSprintingPenalty;
            } else if (StealthDetectionEvents.isPlayerMoving(player) && !player.method_5715()) {
                penalty = SoundAttractMod.CONFIG.camouflageWalkingPenalty;
            }
            factor *= 1.0 - penalty;
        }
        return Math.max(0.0, Math.min(1.0, factor));
    }

    private static boolean isPlayerMoving(class_1657 player) {
        return player.method_18798().method_1027() > 0.001;
    }

    private static CamouflageFactorResult getAdjacentCamouflageFactor(class_1657 player, class_1937 level) {
        double[] slotWeights = new double[]{0.15, 0.35, 0.25, 0.15};
        List<String> camoSets = SoundAttractMod.CONFIG.camouflageSets;
        String[] equippedIds = new String[4];
        for (int slot = 0; slot < 4; ++slot) {
            class_1799 stack = (class_1799)player.method_31548().field_7548.get(slot);
            if (stack.method_7960()) {
                equippedIds[slot] = null;
                continue;
            }
            class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
            equippedIds[slot] = itemId.toString();
        }
        double bestScore = 0.0;
        int threshold = SoundAttractMod.CONFIG.camouflageColorSimilarityThreshold;
        for (String entry : camoSets) {
            String s;
            String[] parts;
            if (!(entry instanceof String) || (parts = (s = entry).split(";")).length < 5) continue;
            String colorHex = parts[0].toUpperCase();
            double score = 0.0;
            for (int i = 0; i < 4; ++i) {
                int dyedColor;
                String dyedHex;
                class_1792 class_17922;
                String targetArmorId = parts[i + 1];
                String playerArmorId = equippedIds[i];
                double w = slotWeights[i];
                if (playerArmorId != null && playerArmorId.equals(targetArmorId)) {
                    score += w;
                    continue;
                }
                class_1799 stack = (class_1799)player.method_31548().field_7548.get(i);
                if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof class_4057)) continue;
                class_4057 dyeable = (class_4057)class_17922;
                if (((class_1738)stack.method_7909()).method_7686() != class_1740.field_7897 || StealthDetectionEvents.isColorSimilar(dyedHex = String.format("%06X", dyedColor = dyeable.method_7800(stack) & 0xFFFFFF), colorHex, threshold)) continue;
                score -= w;
            }
            score = Math.max(0.0, Math.min(1.0, score));
            bestScore = Math.max(bestScore, score);
        }
        return new CamouflageFactorResult(bestScore);
    }

    private static CamouflageFactorResult getStandingCamouflageFactor(class_1657 player, class_1937 level) {
        return StealthDetectionEvents.getAdjacentCamouflageFactor(player, level);
    }

    private static CamouflageFactorResult getSneakingCamouflageFactor(class_1657 player, class_1937 level) {
        return StealthDetectionEvents.getAdjacentCamouflageFactor(player, level);
    }

    private static CamouflageFactorResult getCrawlingCamouflageFactor(class_1657 player, class_1937 level) {
        String[] equippedIds = new String[4];
        for (int slot = 0; slot < 4; ++slot) {
            class_1799 stack = (class_1799)player.method_31548().field_7548.get(slot);
            if (stack.method_7960()) {
                equippedIds[slot] = null;
                continue;
            }
            class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
            equippedIds[slot] = itemId.toString();
        }
        double bestScore = 0.0;
        int threshold = SoundAttractMod.CONFIG.camouflageColorSimilarityThreshold;
        double[] slotWeights = new double[]{0.15, 0.35, 0.25, 0.15};
        for (String entry : SoundAttractMod.CONFIG.camouflageSets) {
            String s;
            String[] parts;
            if (!(entry instanceof String) || (parts = (s = entry).split(";")).length < 5) continue;
            String colorHex = parts[0].toUpperCase();
            double score = 0.0;
            for (int i = 0; i < 4; ++i) {
                int dyedColor;
                String dyedHex;
                class_1792 class_17922;
                String targetArmorId = parts[i + 1];
                String playerArmorId = equippedIds[i];
                double w = slotWeights[i];
                if (playerArmorId != null && playerArmorId.equals(targetArmorId)) {
                    score += w;
                    continue;
                }
                class_1799 stack = (class_1799)player.method_31548().field_7548.get(i);
                if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof class_4057)) continue;
                class_4057 dyeable = (class_4057)class_17922;
                if (((class_1738)stack.method_7909()).method_7686() != class_1740.field_7897 || StealthDetectionEvents.isColorSimilar(dyedHex = String.format("%06X", dyedColor = dyeable.method_7800(stack) & 0xFFFFFF), colorHex, threshold)) continue;
                score -= w;
            }
            score = Math.max(0.0, Math.min(1.0, score));
            bestScore = Math.max(bestScore, score);
        }
        return new CamouflageFactorResult(bestScore);
    }

    private static boolean isCrawling(class_1657 player) {
        class_4050 pose = player.method_18376();
        float poseHeight = player.method_18377((class_4050)pose).field_18068;
        return pose == class_4050.field_18079 || pose == class_4050.field_18077 || pose == class_4050.field_18080 || player.method_5681() || poseHeight <= 1.0f;
    }

    private static String getCamouflageArmorColorHex(class_1657 player) {
        class_1792 parts;
        List<String> camoSets = SoundAttractMod.CONFIG.camouflageSets;
        String[] equippedIds = new String[4];
        for (int slot = 0; slot < 4; ++slot) {
            class_1799 stack = (class_1799)player.method_31548().field_7548.get(slot);
            if (stack.method_7960()) {
                equippedIds[slot] = null;
                continue;
            }
            class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
            equippedIds[slot] = itemId.toString();
        }
        for (String entry : camoSets) {
            String s;
            if (!(entry instanceof String) || ((String[])(parts = (s = entry).split(";"))).length < 5) continue;
            boolean matchesArmor = true;
            for (int i = 0; i < 4; ++i) {
                if (equippedIds[i] != null && equippedIds[i].equals(parts[i + 1])) continue;
                matchesArmor = false;
                break;
            }
            if (!matchesArmor) continue;
            return parts[0].toUpperCase();
        }
        for (class_1799 stack : player.method_31548().field_7548) {
            class_1792 matchesArmor;
            class_1738 armor;
            if (stack.method_7960() || !((parts = stack.method_7909()) instanceof class_1738) || (armor = (class_1738)parts).method_7686() != class_1740.field_7897 || !((matchesArmor = stack.method_7909()) instanceof class_4057)) continue;
            class_4057 dyeable = (class_4057)matchesArmor;
            int color = dyeable.method_7800(stack);
            return String.format("%06X", color & 0xFFFFFF);
        }
        return null;
    }

    private static boolean isPlayerCamouflaged(class_1657 player, class_1937 level, String stance) {
        List<String> camoSets = SoundAttractMod.CONFIG.camouflageSets;
        String[] equippedIds = new String[4];
        for (int slot = 0; slot < 4; ++slot) {
            class_1799 stack = (class_1799)player.method_31548().field_7548.get(slot);
            if (stack.method_7960()) {
                equippedIds[slot] = null;
                continue;
            }
            class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
            equippedIds[slot] = itemId.toString();
        }
        String armorColor = StealthDetectionEvents.getCamouflageArmorColorHex(player);
        if (armorColor == null) {
            return false;
        }
        for (String entry : camoSets) {
            String s;
            String[] parts;
            if (!(entry instanceof String) || (parts = (s = entry).split(";")).length < 5 || !armorColor.equalsIgnoreCase(parts[0])) continue;
            boolean matchesArmor = true;
            for (int i = 0; i < 4; ++i) {
                if (equippedIds[i] != null && equippedIds[i].equals(parts[i + 1])) continue;
                matchesArmor = false;
                break;
            }
            if (!matchesArmor) continue;
            return true;
        }
        return false;
    }

    private static boolean isColorSimilar(String hex1, String hex2, int threshold) {
        try {
            int c1 = Integer.parseInt(hex1, 16);
            int c2 = Integer.parseInt(hex2, 16);
            int r1 = c1 >> 16 & 0xFF;
            int g1 = c1 >> 8 & 0xFF;
            int b1 = c1 & 0xFF;
            int r2 = c2 >> 16 & 0xFF;
            int g2 = c2 >> 8 & 0xFF;
            int b2 = c2 & 0xFF;
            int dr = r1 - r2;
            int dg = g1 - g2;
            int db = b1 - b2;
            return dr * dr + dg * dg + db * db <= threshold * threshold;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static class GunshotInfo {
        public final double detectionRange;
        public final long timestamp;

        public GunshotInfo(double detectionRange, long timestamp) {
            this.detectionRange = detectionRange;
            this.timestamp = timestamp;
        }
    }

    private static class CamouflageFactorResult {
        public final double factor;

        public CamouflageFactorResult(double factor) {
            this.factor = factor;
        }
    }
}

