/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1308;
import net.minecraft.class_2338;

public class EdgeRelayManager {
    private static final Map<UUID, RelayState> relayStates = new HashMap<UUID, RelayState>();

    public static void startRelay(class_1308 edgeMob, class_2338 soundSource, long delayMillis, long currentTimeMillis) {
        relayStates.put(edgeMob.method_5667(), new RelayState(soundSource, currentTimeMillis, delayMillis));
    }

    public static RelayState getRelayState(class_1308 edgeMob) {
        return relayStates.get(edgeMob.method_5667());
    }

    public static void cancelRelay(class_1308 edgeMob) {
        RelayState state = relayStates.get(edgeMob.method_5667());
        if (state != null) {
            state.cancelled = true;
            state.investigating = false;
        }
    }

    public static void completeRelay(class_1308 edgeMob) {
        RelayState state = relayStates.get(edgeMob.method_5667());
        if (state != null) {
            state.completed = true;
            state.investigating = false;
        }
    }

    public static void cleanupExpired(long currentTimeMillis) {
        relayStates.entrySet().removeIf(entry -> {
            RelayState state = (RelayState)entry.getValue();
            return state.completed || state.cancelled || currentTimeMillis - state.startTime > state.delayMillis + 60000L;
        });
    }

    public static class RelayState {
        public final class_2338 soundSource;
        public final long startTime;
        public final long delayMillis;
        public boolean investigating = true;
        public boolean cancelled = false;
        public boolean completed = false;

        public RelayState(class_2338 soundSource, long startTime, long delayMillis) {
            this.soundSource = soundSource;
            this.startTime = startTime;
            this.delayMillis = delayMillis;
        }
    }
}

