/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.class_1308;
import net.minecraft.class_2338;

public class SpatialPartitionModule {
    public static final int DEFAULT_CELL_SIZE = 64;
    public static int cellSize = 64;
    public static int cellShift = 6;
    public static final Long2ObjectOpenHashMap<LongOpenHashSet> cellToMobUuids = new Long2ObjectOpenHashMap();
    public static final Object2LongOpenHashMap<UUID> mobUuidToCellKey = new Object2LongOpenHashMap();
    public static final Object2ObjectOpenHashMap<UUID, WeakReference<class_1308>> uuidToMobCache = new Object2ObjectOpenHashMap();
    private static final int DEAD_RING_SIZE = 2048;
    private static final UUID[] deadUuidRing = new UUID[2048];
    private static int deadRingHead = 0;
    private static int deadRingTail = 0;

    public static void addMobToCache(UUID uuid, class_1308 mob) {
        uuidToMobCache.put((Object)uuid, new WeakReference<class_1308>(mob));
    }

    public static void removeMobFromCache(UUID uuid) {
        uuidToMobCache.remove((Object)uuid);
    }

    public static class_1308 getMobFromCache(UUID uuid) {
        WeakReference ref = (WeakReference)uuidToMobCache.get((Object)uuid);
        return ref != null ? (class_1308)ref.get() : null;
    }

    public static long cellKey(class_2338 pos) {
        long cx = pos.method_10263() >> cellShift;
        long cz = pos.method_10260() >> cellShift;
        return cx << 32 ^ cz & 0xFFFFFFFFL;
    }

    public static void addMobToCell(UUID uuid, class_2338 pos) {
        long key = SpatialPartitionModule.cellKey(pos);
        ((LongOpenHashSet)cellToMobUuids.computeIfAbsent(key, k -> new LongOpenHashSet())).add(uuid.getLeastSignificantBits());
        mobUuidToCellKey.put((Object)uuid, key);
    }

    public static void removeMobFromCell(UUID uuid) {
        long key = mobUuidToCellKey.removeLong((Object)uuid);
        if (key == 0L) {
            return;
        }
        LongOpenHashSet set = (LongOpenHashSet)cellToMobUuids.get(key);
        if (set != null) {
            set.remove(uuid.getLeastSignificantBits());
            if (set.isEmpty()) {
                cellToMobUuids.remove(key);
            }
        }
    }

    public static void enqueueDeadUuid(UUID uuid) {
        SpatialPartitionModule.deadUuidRing[SpatialPartitionModule.deadRingHead] = uuid;
        if ((deadRingHead = (deadRingHead + 1) % 2048) == deadRingTail) {
            deadRingTail = (deadRingTail + 1) % 2048;
        }
    }

    public static void cleanupDeadUuids(int n) {
        for (int i = 0; i < n && deadRingTail != deadRingHead; ++i) {
            UUID uuid = deadUuidRing[deadRingTail];
            deadRingTail = (deadRingTail + 1) % 2048;
            SpatialPartitionModule.removeMobFromCell(uuid);
        }
    }

    public static void setCellSize(int size) {
        if (Integer.bitCount(size) != 1) {
            throw new IllegalArgumentException("Cell size must be a power of two");
        }
        cellSize = size;
        cellShift = Integer.numberOfTrailingZeros(size);
    }
}

