/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.config;

import com.example.soundattract.config.SoundAttractConfigData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ConfigLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE = "config/soundattract.json";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SoundAttractConfigData load() {
        File file = new File(CONFIG_FILE);
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                JsonElement userJson = JsonParser.parseReader((Reader)reader);
                JsonObject defaultsJson = GSON.toJsonTree((Object)new SoundAttractConfigData()).getAsJsonObject();
                if (userJson != null && userJson.isJsonObject()) {
                    JsonObject userObj = userJson.getAsJsonObject();
                    ConfigLoader.migrateUserJson(userObj);
                    JsonObject merged = ConfigLoader.deepMergeObjects(userObj, defaultsJson);
                    SoundAttractConfigData mergedConfig = (SoundAttractConfigData)GSON.fromJson((JsonElement)merged, SoundAttractConfigData.class);
                    ConfigLoader.save(mergedConfig);
                    SoundAttractConfigData soundAttractConfigData = mergedConfig;
                    return soundAttractConfigData;
                }
                SoundAttractConfigData cfg = new SoundAttractConfigData();
                ConfigLoader.save(cfg);
                SoundAttractConfigData soundAttractConfigData = cfg;
                return soundAttractConfigData;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        SoundAttractConfigData config = new SoundAttractConfigData();
        ConfigLoader.save(config);
        return config;
    }

    public static void save(SoundAttractConfigData config) {
        try (FileWriter writer = new FileWriter(ConfigLoader.ensureConfigPath());){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String ensureConfigPath() throws IOException {
        File file = new File(CONFIG_FILE);
        File parent = file.getParentFile();
        if (!(parent == null || parent.exists() || parent.mkdirs() || parent.exists())) {
            throw new IOException("Failed to create config directory: " + parent.getAbsolutePath());
        }
        return file.getPath();
    }

    private static void migrateUserJson(JsonObject obj) {
        int version;
        int n = version = obj.has("configSchemaVersion") && obj.get("configSchemaVersion").isJsonPrimitive() ? ConfigLoader.safeGetInt(obj.get("configSchemaVersion"), 0) : 0;
        if (version < 1) {
            ConfigLoader.renameKey(obj, "attractedEntityIds", "attractedEntities");
            ConfigLoader.renameKey(obj, "scanCooldown", "scanCooldownTicks");
            ConfigLoader.renameKey(obj, "nonPlayerSounds", "nonPlayerSoundIdList");
            ConfigLoader.renameKey(obj, "nonPlayerSoundWhitelist", "soundIdWhitelist");
            ConfigLoader.renameKey(obj, "edgeMobSmart", "edgeMobSmartBehavior");
            ConfigLoader.renameKey(obj, "pointblankGunShootRanges", "pointblankGunShootRanges");
            ConfigLoader.renameKey(obj, "pointblankAttachmentReductions", "pointblankAttachmentSoundReductions");
            ConfigLoader.renameKey(obj, "pointblankMuzzleFlashReductionsMap", "pointblankMuzzleFlashReductions");
            obj.addProperty("configSchemaVersion", (Number)1);
        }
    }

    private static void renameKey(JsonObject obj, String oldKey, String newKey) {
        if (!oldKey.equals(newKey) && obj.has(oldKey) && !obj.has(newKey)) {
            obj.add(newKey, obj.get(oldKey));
            obj.remove(oldKey);
        }
    }

    private static int safeGetInt(JsonElement el, int fallback) {
        try {
            if (el != null && el.isJsonPrimitive()) {
                return el.getAsInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fallback;
    }

    private static JsonObject deepMergeObjects(JsonObject user, JsonObject defaults) {
        for (String key : user.keySet()) {
            JsonElement userVal = user.get(key);
            if (!defaults.has(key)) {
                defaults.add(key, userVal);
                continue;
            }
            JsonElement defVal = defaults.get(key);
            if (userVal != null && userVal.isJsonObject() && defVal != null && defVal.isJsonObject()) {
                ConfigLoader.deepMergeObjects(userVal.getAsJsonObject(), defVal.getAsJsonObject());
                continue;
            }
            defaults.add(key, userVal);
        }
        return defaults;
    }
}

