/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.config;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.PlayerStance;
import com.example.soundattract.config.SoundOverride;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1308;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class MobProfile {
    private final String profileName;
    private final String mobIdString;
    @Nullable
    private final class_2960 mobId;
    @Nullable
    private final class_2487 nbtMatcher;
    private final List<SoundOverride> soundOverrides;
    private final Map<PlayerStance, Double> detectionOverrides;

    public MobProfile(String profileName, String mobIdString, @Nullable String nbtMatcherString, List<SoundOverride> soundOverrides, Map<PlayerStance, Double> detectionOverrides) {
        this.profileName = Objects.requireNonNull(profileName, "profileName cannot be null");
        this.mobIdString = Objects.requireNonNull(mobIdString, "mobIdString cannot be null");
        if ("*".equals(mobIdString)) {
            this.mobId = null;
        } else {
            this.mobId = class_2960.method_12829((String)mobIdString);
            if (this.mobId == null) {
                SoundAttractMod.LOGGER.warn("Invalid mobIdString for profile '{}': {}. Will not match specific mob type.", (Object)profileName, (Object)mobIdString);
            }
        }
        class_2487 parsedNbt = null;
        if (nbtMatcherString != null && !nbtMatcherString.trim().isEmpty()) {
            try {
                parsedNbt = class_2522.method_10718((String)nbtMatcherString);
            }
            catch (Exception e) {
                SoundAttractMod.LOGGER.warn("Failed to parse NBT matcher for profile '{}': {}. Error: {}", new Object[]{profileName, nbtMatcherString, e.getMessage()});
            }
        }
        this.nbtMatcher = parsedNbt;
        this.soundOverrides = Collections.unmodifiableList(Objects.requireNonNull(soundOverrides, "soundOverrides cannot be null"));
        this.detectionOverrides = Collections.unmodifiableMap(Objects.requireNonNull(detectionOverrides, "detectionOverrides cannot be null"));
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getMobIdString() {
        return this.mobIdString;
    }

    @Nullable
    public class_2960 getMobId() {
        return this.mobId;
    }

    @Nullable
    public class_2487 getNbtMatcher() {
        return this.nbtMatcher;
    }

    public List<SoundOverride> getSoundOverrides() {
        return this.soundOverrides;
    }

    public Map<PlayerStance, Double> getDetectionOverrides() {
        return this.detectionOverrides;
    }

    public Optional<Double> getDetectionOverride(PlayerStance stance) {
        return Optional.ofNullable(this.detectionOverrides.get((Object)stance));
    }

    public Optional<SoundOverride> getSoundOverride(class_2960 soundId) {
        return this.soundOverrides.stream().filter(override -> override.getSoundId().equals((Object)soundId)).findFirst();
    }

    public boolean matches(class_1308 mob) {
        Optional keyOpt;
        if (this.mobId != null && ((keyOpt = class_7923.field_41177.method_29113((Object)mob.method_5864())).isEmpty() || !this.mobId.equals((Object)((class_5321)keyOpt.get()).method_29177()))) {
            return false;
        }
        if (this.nbtMatcher != null && !this.nbtMatcher.method_33133()) {
            class_2487 mobNbt = new class_2487();
            mob.method_5647(mobNbt);
            if (!this.checkNbt(mobNbt, this.nbtMatcher)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkNbt(class_2487 mobNbt, class_2487 matcherNbt) {
        for (String key : matcherNbt.method_10541()) {
            byte matcherType;
            if (!mobNbt.method_10573(key, (int)(matcherType = matcherNbt.method_10540(key)))) {
                return false;
            }
            if (matcherType == 10) {
                if (this.checkNbt(mobNbt.method_10562(key), matcherNbt.method_10562(key))) continue;
                return false;
            }
            if (matcherType == 9) {
                class_2499 matcherList = (class_2499)matcherNbt.method_10580(key);
                byte elementType = matcherList.method_10711();
                class_2499 mobList = mobNbt.method_10554(key, (int)elementType);
                if (mobList.equals((Object)matcherList)) continue;
                SoundAttractMod.LOGGER.trace("NBT list matching for key '{}' is currently basic. Profile: {}", (Object)key, (Object)this.profileName);
                continue;
            }
            if (mobNbt.method_10580(key).equals((Object)matcherNbt.method_10580(key))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "MobProfile{profileName='" + this.profileName + "', mobIdString='" + this.mobIdString + "'" + (String)(this.mobId != null ? ", mobId=" + String.valueOf(this.mobId) : "") + (String)(this.nbtMatcher != null ? ", nbtMatcher=" + this.nbtMatcher.method_10714() : "") + ", soundOverrides=" + String.valueOf(this.soundOverrides) + ", detectionOverrides=" + String.valueOf(this.detectionOverrides) + "}";
    }
}

