/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundMessage;
import com.example.soundattract.StealthDetectionEvents;
import com.vicmatskiv.pointblank.attachment.Attachment;
import com.vicmatskiv.pointblank.attachment.AttachmentCategory;
import com.vicmatskiv.pointblank.attachment.Attachments;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class PointBlankIntegration {
    public static final class_2960 PB_GUN_SOUND_ID = new class_2960("pointblank", "gun_action");

    public static void onGunShoot(class_3222 player, class_1799 gunStack) {
        class_2960 gunId = class_7923.field_41178.method_10221((Object)gunStack.method_7909());
        double flashRange = SoundAttractMod.CONFIG.gunshotBaseDetectionRange;
        double reduction = 0.0;
        for (class_1799 attachmentStack : Attachments.getAttachments((class_1799)gunStack)) {
            Attachment attachment;
            class_1792 class_17922 = attachmentStack.method_7909();
            if (!(class_17922 instanceof Attachment) || (attachment = (Attachment)class_17922).getCategory() != AttachmentCategory.MUZZLE) continue;
            class_2960 muzzleId = class_7923.field_41178.method_10221((Object)attachmentStack.method_7909());
            reduction += SoundAttractMod.CONFIG.getPointBlankMuzzleFlashReductions().getOrDefault(muzzleId.toString(), 0.0).doubleValue();
        }
        double finalDetectionRange = Math.max(0.0, flashRange - reduction);
        StealthDetectionEvents.recordPlayerGunshot((class_1657)player, finalDetectionRange);
        double[] rangeAndWeight = PointBlankIntegration.calculateShootRangeWeight(gunStack);
        SoundMessage msg = new SoundMessage(PB_GUN_SOUND_ID, player.method_23317(), player.method_23318(), player.method_23321(), player.method_37908().method_27983().method_29177(), Optional.of(player.method_5667()), (int)rangeAndWeight[0], rangeAndWeight[1], null, "shoot;" + String.valueOf(gunId));
        SoundMessage.handle(msg, player);
    }

    public static void onGunReload(class_3222 player, class_1799 gunStack) {
        class_2960 gunId = class_7923.field_41178.method_10221((Object)gunStack.method_7909());
        double[] rangeAndWeight = PointBlankIntegration.calculateReloadRangeWeight(gunStack);
        SoundMessage msg = new SoundMessage(PB_GUN_SOUND_ID, player.method_23317(), player.method_23318(), player.method_23321(), player.method_37908().method_27983().method_29177(), Optional.of(player.method_5667()), (int)rangeAndWeight[0], rangeAndWeight[1], null, "reload;" + String.valueOf(gunId));
        SoundMessage.handle(msg, player);
    }

    private static double[] calculateShootRangeWeight(class_1799 gunStack) {
        class_2960 gunId = class_7923.field_41178.method_10221((Object)gunStack.method_7909());
        double finalRange = SoundAttractMod.CONFIG.getPointBlankGunShootRanges().getOrDefault(gunId.toString(), SoundAttractMod.CONFIG.pointblankShootRange);
        double soundReduction = 0.0;
        for (class_1799 attachmentStack : Attachments.getAttachments((class_1799)gunStack)) {
            class_2960 attachmentId = class_7923.field_41178.method_10221((Object)attachmentStack.method_7909());
            soundReduction += SoundAttractMod.CONFIG.getPointBlankAttachmentSoundReductions().getOrDefault(attachmentId.toString(), 0.0).doubleValue();
        }
        finalRange = Math.max(0.0, finalRange - soundReduction);
        double weight = finalRange / 10.0;
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[PointBlankIntegration] Shoot: Gun='{}', BaseRange={}, Reduction={}, FinalRange={}, Weight={}", new Object[]{gunId, String.format("%.2f", finalRange + soundReduction), String.format("%.2f", soundReduction), String.format("%.2f", finalRange), String.format("%.2f", weight)});
        }
        return new double[]{finalRange, weight};
    }

    private static double[] calculateReloadRangeWeight(class_1799 gunStack) {
        double range = SoundAttractMod.CONFIG.pointblankReloadRange;
        double weight = SoundAttractMod.CONFIG.pointblankReloadWeight;
        if (SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[PointBlankIntegration] Reload: range={}, weight={}", (Object)range, (Object)weight);
        }
        return new double[]{range, weight};
    }
}

