/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundAttractNetwork;
import com.example.soundattract.SoundMessage;
import de.maxhenkel.voicechat.api.events.ClientSoundEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class VoiceChatIntegrationClient {
    public static void handleClientSound(ClientSoundEvent event) {
        if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
            SoundAttractMod.LOGGER.info("[DEBUG_CLIENT] handleClientSound called: isWhispering={}, playerPos=({}, {}, {}), dim={}, uuid={}", new Object[]{event.isWhispering(), class_310.method_1551().field_1724 != null ? class_310.method_1551().field_1724.method_23317() : -1.0, class_310.method_1551().field_1724 != null ? class_310.method_1551().field_1724.method_23318() : -1.0, class_310.method_1551().field_1724 != null ? class_310.method_1551().field_1724.method_23321() : -1.0, class_310.method_1551().field_1687 != null ? class_310.method_1551().field_1687.method_27983().method_29177() : "null", class_310.method_1551().field_1724 != null ? class_310.method_1551().field_1724.method_5667() : "null"});
        }
        class_310 mc = class_310.method_1551();
        class_746 clientPlayer = mc.field_1724;
        class_638 clientWorld = mc.field_1687;
        if (clientPlayer == null || clientWorld == null) {
            SoundAttractMod.LOGGER.warn("[VoiceChatIntegrationClient] Client world or player is null in handleClientSound, skipping event.");
            return;
        }
        short[] rawAudio = event.getRawAudio();
        if (rawAudio == null || rawAudio.length == 0) {
            return;
        }
        double db = VoiceChatIntegrationClient.computePeakDb(rawAudio);
        double normDb = db - -127.0;
        double factor = 0.0;
        List<String> rawMap = SoundAttractMod.CONFIG.voiceChatDbThresholdMap;
        if (rawMap != null && !rawMap.isEmpty()) {
            ArrayList<double[]> pairs = new ArrayList<double[]>();
            for (String entry : rawMap) {
                String[] parts;
                if (entry == null || entry.isEmpty() || (parts = entry.split(":", 2)).length != 2) continue;
                try {
                    double th = Double.parseDouble(parts[0].trim());
                    double mul = Double.parseDouble(parts[1].trim());
                    pairs.add(new double[]{th, mul});
                }
                catch (Exception th) {}
            }
            Collections.sort(pairs, new Comparator<double[]>(){

                @Override
                public int compare(double[] a, double[] b) {
                    return Double.compare(b[0], a[0]);
                }
            });
            for (double[] p : pairs) {
                if (!(normDb >= p[0])) continue;
                factor = p[1];
                break;
            }
        } else {
            factor = normDb >= 50.0 ? 1.0 : (normDb >= 30.0 ? 0.7 : (normDb >= 10.0 ? 0.3 : 0.0));
        }
        boolean isWhispering = event.isWhispering();
        int baseRange = isWhispering ? SoundAttractMod.CONFIG.voiceChatWhisperRange : SoundAttractMod.CONFIG.voiceChatNormalRange;
        double weight = SoundAttractMod.CONFIG.voiceChatWeight;
        int effectiveRange = (int)Math.round((double)baseRange * factor);
        if (effectiveRange <= 0) {
            return;
        }
        double x = clientPlayer.method_23317();
        double y = clientPlayer.method_23318();
        double z = clientPlayer.method_23321();
        class_2960 dim = clientWorld.method_27983().method_29177();
        Optional<UUID> sourcePlayerUUID = Optional.of(clientPlayer.method_5667());
        SoundMessage msg = new SoundMessage(SoundMessage.VOICE_CHAT_SOUND_ID, x, y, z, dim, sourcePlayerUUID, effectiveRange, weight);
        SoundAttractNetwork.sendSoundMessageToServer(msg);
    }

    private static double computePeakDb(short[] samples) {
        int highest = 0;
        for (short s : samples) {
            int a = Math.abs(s);
            if (a <= highest) continue;
            highest = (short)a;
        }
        if (highest == 0) {
            return -127.0;
        }
        double norm = (double)Math.abs(highest) / 32768.0;
        double db = 20.0 * Math.log10(norm);
        if (!Double.isFinite(db)) {
            return -127.0;
        }
        if (db > 0.0) {
            db = 0.0;
        }
        if (db < -127.0) {
            db = -127.0;
        }
        return db;
    }
}

