/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.mixin;

import com.example.soundattract.FovEvents;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.StealthDetectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1413;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1413.class})
public abstract class MobVisibilityCacheMixin {
    @Accessor(value="owner")
    abstract class_1308 getOwner();

    @Inject(method={"canSee(Lnet/minecraft/entity/Entity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void soundattract$onCanSee(class_1297 entity, CallbackInfoReturnable<Boolean> cir) {
        double detectionRange;
        class_1937 class_19372;
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        class_1308 mob = this.getOwner();
        if (mob == null || !((class_19372 = mob.method_37908()) instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        if (!FovEvents.isTargetInFov(mob, (class_1297)player, false)) {
            cir.setReturnValue((Object)false);
            return;
        }
        double dist = mob.method_5739((class_1297)player);
        if (dist > (detectionRange = StealthDetectionEvents.computeFullDetectionRange(mob, player, (class_1937)world))) {
            if (SoundAttractMod.CONFIG != null && SoundAttractMod.CONFIG.debugLogging) {
                SoundAttractMod.LOGGER.info("[MobVisibilityCacheMixin] Mob {} cannot see {}: out of range (dist {:.2f} > allowed {:.2f})", new Object[]{mob.method_5477().getString(), player.method_5477().getString(), dist, detectionRange});
            }
            cir.setReturnValue((Object)false);
            return;
        }
        boolean visible = FovEvents.hasSmartLineOfSight(mob, (class_1297)player);
        cir.setReturnValue((Object)visible);
    }
}

