/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.config.SoundAttractConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="soundattract")
public class FovEvents {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final double BACKSTAB_DAMAGE_MULTIPLIER = 1.2;
    private static FovData CONFIG_DEFAULT_FOV = null;
    private static final Set<EntityType<?>> DEVELOPER_EXCLUSIONS = Set.of(EntityType.f_217015_, EntityType.f_20565_, EntityType.f_20496_);
    private static Map<ResourceLocation, FovData> CONFIG_FOV_CACHE = null;
    private static Set<ResourceLocation> USER_EXCLUSION_CACHE = null;

    private static void buildCaches() {
        double defaultH = (Double)SoundAttractConfig.COMMON.defaultHorizontalFov.get();
        double defaultV = (Double)SoundAttractConfig.COMMON.defaultVerticalFov.get();
        CONFIG_DEFAULT_FOV = new FovData(defaultH, defaultV);
        LOGGER.info("[FOV Config] Loaded default FOV: {} horizontal, {} vertical.", (Object)defaultH, (Object)defaultV);
        USER_EXCLUSION_CACHE = new HashSet<ResourceLocation>();
        List exclusionList = (List)SoundAttractConfig.COMMON.fovExclusionList.get();
        for (String entry : exclusionList) {
            try {
                ResourceLocation loc = ResourceLocation.m_135820_((String)entry.trim());
                if (loc != null) {
                    USER_EXCLUSION_CACHE.add(loc);
                    continue;
                }
                LOGGER.warn("[FOV Config] Malformed exclusion entry, skipping: " + entry);
            }
            catch (Exception e) {
                LOGGER.error("[FOV Config] Failed to parse exclusion entry: " + entry, (Throwable)e);
            }
        }
        LOGGER.info("[FOV Config] Loaded {} user-defined exclusions.", (Object)USER_EXCLUSION_CACHE.size());
        CONFIG_FOV_CACHE = new HashMap<ResourceLocation, FovData>();
        List overrideList = (List)SoundAttractConfig.COMMON.fovOverrides.get();
        for (String entry : overrideList) {
            try {
                String[] parts = entry.split(",");
                if (parts.length != 3) {
                    LOGGER.warn("[FOV Config] Malformed FOV override, skipping: " + entry);
                    continue;
                }
                ResourceLocation mobId = ResourceLocation.m_135820_((String)parts[0].trim());
                if (mobId == null) {
                    LOGGER.warn("[FOV Config] Malformed mob identifier in override, skipping: " + entry);
                    continue;
                }
                double h = Double.parseDouble(parts[1].trim());
                double v = Double.parseDouble(parts[2].trim());
                CONFIG_FOV_CACHE.put(mobId, new FovData(h, v));
            }
            catch (Exception e) {
                LOGGER.error("[FOV Config] Failed to parse FOV override entry: " + entry, (Throwable)e);
            }
        }
        LOGGER.info("[FOV Config] Loaded {} custom FOV overrides.", (Object)CONFIG_FOV_CACHE.size());
    }

    @SubscribeEvent
    public static void onLivingVisibility(LivingEvent.LivingVisibilityEvent event) {
        if (event.getVisibilityModifier() <= 0.0) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob looker = (Mob)livingEntity;
        Entity target = event.getLookingEntity();
        if (target == null) {
            return;
        }
        if (!FovEvents.isTargetInFov(looker, target, false)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onMobHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        Entity attacker = event.getSource().m_7639_();
        if (attacker == null || attacker == mob) {
            return;
        }
        if (!FovEvents.isTargetInFov(mob, attacker, true)) {
            float originalDamage = event.getAmount();
            float newDamage = (float)((double)originalDamage * 1.2);
            event.setAmount(newDamage);
            if (attacker instanceof Player) {
                mob.f_19853_.m_6263_(null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), SoundEvents.f_12313_, mob.m_5720_(), 1.0f, 1.2f);
            }
        }
    }

    public static boolean isTargetInFov(Mob looker, Entity target, boolean checkObstructions) {
        if (CONFIG_FOV_CACHE == null) {
            FovEvents.buildCaches();
        }
        ResourceLocation lookerId = EntityType.m_20613_((EntityType)looker.m_6095_());
        if (DEVELOPER_EXCLUSIONS.contains(looker.m_6095_())) {
            return true;
        }
        if (USER_EXCLUSION_CACHE.contains(lookerId)) {
            return true;
        }
        FovData fov = CONFIG_FOV_CACHE.getOrDefault(lookerId, CONFIG_DEFAULT_FOV);
        if (fov.horizontal() >= 360.0) {
            return true;
        }
        if (checkObstructions && !FovEvents.hasSmartLineOfSight(looker, target)) {
            return false;
        }
        return FovEvents.isWithinFieldOfView(looker, target, fov.horizontal(), fov.vertical());
    }

    public static boolean hasSmartLineOfSight(Mob looker, Entity target) {
        Level level = looker.f_19853_;
        Vec3 eyeToEye = target.m_146892_();
        Vec3 center = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.5, 0.0);
        Vec3 feet = target.m_20182_().m_82520_(0.0, Math.max(0.1, (double)target.m_20206_() * 0.15), 0.0);
        Vec3 start = looker.m_146892_();
        return FovEvents.raycastIgnoringNonBlocking(level, start, eyeToEye, looker) || FovEvents.raycastIgnoringNonBlocking(level, start, center, looker) || FovEvents.raycastIgnoringNonBlocking(level, start, feet, looker);
    }

    private static boolean raycastIgnoringNonBlocking(Level level, Vec3 start, Vec3 end, Mob looker) {
        int maxPassThroughs = 24;
        Vec3 currStart = start;
        Vec3 dir = end.m_82546_(start);
        double totalDist = dir.m_82553_();
        if (totalDist < 1.0E-4) {
            return true;
        }
        dir = dir.m_82541_();
        for (int i = 0; i < 24; ++i) {
            ClipContext ctx = new ClipContext(currStart, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)looker);
            BlockHitResult hit = level.m_45547_(ctx);
            if (hit.m_6662_() == HitResult.Type.MISS) {
                return true;
            }
            BlockPos pos = hit.m_82425_();
            BlockState state = level.m_8055_(pos);
            if (!FovEvents.isNonBlockingVision(state, level, pos)) {
                return false;
            }
            Vec3 step = dir.m_82490_(0.6);
            currStart = hit.m_82450_().m_82549_(step);
        }
        return false;
    }

    private static boolean isNonBlockingVision(BlockState state, Level level, BlockPos pos) {
        ResourceLocation id2;
        Boolean open2;
        if (state == null || level == null || pos == null) {
            return false;
        }
        if (state.m_60795_()) {
            return true;
        }
        if (state.m_60734_() instanceof DoorBlock) {
            try {
                open2 = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
                if (open2 != null && open2.booleanValue()) {
                    return true;
                }
            }
            catch (Throwable open2) {
                // empty catch block
            }
        }
        if (state.m_60734_() instanceof TrapDoorBlock) {
            try {
                open2 = (Boolean)state.m_61143_((Property)TrapDoorBlock.f_57514_);
                if (open2 != null && open2.booleanValue()) {
                    return true;
                }
            }
            catch (Throwable open3) {
                // empty catch block
            }
        }
        try {
            id2 = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
            if (id2 != null) {
                if (SoundAttractConfig.NON_BLOCKING_VISION_ALLOW_CACHE.isEmpty()) {
                    List list;
                    List list2 = list = SoundAttractConfig.COMMON != null ? (List)SoundAttractConfig.COMMON.nonBlockingVisionAllowList.get() : Collections.emptyList();
                    if (list != null && !list.isEmpty()) {
                        SoundAttractConfig.parseAndCacheNonBlockingVisionAllowList();
                    }
                }
                if (SoundAttractConfig.NON_BLOCKING_VISION_ALLOW_CACHE.contains(id2)) {
                    return true;
                }
            }
        }
        catch (Throwable id2) {
            // empty catch block
        }
        try {
            String path;
            id2 = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
            String string = path = id2 != null ? id2.m_135815_() : "";
            if (path.contains("glass") && !path.contains("tinted")) {
                return true;
            }
        }
        catch (Throwable id3) {
            // empty catch block
        }
        if (state.m_60734_() instanceof IceBlock || state.m_60713_(Blocks.f_50354_) || state.m_60713_(Blocks.f_50568_)) {
            return true;
        }
        if (state.m_60734_() instanceof FenceBlock || state.m_60734_() instanceof WallBlock || state.m_60734_() instanceof IronBarsBlock) {
            return true;
        }
        try {
            VoxelShape shape = state.m_60742_((BlockGetter)level, pos, CollisionContext.m_82749_());
            if (shape.m_83281_()) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!state.m_60831_((BlockGetter)level, pos)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean isWithinFieldOfView(Mob looker, Entity target, double horizontalFovDegrees, double verticalFovDegrees) {
        Vec3 targetHorizontal;
        Vec3 lookVector = looker.m_20154_();
        Vec3 toTargetVector = target.m_20182_().m_82520_(0.0, (double)target.m_20192_() / 2.0, 0.0).m_82546_(looker.m_146892_()).m_82541_();
        Vec3 lookHorizontal = new Vec3(lookVector.f_82479_, 0.0, lookVector.f_82481_).m_82541_();
        double dotHorizontal = lookHorizontal.m_82526_(targetHorizontal = new Vec3(toTargetVector.f_82479_, 0.0, toTargetVector.f_82481_).m_82541_());
        double angleHorizontal = Math.toDegrees(Math.acos(Math.max(-1.0, Math.min(1.0, dotHorizontal))));
        if (angleHorizontal > horizontalFovDegrees / 2.0) {
            return false;
        }
        double pitchLook = Math.toDegrees(Math.asin(lookVector.f_82480_));
        double pitchTarget = Math.toDegrees(Math.asin(Math.max(-1.0, Math.min(1.0, toTargetVector.f_82480_))));
        double angleVertical = Math.abs(pitchTarget - pitchLook);
        return angleVertical <= verticalFovDegrees / 2.0;
    }

    private record FovData(double horizontal, double vertical) {
    }
}

