/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.DynamicScanCooldownManager;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundAttractionEvents;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.StealthDetectionEvents;
import com.example.soundattract.ai.BlockBreakerManager;
import com.example.soundattract.ai.BlockBreakerPosGoal;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.config.MobProfile;
import com.example.soundattract.config.PlayerStance;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.integration.EnhancedAICompat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class AttractionGoal
extends Goal {
    private final Mob mob;
    private final double moveSpeed;
    private BlockPos targetSoundPos;
    private double currentTargetWeight = -1.0;
    private int scanCooldown = 0;
    private BlockPos lastPos = null;
    private Vec3 lastLeaderPos = null;
    private int stuckTicks = 0;
    private static final int STUCK_THRESHOLD = 10;
    private static final int RECALC_THRESHOLD = 30;
    private int lastSoundTicksRemaining = -1;
    private int scanTickCounter = 0;
    private int scanCooldownCounter = 0;
    private SoundTracker.SoundRecord cachedSound = null;
    private boolean isPursuingSound = false;
    private int pursuingSoundTicksRemaining = 0;
    private int continueEvalCooldown = 0;
    private BlockPos lastContinueEvalPos = null;
    private boolean breakingScheduled = false;
    private BlockBreakerPosGoal scheduledBreakerGoal = null;
    private BlockPos lastBreakerDest = null;
    private EdgeMobState edgeMobState = null;
    private boolean foundPlayerOrHit = false;
    private boolean relayedToLeader = false;
    private int edgeArrivalTicks = 0;
    private static final int EDGE_WAIT_TICKS = 15;
    private SoundTracker.SoundRecord soundResultCache = null;
    private long cacheTick = -1L;
    private static final Map<Mob, DelayedRelay> pendingDelayedRelays = new HashMap<Mob, DelayedRelay>();
    private Vec3 chosenDest = null;
    private boolean hasPicked = false;

    public AttractionGoal(Mob mob, double moveSpeed) {
        this.mob = mob;
        this.moveSpeed = (Double)SoundAttractConfig.COMMON.mobMoveSpeed.get();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    private int scanCooldownTicks() {
        return DynamicScanCooldownManager.currentScanCooldownTicks;
    }

    private boolean isMobEligible() {
        Set<EntityType<?>> attractedTypes = SoundAttractionEvents.getCachedAttractedEntityTypes();
        boolean byType = attractedTypes.contains(this.mob.m_6095_());
        boolean hasProfile = SoundAttractConfig.getMatchingProfile(this.mob) != null;
        return byType || hasProfile;
    }

    private double getArrivalDistance() {
        return (Double)SoundAttractConfig.COMMON.arrivalDistance.get();
    }

    private int getWaitTicks() {
        return (Integer)SoundAttractConfig.COMMON.scanCooldownTicks.get();
    }

    private PlayerStance determinePlayerStance(LivingEntity player) {
        if ((player.m_20089_() == Pose.SWIMMING || player.m_20089_() == Pose.FALL_FLYING || player.m_20089_() == Pose.SPIN_ATTACK) && player.m_20206_() < 1.0f) {
            return PlayerStance.CRAWLING;
        }
        if (player.m_6047_()) {
            return PlayerStance.SNEAKING;
        }
        return PlayerStance.STANDING;
    }

    private double getDetectionRangeForPlayer(LivingEntity player) {
        double baseRange;
        MobProfile mobProfile = SoundAttractConfig.getMatchingProfile(this.mob);
        PlayerStance currentStance = this.determinePlayerStance(player);
        Optional<Object> override = Optional.empty();
        if (mobProfile != null) {
            override = mobProfile.getDetectionOverride(currentStance);
        }
        if (override.isPresent()) {
            baseRange = (Double)override.get();
        } else {
            switch (currentStance) {
                case CRAWLING: {
                    baseRange = (Double)SoundAttractConfig.COMMON.crawlingDetectionRangePlayer.get();
                    break;
                }
                case SNEAKING: {
                    baseRange = (Double)SoundAttractConfig.COMMON.sneakingDetectionRangePlayer.get();
                    break;
                }
                default: {
                    baseRange = (Double)SoundAttractConfig.COMMON.standingDetectionRangePlayer.get();
                }
            }
        }
        boolean hasCamouflage = false;
        int wornCamouflagePieces = 0;
        if (((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get()).booleanValue()) {
            for (ItemStack armorItem : player.m_6168_()) {
                if (armorItem.m_41619_()) continue;
                String itemId = ForgeRegistries.ITEMS.getKey((Object)armorItem.m_41720_()).toString();
                if (!((List)SoundAttractConfig.COMMON.camouflageArmorItems.get()).contains(itemId)) continue;
                ++wornCamouflagePieces;
            }
            if (((Boolean)SoundAttractConfig.COMMON.requireFullSetForCamouflageBonus.get()).booleanValue()) {
                hasCamouflage = wornCamouflagePieces == 4;
            } else {
                boolean bl = hasCamouflage = wornCamouflagePieces > 0;
            }
        }
        if (hasCamouflage) {
            double totalEffectiveness = 0.0;
            ArrayList armorItems = new ArrayList();
            player.m_6168_().forEach(armorItems::add);
            block11: for (int i = 0; i < armorItems.size(); ++i) {
                Item item;
                ResourceLocation itemId;
                ItemStack stack = (ItemStack)armorItems.get(i);
                if (stack.m_41619_() || (itemId = ForgeRegistries.ITEMS.getKey((Object)(item = stack.m_41720_()))) == null || !((List)SoundAttractConfig.COMMON.camouflageArmorItems.get()).contains(itemId.toString())) continue;
                switch (i) {
                    case 3: {
                        totalEffectiveness += ((Double)SoundAttractConfig.COMMON.helmetCamouflageEffectiveness.get()).doubleValue();
                        continue block11;
                    }
                    case 2: {
                        totalEffectiveness += ((Double)SoundAttractConfig.COMMON.chestplateCamouflageEffectiveness.get()).doubleValue();
                        continue block11;
                    }
                    case 1: {
                        totalEffectiveness += ((Double)SoundAttractConfig.COMMON.leggingsCamouflageEffectiveness.get()).doubleValue();
                        continue block11;
                    }
                    case 0: {
                        totalEffectiveness += ((Double)SoundAttractConfig.COMMON.bootsCamouflageEffectiveness.get()).doubleValue();
                    }
                }
            }
            baseRange *= Math.max(0.0, 1.0 - totalEffectiveness);
        }
        return Math.max(0.0, baseRange);
    }

    private boolean shouldSuppressTargeting() {
        return (Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get() != false && StealthDetectionEvents.shouldSuppressTargeting(this.mob);
    }

    public boolean m_8036_() {
        SoundTracker.SoundRecord newSound;
        if (this.mob.m_20160_() || this.mob.m_5803_() || this.shouldSuppressTargeting()) {
            return false;
        }
        if (!this.isMobEligible()) {
            return false;
        }
        boolean smartEdge = (Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get();
        Mob leader = MobGroupManager.getLeader(this.mob);
        if (this.scanCooldownCounter > 0) {
            --this.scanCooldownCounter;
            return false;
        }
        this.scanCooldownCounter = this.scanCooldownTicks();
        if (leader != this.mob && smartEdge) {
            boolean hasRelayedSound;
            SoundTracker.SoundRecord directSound = this.getCachedNearestSound();
            List<MobGroupManager.SoundRelay> relayedSounds = MobGroupManager.consumeRelayedSounds(this.mob);
            boolean hasDirectSound = directSound != null;
            boolean bl = hasRelayedSound = relayedSounds != null && !relayedSounds.isEmpty();
            if (!hasDirectSound && !hasRelayedSound) {
                SoundAttractMod.LOGGER.info("AttractionGoal canUse: Non-leader " + this.mob.m_7755_().getString() + " has no direct or relayed sound in smart edge mode.");
                return false;
            }
        }
        if ((newSound = this.findInterestingSoundRecord()) == null) {
            return false;
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[AttractionGoal] Mob {} found sound: pos={}, range={}, weight={}", new Object[]{this.mob.m_7755_().getString(), newSound.pos, newSound.range, newSound.weight});
        }
        this.targetSoundPos = newSound.pos;
        this.currentTargetWeight = newSound.weight;
        this.lastSoundTicksRemaining = newSound.ticksRemaining;
        this.continueEvalCooldown = Math.max(1, this.scanCooldownTicks() / 2);
        return true;
    }

    public boolean m_8045_() {
        Mob leader;
        if (!this.isMobEligible() || this.mob.m_20160_() || this.mob.m_5803_() || this.shouldSuppressTargeting()) {
            return false;
        }
        if (this.targetSoundPos == null) {
            return false;
        }
        if (this.mob.m_21573_().m_26571_()) {
            BlockPos destination = null;
            Mob leader2 = MobGroupManager.getLeader(this.mob);
            destination = leader2 == this.mob && this.chosenDest != null ? new BlockPos(this.chosenDest) : this.targetSoundPos;
            if (destination != null && this.mob.m_20183_().m_123331_((Vec3i)destination) < 4.0) {
                return false;
            }
        }
        if ((leader = MobGroupManager.getLeader(this.mob)) != this.mob && ((Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get()).booleanValue() && this.mob.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.targetSoundPos)) < this.getArrivalDistance() * this.getArrivalDistance()) {
            return false;
        }
        SoundTracker.SoundRecord bestSoundNow = this.getCachedNearestSound();
        if (bestSoundNow == null) {
            return false;
        }
        if (bestSoundNow.pos.equals((Object)this.targetSoundPos)) {
            this.cachedSound = bestSoundNow;
            this.currentTargetWeight = bestSoundNow.weight;
            this.lastSoundTicksRemaining = bestSoundNow.ticksRemaining;
            this.continueEvalCooldown = Math.max(1, this.scanCooldownTicks() / 2);
            return true;
        }
        double switchRatio = (Double)SoundAttractConfig.COMMON.soundSwitchRatio.get();
        if (bestSoundNow.weight > this.currentTargetWeight * switchRatio) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[AttractionGoal] Mob {} is switching from target {} (weight {}) to {} (weight {})", new Object[]{this.mob.m_7755_().getString(), this.targetSoundPos, this.currentTargetWeight, bestSoundNow.pos, bestSoundNow.weight});
            }
            return false;
        }
        return true;
    }

    private SoundTracker.SoundRecord getCachedNearestSound() {
        long currentTick = this.mob.f_19853_.m_46467_();
        if (this.cacheTick == currentTick) {
            return this.soundResultCache;
        }
        this.cacheTick = currentTick;
        this.soundResultCache = SoundTracker.findNearestSound(this.mob, this.mob.f_19853_, this.mob.m_20183_(), this.mob.m_146892_(), this.cachedSound != null ? this.cachedSound.soundId : null);
        return this.soundResultCache;
    }

    public void m_8041_() {
        boolean smartEdge = (Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get();
        Mob leader = MobGroupManager.getLeader(this.mob);
        this.mob.m_21573_().m_26573_();
        this.targetSoundPos = null;
        this.currentTargetWeight = -1.0;
        this.cachedSound = null;
        this.isPursuingSound = false;
        this.pursuingSoundTicksRemaining = 0;
        if (this.breakingScheduled) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[AttractionGoal] {} leaving BlockBreakerPosGoal running after stop", (Object)this.mob.m_7755_().getString());
            }
            this.breakingScheduled = false;
            this.scheduledBreakerGoal = null;
            this.lastBreakerDest = null;
        }
        try {
            EnhancedAICompat.clearDigging((LivingEntity)this.mob);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("AttractionGoal stop: " + this.mob.m_7755_().getString());
        }
        if (leader != this.mob && smartEdge && this.edgeMobState == EdgeMobState.GOING_TO_SOUND) {
            this.edgeMobState = EdgeMobState.RETURNING_TO_LEADER;
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("Follower " + this.mob.m_7755_().getString() + " transitioning to RETURNING_TO_LEADER.");
            }
            this.edgeArrivalTicks = 0;
        } else {
            this.edgeMobState = null;
        }
        this.foundPlayerOrHit = false;
        this.relayedToLeader = false;
        this.edgeArrivalTicks = 0;
    }

    public void m_8037_() {
        SoundTracker.SoundRecord currentPursuedSound;
        block48: {
            boolean blockBreakingEnabled;
            block47: {
                SoundTracker.SoundRecord fresh = this.findInterestingSoundRecord();
                double switchRatio = (Double)SoundAttractConfig.COMMON.soundSwitchRatio.get();
                if (fresh != null) {
                    if (this.targetSoundPos != null && fresh.pos.equals((Object)this.targetSoundPos)) {
                        this.cachedSound = fresh;
                        this.currentTargetWeight = fresh.weight;
                    } else {
                        boolean isBetterByWeight = this.targetSoundPos == null || fresh.weight > this.currentTargetWeight * switchRatio;
                        boolean isTieButCloser = false;
                        if (!isBetterByWeight && this.targetSoundPos != null && Math.abs(fresh.weight - this.currentTargetWeight) < 0.001) {
                            double currentDistSq;
                            double freshDistSq = fresh.pos.m_123331_((Vec3i)this.mob.m_20183_());
                            boolean bl = isTieButCloser = freshDistSq < (currentDistSq = this.targetSoundPos.m_123331_((Vec3i)this.mob.m_20183_()));
                        }
                        if (isBetterByWeight || isTieButCloser) {
                            this.targetSoundPos = fresh.pos;
                            this.cachedSound = fresh;
                            this.currentTargetWeight = fresh.weight;
                            this.hasPicked = false;
                            this.chosenDest = null;
                            this.edgeMobState = null;
                            this.foundPlayerOrHit = false;
                            this.relayedToLeader = false;
                            this.mob.m_21573_().m_26573_();
                            if (this.breakingScheduled && ((Boolean)SoundAttractConfig.COMMON.enableBlockBreaking.get()).booleanValue()) {
                                try {
                                    BlockBreakerPosGoal newGoal;
                                    double mult = (Double)SoundAttractConfig.COMMON.blockBreakingTimeMultiplier.get();
                                    if (mult < 0.0) {
                                        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                                            SoundAttractMod.LOGGER.info("[AttractionGoal] blockBreakingTimeMultiplier=-1; EnhancedAI time not accessible on 1.19.2, defaulting to 1.5");
                                        }
                                        mult = 1.5;
                                    }
                                    boolean toolOnly = (Boolean)SoundAttractConfig.COMMON.blockBreakingToolOnly.get();
                                    boolean properOnly = (Boolean)SoundAttractConfig.COMMON.blockBreakingProperToolOnly.get();
                                    this.scheduledBreakerGoal = newGoal = new BlockBreakerPosGoal(this.mob, this.targetSoundPos, mult, toolOnly, properOnly, properOnly);
                                    BlockBreakerManager.scheduleAdd(this.mob, newGoal, 1);
                                    this.lastBreakerDest = this.targetSoundPos;
                                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                                        SoundAttractMod.LOGGER.info("[AttractionGoal] {} rescheduled BlockBreakerPosGoal towards new target {}", (Object)this.mob.m_7755_().getString(), (Object)this.targetSoundPos);
                                    }
                                }
                                catch (Throwable t) {
                                    if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) break block47;
                                    SoundAttractMod.LOGGER.error("[AttractionGoal] Error while rescheduling BlockBreakerPosGoal for new target", t);
                                }
                            }
                        }
                    }
                }
            }
            if (this.targetSoundPos == null) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("AttractionGoal tick: targetSoundPos is null for " + this.mob.m_7755_().getString() + ", goal will likely stop.");
                }
                return;
            }
            if (this.scanCooldownCounter > 0) {
                --this.scanCooldownCounter;
            }
            double movedSqr = 0.0;
            if (this.lastPos != null) {
                movedSqr = this.mob.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.lastPos));
            }
            boolean incremented = false;
            if (this.lastPos != null && movedSqr < 1.0) {
                ++this.stuckTicks;
                incremented = true;
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue() && (this.stuckTicks == 1 || this.stuckTicks == 5 || this.stuckTicks == 10 || this.stuckTicks % 10 == 0)) {
                    SoundAttractMod.LOGGER.info("[AttractionGoal DEBUG] {} stuckTicks={}, movedSqr={}", new Object[]{this.mob.m_7755_().getString(), this.stuckTicks, String.format("%.3f", movedSqr)});
                }
            } else {
                if (this.stuckTicks > 0 && ((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[AttractionGoal DEBUG] {} unstuck reset. prev stuckTicks={}, movedSqr={}", new Object[]{this.mob.m_7755_().getString(), this.stuckTicks, String.format("%.3f", movedSqr)});
                }
                this.stuckTicks = 0;
            }
            if (this.stuckTicks == 0 || !incremented) {
                this.lastPos = this.mob.m_20183_();
            }
            if ((blockBreakingEnabled = ((Boolean)SoundAttractConfig.COMMON.enableBlockBreaking.get()).booleanValue()) && this.targetSoundPos != null) {
                try {
                    double distToDestSqr;
                    int maxY = EnhancedAICompat.getMaxY();
                    boolean withinY = this.targetSoundPos.m_123342_() <= maxY;
                    Mob leader = MobGroupManager.getLeader(this.mob);
                    BlockPos destination = null;
                    destination = leader == this.mob && this.chosenDest != null ? new BlockPos(this.chosenDest) : this.targetSoundPos;
                    boolean navDone = this.mob.m_21573_().m_26571_();
                    double d = distToDestSqr = destination != null ? this.mob.m_20183_().m_123331_((Vec3i)destination) : -1.0;
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[AttractionGoal DEBUG] {} consider breaker: stuckTicks={}, withinY={}, targetY={}, maxY={}, navDone={}, distToDestSqr={}", new Object[]{this.mob.m_7755_().getString(), this.stuckTicks, withinY, this.targetSoundPos.m_123342_(), maxY, navDone, String.format("%.3f", distToDestSqr)});
                    }
                    if (this.stuckTicks >= 10 && withinY) {
                        double mult = (Double)SoundAttractConfig.COMMON.blockBreakingTimeMultiplier.get();
                        if (mult < 0.0) {
                            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                                SoundAttractMod.LOGGER.info("[AttractionGoal] blockBreakingTimeMultiplier=-1; EnhancedAI time not accessible on 1.19.2, defaulting to 1.5");
                            }
                            mult = 1.5;
                        }
                        boolean toolOnly = (Boolean)SoundAttractConfig.COMMON.blockBreakingToolOnly.get();
                        boolean properOnly = (Boolean)SoundAttractConfig.COMMON.blockBreakingProperToolOnly.get();
                        if (!this.breakingScheduled || this.lastBreakerDest == null || !this.lastBreakerDest.equals((Object)this.targetSoundPos)) {
                            BlockBreakerPosGoal goal;
                            this.scheduledBreakerGoal = goal = new BlockBreakerPosGoal(this.mob, this.targetSoundPos, mult, toolOnly, properOnly, properOnly);
                            BlockBreakerManager.scheduleAdd(this.mob, goal, 1);
                            this.lastBreakerDest = this.targetSoundPos;
                            if (!this.breakingScheduled && ((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                                SoundAttractMod.LOGGER.info("[AttractionGoal] {} scheduled BlockBreakerPosGoal towards {} (priority 1)", (Object)this.mob.m_7755_().getString(), (Object)this.targetSoundPos);
                            } else if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                                SoundAttractMod.LOGGER.info("[AttractionGoal] {} updating BlockBreakerPosGoal towards new dest {} (priority 1)", (Object)this.mob.m_7755_().getString(), (Object)this.targetSoundPos);
                            }
                            this.breakingScheduled = true;
                        }
                    } else if (this.breakingScheduled && !withinY) {
                        if (this.scheduledBreakerGoal != null) {
                            BlockBreakerManager.scheduleRemove(this.mob, this.scheduledBreakerGoal);
                        }
                        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                            SoundAttractMod.LOGGER.info("[AttractionGoal] {} scheduled removal of BlockBreakerPosGoal (destination Y not eligible)", (Object)this.mob.m_7755_().getString());
                        }
                        this.breakingScheduled = false;
                        this.scheduledBreakerGoal = null;
                        this.lastBreakerDest = null;
                    }
                    break block48;
                }
                catch (Throwable t) {
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.error("[AttractionGoal] Error while handling BlockBreakerPosGoal scheduling", t);
                    }
                    break block48;
                }
            }
            if (this.breakingScheduled) {
                try {
                    if (this.scheduledBreakerGoal != null) {
                        BlockBreakerManager.scheduleRemove(this.mob, this.scheduledBreakerGoal);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                this.breakingScheduled = false;
                this.scheduledBreakerGoal = null;
                this.lastBreakerDest = null;
            }
        }
        if ((currentPursuedSound = this.cachedSound) == null || !currentPursuedSound.pos.equals((Object)this.targetSoundPos)) {
            currentPursuedSound = null;
        }
        if (currentPursuedSound == null || currentPursuedSound.ticksRemaining <= 0) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("AttractionGoal tick: Sound at " + this.targetSoundPos + " (from cache) expired or removed for " + this.mob.m_7755_().getString());
            }
            this.targetSoundPos = null;
            return;
        }
        Mob leader = MobGroupManager.getLeader(this.mob);
        if (leader == this.mob) {
            this.handleLeaderTick();
            return;
        }
        boolean smartEdge = (Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get();
        if (leader != null) {
            if (smartEdge) {
                this.handleFollowerSmartEdgeTick(leader);
            } else {
                this.mob.m_21573_().m_26519_((double)this.targetSoundPos.m_123341_(), (double)this.targetSoundPos.m_123342_(), (double)this.targetSoundPos.m_123343_(), this.moveSpeed);
            }
        }
    }

    private void handleLeaderTick() {
        List<MobGroupManager.SoundRelay> relays = MobGroupManager.consumeRelayedSounds(this.mob);
        if (relays != null && !relays.isEmpty()) {
            for (MobGroupManager.SoundRelay relay : relays) {
                SoundEvent relayEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.m_135820_((String)relay.soundId));
                SoundTracker.SoundRecord relayedSoundRecord = new SoundTracker.SoundRecord(relayEvent, relay.soundId, new BlockPos((int)relay.x, (int)relay.y, (int)relay.z), 20, this.mob.f_19853_.m_46472_().m_135782_().toString(), relay.range, relay.weight);
                if (this.cachedSound != null && !(relayedSoundRecord.weight > this.cachedSound.weight * (Double)SoundAttractConfig.COMMON.soundSwitchRatio.get())) continue;
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("Leader " + this.mob.m_7755_().getString() + " switching to relayed sound (ID: " + relay.soundId + ") from follower at " + relayedSoundRecord.pos);
                }
                this.cachedSound = relayedSoundRecord;
                this.targetSoundPos = this.cachedSound.pos;
                this.currentTargetWeight = this.cachedSound.weight;
                this.hasPicked = false;
            }
        }
        if (!this.hasPicked) {
            double arrivalDist = this.getArrivalDistance();
            long seed = this.mob.m_20148_().getMostSignificantBits() ^ this.mob.m_20148_().getLeastSignificantBits() ^ (long)this.targetSoundPos.hashCode();
            Random rand = new Random(seed);
            double angle = rand.nextDouble() * (Math.PI * 2);
            double radius = arrivalDist * Math.sqrt(rand.nextDouble());
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            int blockX = this.targetSoundPos.m_123341_() + (int)Math.floor(offsetX);
            int blockZ = this.targetSoundPos.m_123343_() + (int)Math.floor(offsetZ);
            int groundY = this.mob.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING, blockX, blockZ);
            this.chosenDest = new Vec3((double)blockX + 0.5, (double)groundY, (double)blockZ + 0.5);
            this.hasPicked = true;
        }
        if (this.chosenDest != null) {
            if (this.mob.m_20182_().m_82557_(this.chosenDest) > 2.25) {
                this.mob.m_21573_().m_26519_(this.chosenDest.f_82479_, this.chosenDest.f_82480_, this.chosenDest.f_82481_, this.moveSpeed);
            } else {
                this.hasPicked = false;
                this.chosenDest = null;
            }
        }
    }

    private void handleFollowerSmartEdgeTick(Mob leader) {
        if (this.edgeMobState == null) {
            this.edgeMobState = EdgeMobState.GOING_TO_SOUND;
        }
        if (this.edgeMobState == EdgeMobState.GOING_TO_SOUND) {
            this.mob.m_21573_().m_26519_((double)this.targetSoundPos.m_123341_(), (double)this.targetSoundPos.m_123342_(), (double)this.targetSoundPos.m_123343_(), this.moveSpeed);
            if (this.mob.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.targetSoundPos)) < this.getArrivalDistance() * this.getArrivalDistance()) {
                ++this.edgeArrivalTicks;
                if (this.edgeArrivalTicks >= 15 || this.foundPlayerOrHit) {
                    if (!this.relayedToLeader && this.foundPlayerOrHit && this.cachedSound != null) {
                        MobGroupManager.relaySoundToLeader(this.mob, this.cachedSound.soundId, this.cachedSound.pos.m_123341_(), this.cachedSound.pos.m_123342_(), this.cachedSound.pos.m_123343_(), this.cachedSound.range, this.cachedSound.weight, this.mob.f_19853_.m_46467_());
                        this.relayedToLeader = true;
                    }
                    this.edgeMobState = EdgeMobState.RETURNING_TO_LEADER;
                    this.edgeArrivalTicks = 0;
                }
            } else {
                LivingEntity targetPlayer = this.mob.m_5448_();
                if (targetPlayer instanceof Player && targetPlayer.m_20280_((Entity)this.mob) < this.getDetectionRangeForPlayer(targetPlayer) * this.getDetectionRangeForPlayer(targetPlayer)) {
                    this.foundPlayerOrHit = true;
                }
            }
        } else if (this.edgeMobState == EdgeMobState.RETURNING_TO_LEADER) {
            if (leader != null && !leader.m_213877_() && !leader.m_21224_()) {
                this.mob.m_21573_().m_26519_(leader.m_20185_(), leader.m_20186_(), leader.m_20189_(), this.moveSpeed * 0.8);
                if (this.mob.m_20280_((Entity)leader) < (this.getArrivalDistance() + 2.0) * (this.getArrivalDistance() + 2.0)) {
                    this.targetSoundPos = null;
                    this.edgeMobState = null;
                }
            } else {
                this.targetSoundPos = null;
                this.edgeMobState = null;
            }
        }
    }

    protected SoundTracker.SoundRecord findInterestingSoundRecord() {
        SoundTracker.SoundRecord currentTargetSound;
        Level level = this.mob.f_19853_;
        if (level.m_5776_()) {
            return null;
        }
        BlockPos mobPos = this.mob.m_20183_();
        Vec3 mobEyePos = this.mob.m_20299_(1.0f);
        Mob leader = MobGroupManager.getLeader(this.mob);
        SoundTracker.SoundRecord bestSoundOverall = null;
        if (leader == this.mob) {
            List<MobGroupManager.SoundRelay> relays = MobGroupManager.consumeRelayedSounds(this.mob);
            if (relays != null) {
                for (MobGroupManager.SoundRelay relay : relays) {
                    SoundEvent relayEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.m_135820_((String)relay.soundId));
                    SoundTracker.SoundRecord relayedSound = new SoundTracker.SoundRecord(relayEvent, relay.soundId, new BlockPos((int)relay.x, (int)relay.y, (int)relay.z), 200, level.m_46472_().m_135782_().toString(), relay.range, relay.weight);
                    if (bestSoundOverall != null && !(relayedSound.weight > bestSoundOverall.weight)) continue;
                    bestSoundOverall = relayedSound;
                }
            }
        } else {
            bestSoundOverall = this.getCachedNearestSound();
        }
        if ((currentTargetSound = this.cachedSound) != null && bestSoundOverall != null && !this.areSoundsEffectivelySame(currentTargetSound, bestSoundOverall)) {
            boolean canSwitch;
            double switchRatio = (Double)SoundAttractConfig.COMMON.soundSwitchRatio.get();
            boolean bl = canSwitch = bestSoundOverall.weight > currentTargetSound.weight * switchRatio || Math.abs(bestSoundOverall.weight - currentTargetSound.weight) < 0.001 && bestSoundOverall.pos.m_123331_((Vec3i)mobPos) < currentTargetSound.pos.m_123331_((Vec3i)mobPos);
            if (!canSwitch) {
                return currentTargetSound;
            }
        }
        if (bestSoundOverall != null) {
            this.isPursuingSound = true;
            this.pursuingSoundTicksRemaining = DynamicScanCooldownManager.currentScanCooldownTicks;
        } else if (leader == this.mob) {
            this.isPursuingSound = false;
            this.pursuingSoundTicksRemaining = 0;
        } else if (leader != this.mob && !this.isPursuingSound) {
            this.isPursuingSound = false;
            this.pursuingSoundTicksRemaining = 0;
        }
        this.cachedSound = bestSoundOverall;
        return bestSoundOverall;
    }

    private boolean areSoundsEffectivelySame(SoundTracker.SoundRecord s1, SoundTracker.SoundRecord s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.pos.equals((Object)s2.pos) && s1.soundId != null && s1.soundId.equals(s2.soundId) && Math.abs(s1.range - s2.range) < 0.1 && Math.abs(s1.weight - s2.weight) < 0.01;
    }

    private boolean isPlayerMovementSound(double weight) {
        return weight == 1.2 || weight == 0.6 || weight == 0.2 || weight == 0.1;
    }

    public boolean isPursuingSound() {
        return this.isPursuingSound;
    }

    private static enum EdgeMobState {
        GOING_TO_SOUND,
        RETURNING_TO_LEADER;

    }

    private static class DelayedRelay {
        public final Mob leader;
        public final BlockPos soundPos;
        public final long triggerTime;
        public boolean cancelled = false;

        public DelayedRelay(Mob leader, BlockPos soundPos, long triggerTime) {
            this.leader = leader;
            this.soundPos = soundPos;
            this.triggerTime = triggerTime;
        }
    }
}

