/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class BlockBreakerManager {
    private static final Map<Mob, GoalAction> PENDING_ACTIONS = new ConcurrentHashMap<Mob, GoalAction>();

    public static void scheduleAdd(Mob mob, Goal goal, int priority) {
        PENDING_ACTIONS.put(mob, new GoalAction(ActionType.ADD, goal, priority));
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[BlockBreakerManager] Scheduled ADD for mob {}: goal={}, priority={}", new Object[]{mob != null ? mob.m_7755_().getString() : "null", goal != null ? goal.getClass().getSimpleName() : "null", priority});
        }
    }

    public static void scheduleRemove(Mob mob, Goal goal) {
        if (goal != null) {
            PENDING_ACTIONS.put(mob, new GoalAction(ActionType.REMOVE, goal, 0));
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[BlockBreakerManager] Scheduled REMOVE for mob {}: goal={}", (Object)(mob != null ? mob.m_7755_().getString() : "null"), (Object)goal.getClass().getSimpleName());
            }
        }
    }

    public static void processPendingActions() {
        if (PENDING_ACTIONS.isEmpty()) {
            return;
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[BlockBreakerManager] Processing {} pending action(s)", (Object)PENDING_ACTIONS.size());
        }
        for (Mob mob : PENDING_ACTIONS.keySet()) {
            GoalAction action = PENDING_ACTIONS.remove(mob);
            if (action != null && mob.m_6084_() && !mob.m_213877_()) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[BlockBreakerManager] Applying action {} for mob {}: goal={}", new Object[]{action.type, mob.m_7755_().getString(), action.goal != null ? action.goal.getClass().getSimpleName() : "null"});
                }
                if (action.type == ActionType.ADD) {
                    mob.f_21345_.m_148105_().stream().filter(wrappedGoal -> wrappedGoal.m_26015_().getClass().equals(action.goal.getClass())).findFirst().ifPresent(wrappedGoal -> {
                        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                            SoundAttractMod.LOGGER.info("[BlockBreakerManager] Removing existing goal of same class before ADD: {}", (Object)wrappedGoal.m_26015_().getClass().getSimpleName());
                        }
                        mob.f_21345_.m_25363_(wrappedGoal.m_26015_());
                    });
                    mob.f_21345_.m_25352_(action.priority, action.goal);
                    if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                    SoundAttractMod.LOGGER.info("[BlockBreakerManager] Added goal {} at priority {}", (Object)action.goal.getClass().getSimpleName(), (Object)action.priority);
                    continue;
                }
                if (action.type != ActionType.REMOVE) continue;
                mob.f_21345_.m_25363_(action.goal);
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[BlockBreakerManager] Removed goal {}", (Object)action.goal.getClass().getSimpleName());
                continue;
            }
            if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
            SoundAttractMod.LOGGER.info("[BlockBreakerManager] Skipped action due to null/invalid mob or action");
        }
    }

    private record GoalAction(ActionType type, Goal goal, int priority) {
    }

    private static enum ActionType {
        ADD,
        REMOVE;

    }
}

