/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.integration.EnhancedAICompat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;

public class BlockBreakerPosGoal
extends Goal {
    private final Mob miner;
    private final BlockPos destinationPos;
    private final double reachDistance;
    private final double timeToBreakMultiplier;
    private final List<BlockPos> targetBlocks = new ArrayList<BlockPos>();
    private int tickToBreak = 0;
    private int breakingTick = 0;
    private BlockState blockState = null;
    private int prevBreakProgress = 0;
    private final boolean toolOnly;
    private final boolean properToolOnly;
    private final boolean properToolRequired;
    private boolean approachActive = false;
    private BlockPos pendingBreakPos = null;
    private Vec3 approachPoint = null;

    public BlockBreakerPosGoal(Mob miner, BlockPos destination, double timeToBreakMultiplier, boolean toolOnly, boolean properToolOnly, boolean properToolRequired) {
        this.miner = miner;
        this.destinationPos = destination;
        this.reachDistance = 4.9;
        this.timeToBreakMultiplier = timeToBreakMultiplier;
        this.toolOnly = toolOnly;
        this.properToolOnly = properToolOnly;
        this.properToolRequired = properToolRequired;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.miner.f_19853_.m_46469_().m_46207_(GameRules.f_46132_)) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] canUse FAILED for {}: mobGriefing is false.", (Object)this.miner.m_7755_().getString());
            }
            return false;
        }
        if (this.destinationPos == null) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] canUse FAILED for {}: destinationPos is null.", (Object)this.miner.m_7755_().getString());
            }
            return false;
        }
        if (this.toolOnly && !(this.miner.m_21206_().m_41720_() instanceof DiggerItem)) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] canUse FAILED for {}: toolOnly is true, but no DiggerItem in offhand.", (Object)this.miner.m_7755_().getString());
            }
            return false;
        }
        this.fillTargetBlocks();
        if (this.targetBlocks.isEmpty()) {
            if (!this.prepareApproachIfFar()) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] canUse FAILED for {}: no reachable or far obstruction found.", (Object)this.miner.m_7755_().getString());
                }
                return false;
            }
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] canUse APPROACH for {}: will move closer to {} to get within reach.", (Object)this.miner.m_7755_().getString(), (Object)this.pendingBreakPos);
            }
            return true;
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] canUse PASSED for {}. Target block: {}.", (Object)this.miner.m_7755_().getString(), (Object)this.targetBlocks.get(0));
        }
        return true;
    }

    public boolean m_8045_() {
        if (this.destinationPos == null) {
            return false;
        }
        if (this.approachActive) {
            return true;
        }
        if (this.targetBlocks.isEmpty()) {
            return false;
        }
        if (this.properToolOnly && this.blockState != null && !this.canBreakBlock()) {
            return false;
        }
        return !this.miner.f_19853_.m_8055_(this.targetBlocks.get(0)).m_60795_();
    }

    public void m_8056_() {
        if (this.approachActive) {
            if (this.approachPoint != null) {
                this.miner.m_21573_().m_26519_(this.approachPoint.f_82479_, this.approachPoint.f_82480_, this.approachPoint.f_82481_, 1.0);
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] START APPROACH for {} towards {}.", (Object)this.miner.m_7755_().getString(), (Object)this.approachPoint);
                }
            }
            return;
        }
        if (!this.targetBlocks.isEmpty()) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] STARTING for {}. Beginning to break {}.", (Object)this.miner.m_7755_().getString(), (Object)this.targetBlocks.get(0));
            }
            this.initBlockBreak();
            this.miner.m_21561_(true);
        } else if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] Attempted to START for {}, but targetBlocks was empty.", (Object)this.miner.m_7755_().getString());
        }
    }

    public void m_8041_() {
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] STOPPING for {}.", (Object)this.miner.m_7755_().getString());
        }
        if (!this.targetBlocks.isEmpty()) {
            this.miner.f_19853_.m_6801_(this.miner.m_19879_(), this.targetBlocks.get(0), -1);
            this.targetBlocks.clear();
        }
        this.tickToBreak = 0;
        this.breakingTick = 0;
        this.blockState = null;
        this.prevBreakProgress = 0;
        this.miner.m_21561_(false);
        this.approachActive = false;
        this.pendingBreakPos = null;
        this.approachPoint = null;
    }

    public void m_8037_() {
        Level level;
        if (this.approachActive) {
            Vec3 desired;
            if (this.pendingBreakPos == null) {
                this.approachActive = false;
                return;
            }
            Vec3 hitCenter = Vec3.m_82512_((Vec3i)this.pendingBreakPos);
            double distSqr = this.miner.m_20238_(hitCenter);
            if (distSqr <= this.reachDistance * this.reachDistance) {
                boolean valid;
                BlockState state = this.miner.f_19853_.m_8055_(this.pendingBreakPos);
                boolean bl = valid = !state.m_60795_() && this.pendingBreakPos.m_123342_() <= EnhancedAICompat.getMaxY() && (!state.m_155947_() || !EnhancedAICompat.shouldBlacklistTileEntities()) && state.m_60800_((BlockGetter)this.miner.f_19853_, this.pendingBreakPos) != -1.0f && (EnhancedAICompat.isEmptyBlacklistTag() || !EnhancedAICompat.isBlacklistAsWhitelist() && !state.m_204336_(EnhancedAICompat.getBlockBlacklistTag()) || EnhancedAICompat.isBlacklistAsWhitelist() && state.m_204336_(EnhancedAICompat.getBlockBlacklistTag()));
                if (valid) {
                    this.targetBlocks.clear();
                    this.targetBlocks.add(this.pendingBreakPos);
                    this.approachActive = false;
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] APPROACH COMPLETE for {}: starting to break {}.", (Object)this.miner.m_7755_().getString(), (Object)this.pendingBreakPos);
                    }
                    this.initBlockBreak();
                    this.miner.m_21561_(true);
                } else if (!this.prepareApproachIfFar()) {
                    this.approachActive = false;
                }
                return;
            }
            Vec3 minerPos = this.miner.m_20182_();
            Vec3 dir = hitCenter.m_82546_(minerPos).m_82541_();
            this.approachPoint = desired = hitCenter.m_82546_(dir.m_82490_(Math.max(0.5, this.reachDistance - 1.0)));
            if (this.miner.m_21573_().m_26571_() || this.miner.f_19797_ % 10 == 0) {
                this.miner.m_21573_().m_26519_(desired.f_82479_, desired.f_82480_, desired.f_82481_, 1.0);
            }
            return;
        }
        if (this.targetBlocks.isEmpty()) {
            return;
        }
        if (this.properToolOnly && this.blockState != null && !this.canBreakBlock()) {
            return;
        }
        BlockPos pos = this.targetBlocks.get(0);
        ++this.breakingTick;
        this.miner.m_21563_().m_24946_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        if (this.prevBreakProgress != (int)((float)this.breakingTick / (float)this.tickToBreak * 10.0f)) {
            this.prevBreakProgress = (int)((float)this.breakingTick / (float)this.tickToBreak * 10.0f);
            this.miner.f_19853_.m_6801_(this.miner.m_19879_(), pos, this.prevBreakProgress);
        }
        if (this.breakingTick % 6 == 0) {
            this.miner.m_6674_(InteractionHand.MAIN_HAND);
        }
        if (this.breakingTick % 4 == 0) {
            SoundType soundType = this.blockState.getSoundType((LevelReader)this.miner.f_19853_, pos, (Entity)this.miner);
            this.miner.f_19853_.m_5594_(null, pos, soundType.m_56778_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 8.0f, soundType.m_56774_() * 0.5f);
        }
        if (this.breakingTick >= this.tickToBreak && (level = this.miner.f_19853_) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            boolean allow = ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this.miner, (BlockPos)this.targetBlocks.get(0), (BlockState)this.blockState);
            boolean destroyed = false;
            if (!allow) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] onEntityDestroyBlock cancelled for {} at {} (block: {})", new Object[]{this.miner.m_7755_().getString(), pos, this.blockState.m_60734_().m_49954_().getString()});
                }
            } else {
                destroyed = this.miner.f_19853_.m_46953_(pos, false, (Entity)this.miner);
            }
            if (destroyed) {
                BlockEntity blockentity = this.blockState.m_155947_() ? this.miner.f_19853_.m_7702_(pos) : null;
                List drops = Block.m_49874_((BlockState)this.blockState, (ServerLevel)level2, (BlockPos)pos, (BlockEntity)blockentity, (Entity)this.miner, (ItemStack)this.miner.m_21206_());
                this.blockState.m_222967_(level2, pos, this.miner.m_21206_(), false);
                for (ItemStack itemStack : drops) {
                    level2.m_7967_((Entity)new ItemEntity((Level)level2, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), itemStack));
                }
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] {} destroyed block at {} ({}), drops={} items", new Object[]{this.miner.m_7755_().getString(), pos, this.blockState.m_60734_().m_49954_().getString(), drops.size()});
                }
            } else if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] Failed to destroy block at {} for {} (allow={}, destroyed={})", new Object[]{pos, this.miner.m_7755_().getString(), allow, destroyed});
            }
            this.miner.f_19853_.m_6801_(this.miner.m_19879_(), pos, -1);
            this.targetBlocks.remove(0);
            if (!this.targetBlocks.isEmpty()) {
                this.initBlockBreak();
            }
        }
    }

    private void initBlockBreak() {
        this.blockState = this.miner.f_19853_.m_8055_(this.targetBlocks.get(0));
        this.tickToBreak = this.computeTickToBreak();
        this.breakingTick = 0;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            float hardness = this.blockState.m_60800_((BlockGetter)this.miner.f_19853_, this.targetBlocks.get(0));
            float toolSpeed = this.miner.m_21206_().m_41691_(this.blockState);
            float digSpeed = this.getDigSpeed();
            SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] Init break for {}: block={}, hardness={}, toolSpeed(offhand)={}, digSpeed(eff)={}, canHarvest={}, tickToBreak={}", new Object[]{this.miner.m_7755_().getString(), this.blockState.m_60734_().m_49954_().getString(), Float.valueOf(hardness), Float.valueOf(toolSpeed), Float.valueOf(digSpeed), this.canHarvestBlock(), this.tickToBreak});
        }
    }

    private boolean prepareApproachIfFar() {
        if (this.destinationPos == null) {
            return false;
        }
        Vec3 destinationVec = Vec3.m_82512_((Vec3i)this.destinationPos);
        int mobHeight = Mth.m_14167_((float)this.miner.m_20206_());
        for (int i = 0; i < mobHeight; ++i) {
            boolean blacklistAsWhitelist;
            Vec3 rayStart = this.miner.m_20299_(1.0f).m_82520_(0.0, (double)i, 0.0);
            BlockHitResult rayTraceResult = this.miner.f_19853_.m_45547_(new ClipContext(rayStart, destinationVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.miner));
            if (rayTraceResult.m_6662_() == HitResult.Type.MISS) continue;
            BlockPos hitPos = rayTraceResult.m_82425_();
            BlockState state = this.miner.f_19853_.m_8055_(hitPos);
            if (hitPos.m_123342_() > EnhancedAICompat.getMaxY() || state.m_155947_() && EnhancedAICompat.shouldBlacklistTileEntities() || state.m_60800_((BlockGetter)this.miner.f_19853_, hitPos) == -1.0f || !EnhancedAICompat.isEmptyBlacklistTag() && (!(blacklistAsWhitelist = EnhancedAICompat.isBlacklistAsWhitelist()) && state.m_204336_(EnhancedAICompat.getBlockBlacklistTag()) || blacklistAsWhitelist && !state.m_204336_(EnhancedAICompat.getBlockBlacklistTag()))) continue;
            double distance = this.miner.m_20238_(rayTraceResult.m_82450_());
            if (distance <= this.reachDistance * this.reachDistance) {
                this.targetBlocks.clear();
                this.targetBlocks.add(hitPos);
                return !this.targetBlocks.isEmpty();
            }
            this.pendingBreakPos = hitPos;
            Vec3 hitCenter = Vec3.m_82512_((Vec3i)hitPos);
            Vec3 minerPos = this.miner.m_20182_();
            Vec3 dir = hitCenter.m_82546_(minerPos).m_82541_();
            this.approachPoint = hitCenter.m_82546_(dir.m_82490_(Math.max(0.5, this.reachDistance - 1.0)));
            this.approachActive = true;
            return true;
        }
        return false;
    }

    private void fillTargetBlocks() {
        this.targetBlocks.clear();
        if (this.destinationPos == null) {
            return;
        }
        Vec3 destinationVec = Vec3.m_82512_((Vec3i)this.destinationPos);
        int mobHeight = Mth.m_14167_((float)this.miner.m_20206_());
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] fillTargetBlocks for {}: Raycasting from mob eyes to {}.", (Object)this.miner.m_7755_().getString(), (Object)destinationVec);
        }
        for (int i = 0; i < mobHeight; ++i) {
            boolean blacklistAsWhitelist;
            Vec3 rayStart = this.miner.m_20299_(1.0f).m_82520_(0.0, (double)i, 0.0);
            BlockHitResult rayTraceResult = this.miner.f_19853_.m_45547_(new ClipContext(rayStart, destinationVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.miner));
            if (rayTraceResult.m_6662_() == HitResult.Type.MISS) {
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] -> Raycast MISS. No blocks in the way.");
                continue;
            }
            BlockPos hitPos = rayTraceResult.m_82425_();
            BlockState state = this.miner.f_19853_.m_8055_(hitPos);
            if (this.targetBlocks.contains(hitPos)) continue;
            if (hitPos.m_123342_() > EnhancedAICompat.getMaxY()) {
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] -> FAILED check for {}: Block {} at Y={} is above maxY of {}.", new Object[]{this.miner.m_7755_().getString(), state.m_60734_().m_49954_().getString(), hitPos.m_123342_(), EnhancedAICompat.getMaxY()});
                continue;
            }
            double distance = this.miner.m_20238_(rayTraceResult.m_82450_());
            if (distance > this.reachDistance * this.reachDistance) {
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] -> FAILED check for {}: Block {} is too far away (distSqr {} > {}).", new Object[]{this.miner.m_7755_().getString(), state.m_60734_().m_49954_().getString(), distance, this.reachDistance * this.reachDistance});
                continue;
            }
            if (state.m_155947_() && EnhancedAICompat.shouldBlacklistTileEntities()) {
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] -> FAILED check for {}: Block {} is a blacklisted Tile Entity.", (Object)this.miner.m_7755_().getString(), (Object)state.m_60734_().m_49954_().getString());
                continue;
            }
            if (state.m_60800_((BlockGetter)this.miner.f_19853_, hitPos) == -1.0f) {
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] -> FAILED check for {}: Block {} is unbreakable (destroy speed -1).", (Object)this.miner.m_7755_().getString(), (Object)state.m_60734_().m_49954_().getString());
                continue;
            }
            if (!EnhancedAICompat.isEmptyBlacklistTag() && (!(blacklistAsWhitelist = EnhancedAICompat.isBlacklistAsWhitelist()) && state.m_204336_(EnhancedAICompat.getBlockBlacklistTag()) || blacklistAsWhitelist && !state.m_204336_(EnhancedAICompat.getBlockBlacklistTag()))) {
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] -> FAILED check for {}: Block {} is in the blacklist/not in whitelist.", (Object)this.miner.m_7755_().getString(), (Object)state.m_60734_().m_49954_().getString());
                continue;
            }
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] -> SUCCESS: Found valid block to break: {} at {}.", (Object)state.m_60734_().m_49954_().getString(), (Object)hitPos);
            }
            this.targetBlocks.add(hitPos);
        }
        Collections.reverse(this.targetBlocks);
    }

    private int computeTickToBreak() {
        int canHarvestBlock;
        int n = canHarvestBlock = this.canHarvestBlock() ? 30 : 100;
        if (this.blockState.m_60800_((BlockGetter)this.miner.f_19853_, this.targetBlocks.get(0)) == 0.0f) {
            return 1;
        }
        double diggingSpeed = this.getDigSpeed() / this.blockState.m_60800_((BlockGetter)this.miner.f_19853_, this.targetBlocks.get(0)) / (float)canHarvestBlock;
        return Mth.m_14165_((double)(1.0 / diggingSpeed * this.timeToBreakMultiplier));
    }

    private float getDigSpeed() {
        float digSpeed = this.miner.m_21206_().m_41691_(this.blockState);
        if (digSpeed > 1.0f) {
            int efficiencyLevel = EnchantmentHelper.m_44926_((LivingEntity)this.miner);
            ItemStack itemstack = this.miner.m_21206_();
            if (efficiencyLevel > 0 && !itemstack.m_41619_()) {
                digSpeed += (float)(efficiencyLevel * efficiencyLevel + 1);
            }
        }
        if (MobEffectUtil.m_19584_((LivingEntity)this.miner)) {
            digSpeed *= 1.0f + (float)(MobEffectUtil.m_19586_((LivingEntity)this.miner) + 1) * 0.2f;
        }
        if (this.miner.m_21023_(MobEffects.f_19599_)) {
            float miningFatigueAmplifier = switch (this.miner.m_21124_(MobEffects.f_19599_).m_19564_()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            digSpeed *= miningFatigueAmplifier;
        }
        if (this.miner.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !EnchantmentHelper.m_44934_((LivingEntity)this.miner)) {
            digSpeed /= 5.0f;
        }
        return digSpeed;
    }

    private boolean canBreakBlock() {
        if (!this.blockState.m_60834_() || !this.properToolRequired) {
            return true;
        }
        ItemStack stack = this.miner.m_21206_();
        return !stack.m_41619_() && stack.m_41735_(this.blockState);
    }

    private boolean canHarvestBlock() {
        if (!this.blockState.m_60834_()) {
            return true;
        }
        ItemStack stack = this.miner.m_21206_();
        return !stack.m_41619_() && stack.m_41735_(this.blockState);
    }
}

