/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import java.nio.file.Path;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigHelper {
    private static final int CURRENT_SCHEMA_VERSION = 3;

    public static void register() {
        Path configPath = FMLPaths.CONFIGDIR.get().resolve("soundattract-common.toml");
        ConfigHelper.updateAndMigrateConfig(configPath);
    }

    private static void updateAndMigrateConfig(Path path) {
        SoundAttractMod.LOGGER.debug("Checking config file at {} for corrections and migrations.", (Object)path);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        ConfigHelper.migrateConfig(configData);
        if (!SoundAttractConfig.COMMON_SPEC.isCorrect((CommentedConfig)configData)) {
            SoundAttractMod.LOGGER.info("Configuration file is missing values. Correcting and saving...");
            SoundAttractConfig.COMMON_SPEC.correct((CommentedConfig)configData);
            configData.save();
            SoundAttractMod.LOGGER.info("Configuration file updated successfully.");
        } else {
            SoundAttractMod.LOGGER.debug("Configuration file is up to date.");
        }
        configData.close();
    }

    private static void migrateConfig(CommentedFileConfig config) {
        int configVersion = config.getOptionalInt("internal.configSchemaVersion").orElse(0);
        if (configVersion < 3) {
            SoundAttractMod.LOGGER.info("Old config version ({}) detected. Migrating to version {}...", (Object)configVersion, (Object)3);
            if (configVersion < 1) {
                // empty if block
            }
            if (configVersion < 3) {
                ConfigHelper.renameKey((CommentedConfig)config, "muffling.specialMobProfilesRaw", "profiles.specialMobProfilesRaw");
                ConfigHelper.renameKey((CommentedConfig)config, "muffling.specialPlayerProfilesRaw", "profiles.specialPlayerProfilesRaw");
            }
            config.set("internal.configSchemaVersion", (Object)3);
            SoundAttractMod.LOGGER.info("Config migration complete.");
        }
    }

    private static void renameKey(CommentedConfig config, String oldPath, String newPath) {
        if (config.contains(oldPath)) {
            Object value = config.get(oldPath);
            config.set(newPath, value);
            config.remove(oldPath);
            SoundAttractMod.LOGGER.debug("Migrated config key '{}' to '{}'.", (Object)oldPath, (Object)newPath);
        }
    }
}

