/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration;

import com.example.soundattract.SoundAttractMod;
import insane96mcp.enhancedai.modules.zombie.ai.DiggingGoal;
import insane96mcp.enhancedai.modules.zombie.feature.DiggerZombie;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;

public class EnhancedAICompat {
    public static final String TAG_DIG_POS = "enhancedai:dig_pos";
    private static final boolean IS_ENHANCED_AI_LOADED = ModList.get().isLoaded("enhancedai");
    private static final int DEFAULT_MAX_Y = 256;
    private static final boolean DEFAULT_BLACKLIST_TILES = true;
    private static final boolean DEFAULT_BLACKLIST_AS_WHITELIST = false;
    private static final TagKey<Block> EMPTY_BLACKLIST = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("soundattract", "empty_block_tag"));

    public static int getMaxY() {
        if (!IS_ENHANCED_AI_LOADED) {
            return 256;
        }
        return DiggerZombieProxy.getMaxY();
    }

    public static boolean shouldBlacklistTileEntities() {
        if (!IS_ENHANCED_AI_LOADED) {
            return true;
        }
        return DiggerZombieProxy.blacklistTileEntities();
    }

    public static boolean isBlacklistAsWhitelist() {
        if (!IS_ENHANCED_AI_LOADED) {
            return false;
        }
        try {
            Class<?> DiggerZombie2 = Class.forName("insane96mcp.enhancedai.modules.zombie.feature.DiggerZombie");
            Field blockBlacklistField = DiggerZombie2.getField("blockBlacklist");
            Object blockBlacklist = blockBlacklistField.get(null);
            Field isWhitelistField = blockBlacklist.getClass().getField("isWhitelist");
            return (Boolean)isWhitelistField.get(blockBlacklist);
        }
        catch (Exception e) {
            SoundAttractMod.LOGGER.error("Failed to get isBlacklistAsWhitelist via reflection", (Throwable)e);
            return false;
        }
    }

    public static TagKey<Block> getBlockBlacklistTag() {
        return EMPTY_BLACKLIST;
    }

    public static boolean isEmptyBlacklistTag() {
        return EMPTY_BLACKLIST.f_203868_().equals((Object)new ResourceLocation("soundattract", "empty_block_tag"));
    }

    public static Goal getDiggingGoal(PathfinderMob mob) {
        if (!IS_ENHANCED_AI_LOADED) {
            return null;
        }
        return DiggerZombieProxy.getDiggingGoal(mob);
    }

    public static void addDiggingGoal(PathfinderMob mob) {
        if (!IS_ENHANCED_AI_LOADED) {
            return;
        }
        DiggerZombieProxy.addDiggingGoal(mob);
    }

    public static boolean canStartDigging(LivingEntity entity) {
        if (!IS_ENHANCED_AI_LOADED) {
            return false;
        }
        if (!(entity instanceof Mob)) {
            return false;
        }
        return EnhancedAICompat.isDigger((Mob)entity) && !EnhancedAICompat.isDigging(entity);
    }

    public static boolean isDigger(Mob entity) {
        try {
            Class<?> diggerZombieClass = Class.forName("insane96mcp.enhancedai.modules.zombie.feature.DiggerZombie");
            Method canBeDiggerMethod = diggerZombieClass.getDeclaredMethod("canBeDigger", Mob.class);
            canBeDiggerMethod.setAccessible(true);
            return (Boolean)canBeDiggerMethod.invoke(null, entity);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDigging(LivingEntity entity) {
        if (!IS_ENHANCED_AI_LOADED) {
            return false;
        }
        return entity.getPersistentData().m_128441_(TAG_DIG_POS);
    }

    public static void startDiggingTowards(LivingEntity entity, BlockPos pos) {
        if (!IS_ENHANCED_AI_LOADED || entity == null || pos == null) {
            return;
        }
        try {
            CompoundTag data = entity.getPersistentData();
            data.m_128365_(TAG_DIG_POS, (Tag)NbtUtils.m_129224_((BlockPos)pos));
        }
        catch (Exception e) {
            SoundAttractMod.LOGGER.error("Failed to set EnhancedAI dig position via NBT", (Throwable)e);
        }
    }

    public static void clearDigging(LivingEntity entity) {
        if (!IS_ENHANCED_AI_LOADED || entity == null) {
            return;
        }
        try {
            entity.getPersistentData().m_128473_(TAG_DIG_POS);
        }
        catch (Exception e) {
            SoundAttractMod.LOGGER.error("Failed to clear EnhancedAI dig position via NBT", (Throwable)e);
        }
    }

    private static class DiggerZombieProxy {
        private DiggerZombieProxy() {
        }

        static Goal getDiggingGoal(PathfinderMob mob) {
            for (WrappedGoal prioritizedGoal : mob.f_21345_.m_148105_()) {
                if (!(prioritizedGoal.m_26015_() instanceof DiggingGoal)) continue;
                return prioritizedGoal.m_26015_();
            }
            return null;
        }

        static void addDiggingGoal(PathfinderMob mob) {
            if (!(mob instanceof Zombie)) {
                return;
            }
            Zombie zombie = (Zombie)mob;
            for (WrappedGoal prioritizedGoal : mob.f_21345_.m_148105_()) {
                if (!(prioritizedGoal.m_26015_() instanceof DiggingGoal)) continue;
                return;
            }
            mob.f_21345_.m_25352_(1, (Goal)new DiggingGoal(zombie, 1.0, true, false));
        }

        static int getMaxY() {
            return DiggerZombie.maxYDig;
        }

        static boolean blacklistTileEntities() {
            return DiggerZombie.blacklistTileEntities;
        }
    }
}

