/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundMessage;
import com.example.soundattract.config.SoundAttractConfig;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import su.plo.slib.api.entity.player.McPlayer;
import su.plo.voice.api.addon.AddonInitializer;
import su.plo.voice.api.addon.InjectPlasmoVoice;
import su.plo.voice.api.addon.annotation.Addon;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.capture.PlayerActivationInfo;
import su.plo.voice.api.server.event.audio.source.PlayerSpeakEvent;
import su.plo.voice.api.server.event.audio.source.ServerSourceAudioPacketEvent;
import su.plo.voice.api.server.player.VoicePlayer;

@Addon(id="soundattract", name="Attract to Sound", version="PlasmoVoice", authors={"Paldiu", "Sylsatra"})
public class PlasmoIntegration
implements AddonInitializer {
    @InjectPlasmoVoice
    private PlasmoVoiceServer server;

    public void onAddonInitialize() {
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[PlasmoIntegration] onAddonInitialize: registering voice listener");
        }
        try {
            this.server.getEventBus().register((Object)this, (Object)new VoiceListener());
        }
        catch (Throwable t) {
            SoundAttractMod.LOGGER.warn("[PlasmoIntegration] register(this, listener) failed: {}", (Object)t.toString());
        }
    }

    public void onAddonShutdown() {
        super.onAddonShutdown();
    }

    public static final class VoiceListener {
        @EventSubscribe
        public void voiceActive(PlayerSpeakEvent event) {
            if (!((Boolean)SoundAttractConfig.COMMON.enableVoiceChatIntegration.get()).booleanValue()) {
                return;
            }
            McPlayer mcPlayerObj = event.getPlayer().getInstance();
            if (!(mcPlayerObj instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer mcPlayer = (ServerPlayer)mcPlayerObj;
            int range = (Integer)SoundAttractConfig.COMMON.voiceChatNormalRange.get();
            SoundMessage msg = new SoundMessage(SoundMessage.VOICE_CHAT_SOUND_ID, mcPlayer.m_20185_(), mcPlayer.m_20186_(), mcPlayer.m_20189_(), mcPlayer.f_19853_.m_46472_().m_135782_(), Optional.of(mcPlayer.m_20148_()), range, (Double)SoundAttractConfig.COMMON.voiceChatWeight.get());
            ServerPlayer finalPlayer = mcPlayer;
            mcPlayer.m_20194_().execute(() -> SoundMessage.handle(msg, null));
        }

        @EventSubscribe
        public void onServerSourceAudio(ServerSourceAudioPacketEvent event) {
            if (!((Boolean)SoundAttractConfig.COMMON.enableVoiceChatIntegration.get()).booleanValue()) {
                return;
            }
            try {
                MinecraftServer server;
                int distance = event.getDistance();
                PlayerActivationInfo activationInfo = event.getActivationInfo();
                if (activationInfo == null) {
                    return;
                }
                VoicePlayer voicePlayer = activationInfo.getPlayer();
                if (voicePlayer == null) {
                    return;
                }
                McPlayer playerObj = voicePlayer.getInstance();
                if (playerObj == null) {
                    return;
                }
                ServerPlayer mcPlayer = null;
                if (playerObj instanceof ServerPlayer) {
                    ServerPlayer sp;
                    mcPlayer = sp = (ServerPlayer)playerObj;
                } else {
                    String[] candidateMethods;
                    for (String methodName : candidateMethods = new String[]{"getPlayer", "getMinecraftPlayer", "getHandle", "getInstance"}) {
                        try {
                            ServerPlayer sp2;
                            Method m = playerObj.getClass().getMethod(methodName, new Class[0]);
                            Object inner = m.invoke((Object)playerObj, new Object[0]);
                            if (!(inner instanceof ServerPlayer)) continue;
                            mcPlayer = sp2 = (ServerPlayer)inner;
                            break;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                if (mcPlayer == null) {
                    return;
                }
                int range = distance > 0 ? distance : (Integer)SoundAttractConfig.COMMON.voiceChatNormalRange.get();
                SoundMessage msg = new SoundMessage(SoundMessage.VOICE_CHAT_SOUND_ID, mcPlayer.m_20185_(), mcPlayer.m_20186_(), mcPlayer.m_20189_(), mcPlayer.f_19853_.m_46472_().m_135782_(), Optional.of(mcPlayer.m_20148_()), range, (Double)SoundAttractConfig.COMMON.voiceChatWeight.get());
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[PlasmoIntegration] VOICE_CHAT forwarded via Plasmo: player={} range={} dim={}", new Object[]{mcPlayer.m_36316_().getName(), range, mcPlayer.f_19853_.m_46472_().m_135782_()});
                }
                if ((server = mcPlayer.m_20194_()) == null) {
                    return;
                }
                server.execute(() -> SoundMessage.handle(msg, null));
            }
            catch (Throwable t) {
                SoundAttractMod.LOGGER.error("[PlasmoIntegration] Exception in onServerSourceAudio", t);
            }
        }
    }
}

