/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AddEnchantedBookModifier
extends LootModifier {
    public static final Supplier<Codec<AddEnchantedBookModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AddEnchantedBookModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ENCHANTMENTS.getCodec().fieldOf("enchantment").forGetter(m -> m.enchantment)).and((App)Codec.INT.optionalFieldOf("level", (Object)1).forGetter(m -> m.level)).apply((Applicative)inst, AddEnchantedBookModifier::new)));
    private final Enchantment enchantment;
    private final int level;

    public AddEnchantedBookModifier(LootItemCondition[] conditionsIn, Enchantment enchantment, int level) {
        super(conditionsIn);
        this.enchantment = enchantment;
        this.level = Math.max(1, level);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
        EnchantedBookItem.m_41153_((ItemStack)book, (EnchantmentInstance)new EnchantmentInstance(this.enchantment, this.level));
        generatedLoot.add((Object)book);
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

