/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.nomoon.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.mcreator.nomoon.network.ComputerUIButtonMessage;
import net.mcreator.nomoon.world.inventory.ComputerUIMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class ComputerUIScreen
extends AbstractContainerScreen<ComputerUIMenu> {
    private static final HashMap<String, Object> guistate = ComputerUIMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    EditBox password_code;
    Button button_enter;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"no_moon:textures/screens/computer_ui.png");

    public ComputerUIScreen(ComputerUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.password_code.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.password_code.isFocused()) {
            return this.password_code.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String password_codeValue = this.password_code.getValue();
        super.resize(minecraft, width, height);
        this.password_code.setValue(password_codeValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.no_moon.computer_ui.label_password"), 65, 61, -13421773, false);
    }

    public void init() {
        super.init();
        this.password_code = new EditBox(this, this.font, this.leftPos + 30, this.topPos + 76, 118, 18, (Component)Component.translatable((String)"gui.no_moon.computer_ui.password_code")){

            public void insertText(String text) {
                super.insertText(text);
                if (this.getValue().isEmpty()) {
                    this.setSuggestion(Component.translatable((String)"gui.no_moon.computer_ui.password_code").getString());
                } else {
                    this.setSuggestion(null);
                }
            }

            public void moveCursorTo(int pos, boolean flag) {
                super.moveCursorTo(pos, flag);
                if (this.getValue().isEmpty()) {
                    this.setSuggestion(Component.translatable((String)"gui.no_moon.computer_ui.password_code").getString());
                } else {
                    this.setSuggestion(null);
                }
            }
        };
        this.password_code.setMaxLength(Short.MAX_VALUE);
        this.password_code.setSuggestion(Component.translatable((String)"gui.no_moon.computer_ui.password_code").getString());
        guistate.put("text:password_code", this.password_code);
        this.addWidget((GuiEventListener)this.password_code);
        this.button_enter = Button.builder((Component)Component.translatable((String)"gui.no_moon.computer_ui.button_enter"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new ComputerUIButtonMessage(0, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ComputerUIButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z);
        }).bounds(this.leftPos + 62, this.topPos + 103, 51, 20).build();
        guistate.put("button:button_enter", this.button_enter);
        this.addRenderableWidget((GuiEventListener)this.button_enter);
    }
}

