/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.nomoon.entity;

import javax.annotation.Nullable;
import net.mcreator.nomoon.init.NoMoonModEntities;
import net.mcreator.nomoon.procedures.FakePigEntityDiesProcedure;
import net.mcreator.nomoon.procedures.FakePigOnEntityTickUpdateProcedure;
import net.mcreator.nomoon.procedures.FakePigOnInitialEntitySpawnProcedure;
import net.mcreator.nomoon.procedures.FakeSpawnConditionProcedure;
import net.mcreator.nomoon.procedures.TheBirdTransformAgrProcedure;
import net.mcreator.nomoon.procedures.TheBirdTransformNotAgrProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class FakePigEntity
extends PathfinderMob {
    public FakePigEntity(EntityType<FakePigEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false){

            public boolean canUse() {
                double x = FakePigEntity.this.getX();
                double y = FakePigEntity.this.getY();
                double z = FakePigEntity.this.getZ();
                FakePigEntity entity = FakePigEntity.this;
                Level world = FakePigEntity.this.level();
                return super.canUse() && TheBirdTransformAgrProcedure.execute((LevelAccessor)world);
            }

            public boolean canContinueToUse() {
                double x = FakePigEntity.this.getX();
                double y = FakePigEntity.this.getY();
                double z = FakePigEntity.this.getZ();
                FakePigEntity entity = FakePigEntity.this;
                Level world = FakePigEntity.this.level();
                return super.canContinueToUse() && TheBirdTransformAgrProcedure.execute((LevelAccessor)world);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal(this, 0.8, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = FakePigEntity.this.getX();
                double y = FakePigEntity.this.getY();
                double z = FakePigEntity.this.getZ();
                FakePigEntity entity = FakePigEntity.this;
                Level world = FakePigEntity.this.level();
                return super.canUse() && TheBirdTransformAgrProcedure.execute((LevelAccessor)world);
            }

            public boolean canContinueToUse() {
                double x = FakePigEntity.this.getX();
                double y = FakePigEntity.this.getY();
                double z = FakePigEntity.this.getZ();
                FakePigEntity entity = FakePigEntity.this;
                Level world = FakePigEntity.this.level();
                return super.canContinueToUse() && TheBirdTransformAgrProcedure.execute((LevelAccessor)world);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal(this, 1.0){

            public boolean canUse() {
                double x = FakePigEntity.this.getX();
                double y = FakePigEntity.this.getY();
                double z = FakePigEntity.this.getZ();
                FakePigEntity entity = FakePigEntity.this;
                Level world = FakePigEntity.this.level();
                return super.canUse() && TheBirdTransformNotAgrProcedure.execute((LevelAccessor)world);
            }

            public boolean canContinueToUse() {
                double x = FakePigEntity.this.getX();
                double y = FakePigEntity.this.getY();
                double z = FakePigEntity.this.getZ();
                FakePigEntity entity = FakePigEntity.this;
                Level world = FakePigEntity.this.level();
                return super.canContinueToUse() && TheBirdTransformNotAgrProcedure.execute((LevelAccessor)world);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = FakePigEntity.this.getX();
                double y = FakePigEntity.this.getY();
                double z = FakePigEntity.this.getZ();
                FakePigEntity entity = FakePigEntity.this;
                Level world = FakePigEntity.this.level();
                return super.canUse() && TheBirdTransformNotAgrProcedure.execute((LevelAccessor)world);
            }

            public boolean canContinueToUse() {
                double x = FakePigEntity.this.getX();
                double y = FakePigEntity.this.getY();
                double z = FakePigEntity.this.getZ();
                FakePigEntity entity = FakePigEntity.this;
                Level world = FakePigEntity.this.level();
                return super.canContinueToUse() && TheBirdTransformNotAgrProcedure.execute((LevelAccessor)world);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.pig.ambient"));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.pig.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.pig.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.pig.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof ThrownPotion || damagesource.getDirectEntity() instanceof AreaEffectCloud || damagesource.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (damagesource.is(DamageTypes.TRIDENT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALLING_ANVIL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public void die(DamageSource source) {
        super.die(source);
        FakePigEntityDiesProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), source.getEntity());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        FakePigOnInitialEntitySpawnProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public void baseTick() {
        super.baseTick();
        FakePigOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)NoMoonModEntities.FAKE_PIG.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return FakeSpawnConditionProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.25);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 128.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

