/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.nomoon.entity;

import java.util.Comparator;
import javax.annotation.Nullable;
import net.mcreator.nomoon.NoMoonMod;
import net.mcreator.nomoon.entity.LesserSoulBlackEntity;
import net.mcreator.nomoon.entity.LesserSoulChaseEntity;
import net.mcreator.nomoon.init.NoMoonModBlocks;
import net.mcreator.nomoon.init.NoMoonModEntities;
import net.mcreator.nomoon.init.NoMoonModParticleTypes;
import net.mcreator.nomoon.network.NoMoonModVariables;
import net.mcreator.nomoon.procedures.LesserSoulStalkNaturalEntitySpawningConditionProcedure;
import net.mcreator.nomoon.procedures.LesserSoulStalkOnInitialEntitySpawnProcedure;
import net.mcreator.nomoon.procedures.StopSoundProcedure;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LesserSoulStalkEntity
extends Monster
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(LesserSoulStalkEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(LesserSoulStalkEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(LesserSoulStalkEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public LesserSoulStalkEntity(EntityType<LesserSoulStalkEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"lesser_souls_redesign");
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, ServerPlayer.class, false, true));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (source.getDirectEntity() instanceof ThrownPotion || source.getDirectEntity() instanceof AreaEffectCloud || source.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (source.is(DamageTypes.FALL)) {
            return false;
        }
        if (source.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (source.is(DamageTypes.DROWN)) {
            return false;
        }
        if (source.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (source.is(DamageTypes.EXPLOSION) || source.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (source.is(DamageTypes.TRIDENT)) {
            return false;
        }
        if (source.is(DamageTypes.FALLING_ANVIL)) {
            return false;
        }
        if (source.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (source.is(DamageTypes.WITHER) || source.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        LesserSoulStalkOnInitialEntitySpawnProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
    }

    public void baseTick() {
        ServerLevel _level;
        super.baseTick();
        if (this == null) {
            return;
        }
        double Soul_Water = 0.0;
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Object NonFinalPlayer = null;
        LesserSoulStalkEntity entity = this;
        LesserSoulStalkEntity FinalPlayer = this;
        Level level = entity.level();
        Level world = entity.level();
        if (world.getEntitiesOfClass(Player.class, AABB.ofSize((Vec3)new Vec3(this.getX(), this.getY(), this.getZ()), (double)325.0, (double)325.0, (double)325.0), e -> true).isEmpty()) {
            this.discard();
            return;
        }
        Entity Player2 = world.getEntitiesOfClass(Player.class, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)325.0, (double)325.0, (double)325.0), e -> true).stream().sorted(new Object(this){

            Comparator<Entity> compareDistOf(double _x, double _y, double _z) {
                return Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_x, _y, _z));
            }
        }.compareDistOf(this.getX(), this.getY(), this.getZ())).findFirst().orElse(null);
        FinalPlayer = Player2;
        if (entity.isPassenger() && !NoMoonModVariables.WorldVariables.get((LevelAccessor)world).Boating) {
            entity.stopRiding();
        }
        if (!this.isAggressive()) {
            this.getNavigation().moveTo(FinalPlayer.getX(), FinalPlayer.getY(), FinalPlayer.getZ(), 0.75);
        }
        entity.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3(FinalPlayer.getX(), FinalPlayer.getY() + 1.5, FinalPlayer.getZ()));
        if (entity.isInWater() || entity.isInWall()) {
            entity.push(0.0, 0.2, 0.0);
        }
        if ((NoMoonModVariables.WorldVariables.get((LevelAccessor)world).Disappear_Hunt || level.isDay()) && entity.isAlive() && (!NoMoonModVariables.WorldVariables.get((LevelAccessor)world).Chaotic_Night || NoMoonModVariables.WorldVariables.get((LevelAccessor)world).Chaotic_Night_Type != 2.0 && NoMoonModVariables.WorldVariables.get((LevelAccessor)world).Chaotic_Night_Type != 4.0)) {
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)((SimpleParticleType)NoMoonModParticleTypes.BLACK_BOX.get()), x, y, z, 25, 1.5, 1.5, 1.5, 0.0);
            }
            if (!level.isClientSide()) {
                entity.discard();
            }
        }
        if (this.isAlive() && this.hasLineOfSight((Entity)FinalPlayer) && !world.getEntitiesOfClass(Player.class, AABB.ofSize((Vec3)new Vec3(this.getX(), this.getY(), this.getZ()), (double)24.0, (double)24.0, (double)24.0), e -> true).isEmpty()) {
            this.discard();
            if (world.getEntitiesOfClass(LesserSoulBlackEntity.class, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)325.0, (double)325.0, (double)325.0), e -> true).isEmpty() && world.getEntitiesOfClass(LesserSoulChaseEntity.class, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)325.0, (double)325.0, (double)325.0), e -> true).isEmpty()) {
                NoMoonModVariables.WorldVariables.get((LevelAccessor)world).FOUND_YOU = true;
                NoMoonModVariables.WorldVariables.get((LevelAccessor)world).syncData((LevelAccessor)world);
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    _level.getServer().getCommands().performPrefixedCommand(new CommandSourceStack(CommandSource.NULL, new Vec3(x, y, z), Vec2.ZERO, _level, 4, "", (Component)Component.literal((String)""), _level.getServer(), null).withSuppressedOutput(), "playsound no_moon:found_you_2 hostile @a ~ ~ ~ 100");
                }
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                Entity entityToSpawn = ((EntityType)NoMoonModEntities.LESSER_SOUL_BLACK.get()).spawn(_level, BlockPos.containing((double)x, (double)y, (double)z), MobSpawnType.MOB_SUMMONED);
                if (entityToSpawn != null) {
                    entityToSpawn.setYRot(entity.getYRot());
                    entityToSpawn.setYBodyRot(entity.getYRot());
                    entityToSpawn.setYHeadRot(entity.getYRot());
                    entityToSpawn.setXRot(entity.getXRot());
                    entityToSpawn.setDeltaMovement(0.0, 0.0, 0.0);
                }
            }
            NoMoonMod.queueServerWork(43, () -> LesserSoulStalkEntity.lambda$baseTick$5((LevelAccessor)world, x, y, z));
        }
        if (NoMoonModVariables.WorldVariables.get((LevelAccessor)world).FOUND_YOU && entity.isAlive() && (!NoMoonModVariables.WorldVariables.get((LevelAccessor)world).Chaotic_Night || NoMoonModVariables.WorldVariables.get((LevelAccessor)world).Chaotic_Night_Type != 2.0 && NoMoonModVariables.WorldVariables.get((LevelAccessor)world).Chaotic_Night_Type != 4.0) && !entity.level().isClientSide()) {
            entity.discard();
        }
        if (NoMoonModVariables.WorldVariables.get((LevelAccessor)world).Respawn_Loadup) {
            NoMoonMod.queueServerWork(2400, () -> LesserSoulStalkEntity.lambda$baseTick$6((Entity)entity));
        }
        for (int index0 = 0; index0 < 3; ++index0) {
            if (world.getBlockState(BlockPos.containing((double)(Math.round(entity.getX()) - 1L), (double)(Math.round(entity.getY()) - 1L), (double)((double)Math.round(entity.getZ()) - (1.0 + Soul_Water)))).is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"no_moon:all_liquids")))) {
                world.setBlock(BlockPos.containing((double)(Math.round(entity.getX()) - 1L), (double)(Math.round(entity.getY()) - 1L), (double)((double)Math.round(entity.getZ()) - (1.0 + Soul_Water))), ((Block)NoMoonModBlocks.WATER_COBBLESTONE.get()).defaultBlockState(), 3);
            }
            if (world.getBlockState(BlockPos.containing((double)Math.round(entity.getX()), (double)(Math.round(entity.getY()) - 1L), (double)((double)Math.round(entity.getZ()) - (1.0 + Soul_Water)))).is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"no_moon:all_liquids")))) {
                world.setBlock(BlockPos.containing((double)Math.round(entity.getX()), (double)(Math.round(entity.getY()) - 1L), (double)((double)Math.round(entity.getZ()) - (1.0 + Soul_Water))), ((Block)NoMoonModBlocks.WATER_COBBLESTONE.get()).defaultBlockState(), 3);
            }
            if (world.getBlockState(BlockPos.containing((double)(Math.round(entity.getX()) + 1L), (double)(Math.round(entity.getY()) - 1L), (double)((double)Math.round(entity.getZ()) - (1.0 + Soul_Water)))).is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"no_moon:all_liquids")))) {
                world.setBlock(BlockPos.containing((double)(Math.round(entity.getX()) + 1L), (double)(Math.round(entity.getY()) - 1L), (double)((double)Math.round(entity.getZ()) - (1.0 + Soul_Water))), ((Block)NoMoonModBlocks.WATER_COBBLESTONE.get()).defaultBlockState(), 3);
            }
            Soul_Water += 1.0;
        }
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.0f);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)NoMoonModEntities.LESSER_SOUL_STALK.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return LesserSoulStalkNaturalEntitySpawningConditionProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.225);
        builder = builder.add(Attributes.MAX_HEALTH, 50.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 10.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 200.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 10.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 10.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("Shake"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 20) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience((Entity)this);
        }
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private static /* synthetic */ void lambda$baseTick$6(Entity entity) {
        if (entity.isAlive() && !entity.level().isClientSide()) {
            entity.discard();
        }
    }

    private static /* synthetic */ void lambda$baseTick$5(LevelAccessor world, double x, double y, double z) {
        if (NoMoonModVariables.WorldVariables.get((LevelAccessor)world).FOUND_YOU) {
            NoMoonModVariables.WorldVariables.get((LevelAccessor)world).FOUND_YOU = false;
            NoMoonModVariables.WorldVariables.get(world).syncData(world);
        }
        StopSoundProcedure.execute(world, x, y, z);
    }
}

