/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.nomoon.entity;

import java.util.Comparator;
import javax.annotation.Nullable;
import net.mcreator.nomoon.NoMoonMod;
import net.mcreator.nomoon.init.NoMoonModEntities;
import net.mcreator.nomoon.init.NoMoonModGameRules;
import net.mcreator.nomoon.init.NoMoonModParticleTypes;
import net.mcreator.nomoon.network.NoMoonModVariables;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class Player1Entity
extends Monster {
    public Player1Entity(EntityType<Player1Entity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.getNavigation().getNodeEvaluator().setCanOpenDoors(true);
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 0.75, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new OpenDoorGoal((Mob)this, true));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return super.getPassengerRidingPosition(entity).add(0.0, (double)-0.35f, 0.0);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public double getMyRidingOffset() {
        return -0.35;
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        return false;
    }

    public boolean ignoreExplosion() {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        Level _level;
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        if (this == null) {
            this.discard();
        }
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Entity NonFinalPlayer = null;
        Player1Entity entity = this;
        if (!world.getEntitiesOfClass(Player.class, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)325.0, (double)325.0, (double)325.0), e -> true).isEmpty()) {
            Entity Player2 = world.getEntitiesOfClass(Player.class, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)325.0, (double)325.0, (double)325.0), e -> true).stream().sorted(new Object(this){

                Comparator<Entity> compareDistOf(double _x, double _y, double _z) {
                    return Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_x, _y, _z));
                }
            }.compareDistOf(x, y, z)).findFirst().orElse(null);
            NoMoonModVariables.PlayerVariables _vars = (NoMoonModVariables.PlayerVariables)entity.getData(NoMoonModVariables.PLAYER_VARIABLES);
            _vars.Big_Event_Has_Played = "";
            _vars.syncPlayerVariables((Entity)entity);
            NonFinalPlayer = Player2;
        } else {
            this.discard();
        }
        this.teleportTo(this.getX(), world.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)x, (int)z), this.getZ());
        if (entity instanceof ServerPlayer) {
            ServerPlayer _serverPlayer = (ServerPlayer)entity;
            _serverPlayer.connection.teleport(x, (double)world.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)x, (int)z), z, this.getYRot(), this.getXRot());
        }
        if (world.getLevelData().getGameRules().getBoolean(NoMoonModGameRules.DEBUG_MODE) && !world.isClientSide() && world.getServer() != null) {
            world.getServer().getPlayerList().broadcastSystemMessage((Component)Component.literal((String)"Player_1 has spawned"), false);
        }
        if (Math.random() < 0.25 && world instanceof Level && !(_level = (Level)world).isClientSide()) {
            _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"ambient.cave")), SoundSource.AMBIENT, 100.0f, 0.1f);
        }
        NoMoonMod.queueServerWork(1500, () -> {
            if (this.isAlive()) {
                if (!this.level().isClientSide()) {
                    this.discard();
                }
                if (world instanceof ServerLevel) {
                    ServerLevel _level = (ServerLevel)world;
                    _level.sendParticles((ParticleOptions)((SimpleParticleType)NoMoonModParticleTypes.BLACK_BOX.get()), x, y, z, 15, 1.5, 1.5, 1.5, 0.0);
                }
            }
        });
        return retval;
    }

    public void baseTick() {
        super.baseTick();
        if (this == null) {
            return;
        }
        Level level = this.level();
        Entity Player2 = null;
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Player1Entity entity = this;
        if (!level.getEntitiesOfClass(Player.class, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)325.0, (double)325.0, (double)325.0), e -> true).isEmpty()) {
            Player2 = level.getEntitiesOfClass(Player.class, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)325.0, (double)325.0, (double)325.0), e -> true).stream().sorted(new Object(this){

                Comparator<Entity> compareDistOf(double _x, double _y, double _z) {
                    return Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_x, _y, _z));
                }
            }.compareDistOf(x, y, z)).findFirst().orElse(null);
        } else if (!this.level().isClientSide()) {
            this.discard();
        }
        if (!level.getEntitiesOfClass(Player.class, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)8.0, (double)8.0, (double)8.0), e -> true).isEmpty() && this.hasLineOfSight(Player2)) {
            if (!this.level().isClientSide()) {
                this.discard();
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                serverlevel.sendParticles((ParticleOptions)((SimpleParticleType)NoMoonModParticleTypes.BLACK_BOX.get()), x, y, z, 15, 1.5, 1.5, 1.5, 0.0);
            }
            return;
        }
        if (Player2 == null) {
            return;
        }
        if (this.isPassenger() && !NoMoonModVariables.WorldVariables.get((LevelAccessor)level).Boating) {
            this.stopRiding();
        }
        if (!this.hasLineOfSight(Player2) || !this.isAggressive()) {
            this.getNavigation().moveTo(Player2.getX(), Player2.getY(), Player2.getZ(), 0.75);
        }
        if (NoMoonModVariables.WorldVariables.get((LevelAccessor)level).Respawn_Loadup) {
            NoMoonMod.queueServerWork(1500, () -> {
                if (this.isAlive()) {
                    if (!this.level().isClientSide()) {
                        this.discard();
                    }
                    if (level instanceof ServerLevel) {
                        ServerLevel serverlevel = (ServerLevel)level;
                        serverlevel.sendParticles((ParticleOptions)((SimpleParticleType)NoMoonModParticleTypes.BLACK_BOX.get()), x, y, z, 15, 1.5, 1.5, 1.5, 0.0);
                    }
                }
            });
        }
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)NoMoonModEntities.PLAYER_1.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            Entity Player2 = null;
            if (world.getEntitiesOfClass(Player.class, AABB.ofSize((Vec3)new Vec3((double)x, (double)y, (double)z), (double)325.0, (double)325.0, (double)325.0), e -> true).isEmpty() || !world.getEntitiesOfClass(Player.class, AABB.ofSize((Vec3)new Vec3((double)x, (double)world.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z), (double)z), (double)64.0, (double)64.0, (double)64.0), e -> true).isEmpty()) {
                return false;
            }
            Player2 = world.getEntitiesOfClass(Player.class, AABB.ofSize((Vec3)new Vec3((double)x, (double)y, (double)z), (double)325.0, (double)325.0, (double)325.0), e -> true).stream().sorted(new Object(){

                Comparator<Entity> compareDistOf(double _x, double _y, double _z) {
                    return Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_x, _y, _z));
                }
            }.compareDistOf(x, y, z)).findFirst().orElse(null);
            return ((NoMoonModVariables.PlayerVariables)Player2.getData(NoMoonModVariables.PLAYER_VARIABLES)).Big_Event_Has_Played.contains("Player1NCEventProcedure") && !NoMoonModVariables.WorldVariables.get((LevelAccessor)world).No_Void_Spawn && !NoMoonModVariables.WorldVariables.get((LevelAccessor)world).Disappear_Hunt;
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 20.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 128.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 10.0);
        return builder;
    }
}

