/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.nomoon.procedures;

import java.util.Comparator;
import java.util.List;
import net.mcreator.nomoon.network.NoMoonModVariables;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FallingWorldOnEntityTickUpdateProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity.isPassenger()) {
            entity.stopRiding();
        }
        if (world.getBlockFloorHeight(BlockPos.containing((double)x, (double)(y - 1.0), (double)z)) > 0.0) {
            Level _level;
            if (!entity.level().isClientSide()) {
                entity.discard();
            }
            if (world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.explode")), SoundSource.NEUTRAL, 4.0f, 0.75f);
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.explode")), SoundSource.NEUTRAL, 4.0f, 0.75f, false);
                }
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, x, y, z, 14, 1.5, 1.5, 1.5, 1.0);
            }
            Vec3 _center = new Vec3(x, y, z);
            List<Entity> _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(3.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
            for (Entity entityiterator : _entfound) {
                if (!BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityiterator.getType()).toString().contains("player")) continue;
                entityiterator.hurt(new DamageSource(world.holderOrThrow(DamageTypes.OUTSIDE_BORDER)), 6.0f);
            }
        }
        if (NoMoonModVariables.WorldVariables.get((LevelAccessor)world).FINALE_Intro && !entity.level().isClientSide()) {
            entity.discard();
        }
    }
}

