/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.block.cropper;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class HighCropBlock
extends CropBlock {
    public static final int FIRST_STAGE_MAX_AGE = 6;
    public static final int SECOND_STAGE_MAX_AGE = 1;
    public static final IntegerProperty AGE = BlockStateProperties.f_61409_;

    public HighCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        int currentAge = this.m_52305_(pState);
        float growthSpeed = HighCropBlock.m_52272_((Block)this, (BlockGetter)pLevel, (BlockPos)pPos);
        if (pLevel.m_45524_(pPos, 0) >= 8 && currentAge < this.m_7419_() && ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.m_188503_((int)(25.0f / growthSpeed) + 1) == 0 ? 1 : 0) != 0)) {
            if (currentAge == 6) {
                if (pLevel.m_8055_(pPos.m_6630_(1)).m_60713_(Blocks.f_50016_)) {
                    pLevel.m_7731_(pPos.m_6630_(1), this.m_52289_(currentAge + 1), 2);
                }
            } else {
                pLevel.m_7731_(pPos, this.m_52289_(currentAge + 1), 2);
            }
            ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockPos below = pos.m_7495_();
        BlockState blockState = world.m_8055_(below);
        if (blockState.m_60713_((Block)this)) {
            world.m_46961_(below, true);
        }
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        return super.m_6266_(state, world, pos);
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = reader.m_8055_(belowPos);
        if (this.m_52305_(state) <= 6) {
            return super.m_7898_(state, reader, pos);
        }
        return belowState.m_60713_((Block)this) && (Integer)belowState.m_61143_((Property)AGE) == 6;
    }

    public void m_52263_(Level level, BlockPos blockPos, BlockState blockState) {
        if (level.m_8055_(blockPos.m_6630_(1)).m_60713_(Blocks.f_50016_) && !level.m_8055_(blockPos.m_6630_(1)).m_60713_((Block)this)) {
            int maxAge;
            int nextAge = this.m_52305_(blockState) + this.m_7125_(level);
            if (nextAge > (maxAge = this.m_7419_())) {
                nextAge = maxAge;
            }
            if (this.m_52305_(blockState) == 6) {
                level.m_7731_(blockPos.m_6630_(1), this.m_52289_(nextAge), 2);
            } else if (this.m_52305_(blockState) < 6) {
                level.m_7731_(blockPos, this.m_52289_(nextAge - 1), 2);
            }
        }
    }

    protected boolean m_6266_(BlockState state, BlockGetter world, BlockPos pos) {
        return state.m_60713_(Blocks.f_50093_);
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        if (this.m_52305_(pState) >= this.m_7419_()) {
            return false;
        }
        if (this.m_52305_(pState) >= 6) {
            return pLevel.m_8055_(pPos.m_7494_()).m_60795_();
        }
        return true;
    }

    public int m_7419_() {
        return 7;
    }

    public IntegerProperty m_7959_() {
        return AGE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }
}

