/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.block.custom;

import com.shengchanshe.chang_sheng_jue.util.ChangShengJueVoxelShape;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PigTrough
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)8);
    private VoxelShape AABB = Shapes.m_83040_();

    public PigTrough(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public Direction rightOf(Direction facing) {
        switch (facing) {
            case NORTH: {
                return Direction.WEST;
            }
            case EAST: {
                return Direction.NORTH;
            }
            case SOUTH: {
                return Direction.EAST;
            }
            case WEST: {
                return Direction.SOUTH;
            }
        }
        return facing;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        Direction rightDirection = this.rightOf(facing);
        BlockPos pos2 = pPos.m_121945_(rightDirection);
        return pLevel.m_8055_(pos2).m_247087_();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        Set<Item> ADD_SET = Set.of(Items.f_42405_, Items.f_42129_);
        if (ADD_SET.contains(itemStack.m_41720_())) {
            int level;
            if (!world.f_46443_ && (level = ((Integer)state.m_61143_((Property)LEVEL)).intValue()) < 8) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(level + 1)), 3);
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                this.updateAdjacentTrough(world, pos, state);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void updateAdjacentTrough(Level world, BlockPos pos, BlockState state) {
        int rightLevel;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction rightDirection = this.rightOf(facing);
        BlockPos pos2 = pos.m_121945_(rightDirection);
        BlockState rightState = world.m_8055_(pos2);
        if (rightState.m_60734_() == this && (rightLevel = ((Integer)rightState.m_61143_((Property)LEVEL)).intValue()) < 8) {
            world.m_7731_(pos2, (BlockState)rightState.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(rightLevel + 1)), 3);
        }
    }

    private void updateReduceAdjacentTrough(Level world, BlockPos pos, BlockState state) {
        int rightLevel;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction rightDirection = this.rightOf(facing);
        BlockPos pos2 = pos.m_121945_(rightDirection);
        BlockState rightState = world.m_8055_(pos2);
        if (rightState.m_60734_() == this && (rightLevel = ((Integer)rightState.m_61143_((Property)LEVEL)).intValue()) >= (Integer)state.m_61143_((Property)LEVEL)) {
            world.m_7731_(pos2, (BlockState)rightState.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(rightLevel - 1)), 3);
        }
    }

    public boolean m_6724_(BlockState state) {
        Integer value = (Integer)state.m_61143_((Property)LEVEL);
        if (value >= 1) {
            return true;
        }
        return super.m_6724_(state);
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        int level = (Integer)pState.m_61143_((Property)LEVEL);
        if (level >= 1) {
            this.accelerateGrowth((Level)pLevel, pPos, level, pState);
        }
        super.m_213898_(pState, pLevel, pPos, pRandom);
    }

    private void accelerateGrowth(Level world, BlockPos pos, int level, BlockState state) {
        int range = 3;
        List list = world.m_45976_(Animal.class, new AABB(pos).m_82400_((double)range));
        for (Animal entity : list) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(level - 1)), 3);
            this.updateReduceAdjacentTrough(world, pos, state);
            if (!entity.m_6162_()) continue;
            entity.m_146740_((int)((double)(-entity.m_146764_() / 20) * 0.1 * (double)level), true);
        }
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        Direction facing;
        Direction rightDirection;
        BlockPos pos2;
        if (!world.f_46443_ && (world.m_46859_(pos2 = pos.m_121945_(rightDirection = this.rightOf(facing = (Direction)state.m_61143_((Property)FACING)))) || world.m_8055_(pos2).m_247087_())) {
            BlockState newState = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing.m_122424_());
            world.m_46597_(pos2, newState);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        Direction facing;
        Direction rightDirection;
        BlockPos pos2;
        BlockState stateAtPos2;
        if (state.m_60734_() != newState.m_60734_() && (stateAtPos2 = world.m_8055_(pos2 = pos.m_121945_(rightDirection = this.rightOf(facing = (Direction)state.m_61143_((Property)FACING))))).m_60734_() == this) {
            world.m_7731_(pos2, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction value = (Direction)pState.m_61143_((Property)FACING);
        return switch (value) {
            case Direction.SOUTH -> this.AABB = ChangShengJueVoxelShape.CHANG_SHENG_JUE_PIG_TROUGH_SOUTH;
            case Direction.WEST -> this.AABB = ChangShengJueVoxelShape.CHANG_SHENG_JUE_PIG_TROUGH_WEST;
            case Direction.EAST -> this.AABB = ChangShengJueVoxelShape.CHANG_SHENG_JUE_PIG_TROUGH_EAST;
            default -> this.AABB = ChangShengJueVoxelShape.CHANG_SHENG_JUE_PIG_TROUGH_NORTH;
        };
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, LEVEL});
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }
}

