/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.block.custom.bracket;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChineseBracketLong
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty MAIN_PART = BooleanProperty.m_61465_((String)"main_part");
    public static final BooleanProperty ATTACHED_TO_SIDE = BooleanProperty.m_61465_((String)"attached_to_side");
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);

    public ChineseBracketLong(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)MAIN_PART, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ATTACHED_TO_SIDE, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        boolean isSide = (Boolean)state.m_61143_((Property)ATTACHED_TO_SIDE);
        if (isSide) {
            return switch (direction) {
                case Direction.NORTH -> NORTH_AABB;
                case Direction.SOUTH -> SOUTH_AABB;
                case Direction.WEST -> WEST_AABB;
                case Direction.EAST -> EAST_AABB;
                default -> NORTH_AABB;
            };
        }
        return switch (direction) {
            case Direction.NORTH -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.EAST -> EAST_AABB;
            default -> NORTH_AABB;
        };
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean isBottomPlacement;
        BlockPos pos = context.m_8083_();
        Direction clickedFace = context.m_43719_();
        FluidState fluidState = context.m_43725_().m_6425_(pos);
        boolean isSidePlacement = clickedFace.m_122434_().m_122479_();
        boolean bl = isBottomPlacement = clickedFace == Direction.DOWN;
        Direction facing = isSidePlacement ? clickedFace : (isBottomPlacement ? context.m_8125_().m_122424_() : context.m_8125_());
        if (!this.canMainSurvive((LevelReader)context.m_43725_(), pos, facing, isSidePlacement || isBottomPlacement, clickedFace)) {
            return null;
        }
        BlockPos secondPos = this.getSecondPosition(pos, facing);
        if (!context.m_43725_().m_8055_(secondPos).m_60629_(context)) {
            return null;
        }
        BlockState mainState = (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_))).m_61124_((Property)MAIN_PART, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ATTACHED_TO_SIDE, (Comparable)Boolean.valueOf(isSidePlacement || isBottomPlacement));
        return mainState;
    }

    private boolean canMainSurvive(LevelReader level, BlockPos pos, Direction facing, boolean isSide, Direction clickedFace) {
        if (isSide) {
            BlockPos attachPos = pos.m_121945_(clickedFace.m_122424_());
            return level.m_8055_(attachPos).m_60783_((BlockGetter)level, attachPos, clickedFace);
        }
        return level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP);
    }

    private BlockPos getSecondPosition(BlockPos pos, Direction facing) {
        return pos.m_121945_(facing);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (((Boolean)state.m_61143_((Property)MAIN_PART)).booleanValue()) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            boolean isSide = (Boolean)state.m_61143_((Property)ATTACHED_TO_SIDE);
            BlockPos secondPos = this.getSecondPosition(pos, facing);
            if (level.m_8055_(pos).m_60734_() == this && ((Boolean)level.m_8055_(pos).m_61143_((Property)MAIN_PART)).booleanValue()) {
                BlockState secondState = (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(secondPos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)MAIN_PART, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ATTACHED_TO_SIDE, (Comparable)Boolean.valueOf(isSide));
                level.m_7731_(secondPos, secondState, 3);
            }
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos mainPos;
        BlockState mainState;
        if (!level.f_46443_ && !((Boolean)state.m_61143_((Property)MAIN_PART)).booleanValue() && (mainState = level.m_8055_(mainPos = this.getMainPosition(pos, (Direction)state.m_61143_((Property)FACING)))).m_60734_() == this && ((Boolean)mainState.m_61143_((Property)MAIN_PART)).booleanValue()) {
            level.m_7731_(mainPos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, mainPos, Block.m_49956_((BlockState)mainState));
        }
        super.m_5707_(level, pos, state, player);
    }

    private BlockPos getMainPosition(BlockPos pos, Direction facing) {
        return pos.m_121945_(facing.m_122424_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        BlockPos mainPos;
        BlockState mainState;
        BlockPos secondPos;
        BlockState secondState;
        BlockPos belowPos;
        Direction facing;
        Direction attachDirection;
        BlockPos attachPos;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (((Boolean)state.m_61143_((Property)MAIN_PART)).booleanValue() && ((Boolean)state.m_61143_((Property)ATTACHED_TO_SIDE) != false ? !level.m_8055_(attachPos = currentPos.m_121945_(attachDirection = (facing = (Direction)state.m_61143_((Property)FACING)).m_122424_())).m_60783_((BlockGetter)level, attachPos, facing) : !level.m_8055_(belowPos = currentPos.m_7495_()).m_60783_((BlockGetter)level, belowPos, Direction.UP))) {
            return Blocks.f_50016_.m_49966_();
        }
        if ((Boolean)state.m_61143_((Property)MAIN_PART) != false ? (secondState = level.m_8055_(secondPos = this.getSecondPosition(currentPos, facing = (Direction)state.m_61143_((Property)FACING)))).m_60734_() != this || !((Direction)secondState.m_61143_((Property)FACING)).equals((Object)facing) || (Boolean)secondState.m_61143_((Property)MAIN_PART) != false || secondState.m_61143_((Property)ATTACHED_TO_SIDE) != state.m_61143_((Property)ATTACHED_TO_SIDE) : (mainState = level.m_8055_(mainPos = this.getMainPosition(currentPos, facing = (Direction)state.m_61143_((Property)FACING)))).m_60734_() != this || !((Direction)mainState.m_61143_((Property)FACING)).equals((Object)facing) || (Boolean)mainState.m_61143_((Property)MAIN_PART) == false || mainState.m_61143_((Property)ATTACHED_TO_SIDE) != state.m_61143_((Property)ATTACHED_TO_SIDE)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)MAIN_PART)).booleanValue()) {
            if (((Boolean)state.m_61143_((Property)ATTACHED_TO_SIDE)).booleanValue()) {
                Direction facing = (Direction)state.m_61143_((Property)FACING);
                Direction attachDirection = facing.m_122424_();
                BlockPos attachPos = pos.m_121945_(attachDirection);
                return level.m_8055_(attachPos).m_60783_((BlockGetter)level, attachPos, facing);
            }
            return level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP);
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos mainPos = this.getMainPosition(pos, facing);
        BlockState mainState = level.m_8055_(mainPos);
        return mainState.m_60734_() == this && (Boolean)mainState.m_61143_((Property)MAIN_PART) != false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, MAIN_PART, ATTACHED_TO_SIDE});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

