/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.block.custom.castingmolds;

import com.shengchanshe.chang_sheng_jue.block.ChangShengJueBlocksEntities;
import com.shengchanshe.chang_sheng_jue.item.ChangShengJueItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CastingMoldsBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private ItemStackHandler inventory = new ItemStackHandler(2){

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            CastingMoldsBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyOptional = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> CastingMoldsBlockEntity.this.progress;
                case 1 -> CastingMoldsBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    CastingMoldsBlockEntity.this.progress = pValue;
                    break;
                }
                case 1: {
                    CastingMoldsBlockEntity.this.maxProgress = pValue;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 300;
    private boolean open = false;
    private boolean isEmpty = false;
    private final int INPUT_SLOT = 0;
    private final int OUTPUT_SLOT = 1;

    public CastingMoldsBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ChangShengJueBlocksEntities.CASTING_MOLDS_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyOptional = LazyOptional.of(() -> this.inventory);
    }

    public boolean addItem(ItemStack itemStack) {
        ItemStack stackInSlot = this.inventory.getStackInSlot(0);
        if (stackInSlot.m_41619_()) {
            this.inventory.setStackInSlot(0, itemStack.m_41620_(1));
            this.m_6596_();
            return true;
        }
        return false;
    }

    public void drops() {
        if (!this.inventory.getStackInSlot(1).m_41619_()) {
            SimpleContainer simpleContainer = new SimpleContainer(this.inventory.getSlots());
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                simpleContainer.m_6836_(i, this.inventory.getStackInSlot(i));
            }
            this.open = false;
            this.isEmpty = true;
            this.m_6596_();
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)simpleContainer);
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.inventory.deserializeNBT(pTag.m_128469_("CastingMoldsInventory"));
        this.progress = pTag.m_128451_("CastingMoldsProgress");
        this.open = pTag.m_128471_("CastingMoldsOpen");
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyOptional.invalidate();
    }

    private CompoundTag writeItems(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128365_("CastingMoldsInventory", (Tag)this.inventory.serializeNBT());
        compoundTag.m_128405_("CastingMoldsProgress", this.progress);
        compoundTag.m_128379_("CastingMoldsOpen", this.open);
        return compoundTag;
    }

    protected void m_183515_(CompoundTag pTag) {
        this.writeItems(pTag);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public void tick() {
        if (this.hasRecipe()) {
            this.increaseCraftingProgress();
            this.m_6596_();
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resrtProgress();
            }
        } else {
            this.resrtProgress();
        }
    }

    private void resrtProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        if (!this.inventory.getStackInSlot(0).m_41619_()) {
            ItemStack stack = new ItemStack((ItemLike)ChangShengJueItems.TONG_QIAN.get(), 24);
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                this.inventory.extractItem(i, 1, false);
            }
            this.open = true;
            this.inventory.setStackInSlot(1, new ItemStack((ItemLike)stack.m_41720_(), this.inventory.getStackInSlot(1).m_41613_() + stack.m_41613_()));
        }
    }

    private boolean hasRecipe() {
        boolean hasCraftingItem = this.inventory.getStackInSlot(0).m_41720_() == ChangShengJueItems.CRUCIBLE_LIQUID_COPPER.get();
        ItemStack itemStack = new ItemStack((ItemLike)ChangShengJueItems.TONG_QIAN.get());
        return hasCraftingItem && this.canInsertItemIntoOutputSlot(itemStack.m_41720_()) && this.canInsertAmountIntoOutputSlot(itemStack.m_41613_());
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.inventory.getStackInSlot(1).m_41619_() || this.inventory.getStackInSlot(1).m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.inventory.getStackInSlot(1).m_41613_() + count <= this.inventory.getStackInSlot(1).m_41741_();
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    protected <E extends CastingMoldsBlockEntity> PlayState deployAnimController(AnimationState<E> state) {
        if (!this.open && !this.isEmpty) {
            return PlayState.STOP;
        }
        if (this.inventory.getStackInSlot(0).m_41619_() && this.inventory.getStackInSlot(1).m_41619_()) {
            state.setAndContinue(RawAnimation.begin().thenPlay("idle2"));
        } else if (this.inventory.getStackInSlot(0).m_41619_() && !this.inventory.getStackInSlot(1).m_41619_()) {
            state.setAndContinue(RawAnimation.begin().thenPlay("idle1"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, this::deployAnimController)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

