/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.block.custom.gong;

import com.shengchanshe.chang_sheng_jue.block.ChangShengJueBlocksEntities;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.mutable.MutableInt;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GongEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private long lastRingTimestamp;
    public int ticks;
    public boolean shaking;
    public Direction clickDirection;
    private List<LivingEntity> nearbyEntities;
    private boolean resonating;
    private int resonationTicks;

    public GongEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ChangShengJueBlocksEntities.GONG_ENTITY.get(), pPos, pBlockState);
    }

    public boolean m_7531_(int pId, int pType) {
        if (pId == 1) {
            this.updateEntities();
            this.resonationTicks = 0;
            this.clickDirection = Direction.m_122376_((int)pType);
            this.ticks = 0;
            this.shaking = true;
            return true;
        }
        return super.m_7531_(pId, pType);
    }

    private static void tick(Level pLevel, BlockPos pPos, BlockState pState, GongEntity pBlockEntity, ResonationEndAction pResonationEndAction) {
        if (pBlockEntity.shaking) {
            ++pBlockEntity.ticks;
        }
        if (pBlockEntity.ticks >= 40) {
            pBlockEntity.shaking = false;
            pBlockEntity.ticks = 0;
        }
        if (pBlockEntity.ticks >= 5 && pBlockEntity.resonationTicks == 0 && GongEntity.areRaidersNearby(pPos, pBlockEntity.nearbyEntities)) {
            pBlockEntity.resonating = true;
            pLevel.m_5594_(null, pPos, SoundEvents.f_11700_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (pBlockEntity.resonating) {
            if (pBlockEntity.resonationTicks < 40) {
                ++pBlockEntity.resonationTicks;
            } else {
                pResonationEndAction.run(pLevel, pPos, pBlockEntity.nearbyEntities);
                pBlockEntity.resonating = false;
            }
        }
    }

    public static void clientTick(Level pLevel, BlockPos pPos, BlockState pState, GongEntity pBlockEntity) {
        GongEntity.tick(pLevel, pPos, pState, pBlockEntity, GongEntity::showBellParticles);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, GongEntity pBlockEntity) {
        GongEntity.tick(pLevel, pPos, pState, pBlockEntity, GongEntity::makeRaidersGlow);
    }

    public void onHit(Direction pDirection) {
        BlockPos blockPos = this.m_58899_();
        this.clickDirection = pDirection;
        if (this.shaking) {
            this.ticks = 0;
        } else {
            this.shaking = true;
        }
        this.f_58857_.m_7696_(blockPos, this.m_58900_().m_60734_(), 1, pDirection.m_122411_());
    }

    private void updateEntities() {
        BlockPos blockPos = this.m_58899_();
        if (this.f_58857_.m_46467_() > this.lastRingTimestamp + 60L || this.nearbyEntities == null) {
            this.lastRingTimestamp = this.f_58857_.m_46467_();
            AABB $$1 = new AABB(blockPos).m_82400_(48.0);
            this.nearbyEntities = this.f_58857_.m_45976_(LivingEntity.class, $$1);
        }
        if (!this.f_58857_.f_46443_) {
            for (LivingEntity $$2 : this.nearbyEntities) {
                if (!$$2.m_6084_() || $$2.m_213877_() || !blockPos.m_203195_((Position)$$2.m_20182_(), 32.0)) continue;
                $$2.m_6274_().m_21879_(MemoryModuleType.f_26325_, (Object)this.f_58857_.m_46467_());
            }
        }
    }

    private static boolean areRaidersNearby(BlockPos pPos, List<LivingEntity> pRaiders) {
        LivingEntity livingEntity;
        Iterator<LivingEntity> var2 = pRaiders.iterator();
        do {
            if (var2.hasNext()) continue;
            return false;
        } while (!(livingEntity = var2.next()).m_6084_() || livingEntity.m_213877_() || !pPos.m_203195_((Position)livingEntity.m_20182_(), 32.0) || !livingEntity.m_6095_().m_204039_(EntityTypeTags.f_13121_));
        return true;
    }

    private static void makeRaidersGlow(Level level, BlockPos pos, List<LivingEntity> livingEntities) {
        livingEntities.stream().filter(p_155219_ -> GongEntity.isRaiderWithinRange(pos, p_155219_)).forEach(GongEntity::glow);
    }

    private static void showBellParticles(Level level, BlockPos pos, List<LivingEntity> livingEntities) {
        MutableInt $$3 = new MutableInt(16700985);
        int $$4 = (int)livingEntities.stream().filter(p_289508_ -> pos.m_203195_((Position)p_289508_.m_20182_(), 48.0)).count();
        livingEntities.stream().filter(p_155213_ -> GongEntity.isRaiderWithinRange(pos, p_155213_)).forEach(p_155195_ -> {
            float $$5 = 1.0f;
            double $$6 = Math.sqrt((p_155195_.m_20185_() - (double)pos.m_123341_()) * (p_155195_.m_20185_() - (double)pos.m_123341_()) + (p_155195_.m_20189_() - (double)pos.m_123343_()) * (p_155195_.m_20189_() - (double)pos.m_123343_()));
            double $$7 = (double)((float)pos.m_123341_() + 0.5f) + 1.0 / $$6 * (p_155195_.m_20185_() - (double)pos.m_123341_());
            double $$8 = (double)((float)pos.m_123343_() + 0.5f) + 1.0 / $$6 * (p_155195_.m_20189_() - (double)pos.m_123343_());
            int $$9 = Mth.m_14045_((int)(($$4 - 21) / -2), (int)3, (int)15);
            for (int $$10 = 0; $$10 < $$9; ++$$10) {
                int $$11 = $$3.addAndGet(5);
                double $$12 = (double)FastColor.ARGB32.m_13665_((int)$$11) / 255.0;
                double $$13 = (double)FastColor.ARGB32.m_13667_((int)$$11) / 255.0;
                double $$14 = (double)FastColor.ARGB32.m_13669_((int)$$11) / 255.0;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, $$7, (double)((float)pos.m_123342_() + 0.5f), $$8, $$12, $$13, $$14);
            }
        });
    }

    private static boolean isRaiderWithinRange(BlockPos pPos, LivingEntity pRaider) {
        return pRaider.m_6084_() && !pRaider.m_213877_() && pPos.m_203195_((Position)pRaider.m_20182_(), 48.0) && pRaider.m_6095_().m_204039_(EntityTypeTags.f_13121_);
    }

    private static void glow(LivingEntity p_58841_) {
        p_58841_.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 60));
    }

    protected <E extends GongEntity> PlayState deployAnimController(AnimationState<E> state) {
        if (this.shaking) {
            state.setAndContinue(RawAnimation.begin().thenPlay("qiaoluo"));
        } else {
            state.setAndContinue(RawAnimation.begin().thenPlay("idle"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, this::deployAnimController)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @FunctionalInterface
    static interface ResonationEndAction {
        public void run(Level var1, BlockPos var2, List<LivingEntity> var3);
    }
}

