/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.block.custom.pottery;

import com.shengchanshe.chang_sheng_jue.block.ChangShengJueBlocksEntities;
import com.shengchanshe.chang_sheng_jue.item.ChangShengJueItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotteryWheelEntity
extends BlockEntity {
    private ItemStackHandler inventory = new ItemStackHandler(3){

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            PotteryWheelEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyOptional = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> PotteryWheelEntity.this.progress;
                case 1 -> PotteryWheelEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    PotteryWheelEntity.this.progress = pValue;
                    break;
                }
                case 1: {
                    PotteryWheelEntity.this.maxProgress = pValue;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 200;
    private final int INPUT_SLOT = 0;
    private final int OUTPUT_SLOT = 1;

    public PotteryWheelEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ChangShengJueBlocksEntities.POTTERY_WHEEL_ENTITY.get(), pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyOptional = LazyOptional.of(() -> this.inventory);
    }

    public boolean addItem(ItemStack itemStack) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(i);
            if (!stackInSlot.m_41619_()) continue;
            this.inventory.setStackInSlot(i, itemStack.m_41620_(1));
            this.m_6596_();
            return true;
        }
        return false;
    }

    public void drops() {
        SimpleContainer simpleContainer = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            simpleContainer.m_6836_(i, this.inventory.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)simpleContainer);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.inventory.deserializeNBT(pTag.m_128469_("PotteryWheelInventory"));
        this.progress = pTag.m_128451_("PotteryProgress");
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyOptional.invalidate();
    }

    private CompoundTag writeItems(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128365_("PotteryWheelInventory", (Tag)this.inventory.serializeNBT());
        compoundTag.m_128405_("PotteryProgress", this.progress);
        return compoundTag;
    }

    protected void m_183515_(CompoundTag pTag) {
        this.writeItems(pTag);
    }

    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public Vec3 getItemOffset(int i) {
        float x = 0.0f;
        float y = 0.2f;
        float z = 0.02f;
        Vec3[] offset = new Vec3[]{new Vec3((double)x, (double)y, (double)z), new Vec3((double)(-x), (double)y, (double)(-z)), new Vec3((double)x, (double)y, (double)z + 0.02)};
        return offset[i];
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public void tick() {
        if (this.hasRecipe()) {
            this.increaseCraftingProgress();
            this.m_6596_();
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resrtProgress();
            }
        } else {
            this.resrtProgress();
        }
    }

    private void resrtProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        ItemStack stack;
        if (!(this.inventory.getStackInSlot(0).m_41619_() || this.inventory.getStackInSlot(1).m_41619_() || this.inventory.getStackInSlot(2).m_41619_())) {
            stack = new ItemStack((ItemLike)ChangShengJueItems.CI_WAN.get(), 1);
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                this.inventory.extractItem(i, 1, false);
            }
        } else if (!this.inventory.getStackInSlot(0).m_41619_() && !this.inventory.getStackInSlot(1).m_41619_()) {
            stack = new ItemStack((ItemLike)ChangShengJueItems.CI_PAN.get(), 1);
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                this.inventory.extractItem(i, 1, false);
            }
        } else {
            stack = new ItemStack((ItemLike)ChangShengJueItems.CI_BEI.get(), 1);
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                this.inventory.extractItem(i, 1, false);
            }
        }
        Containers.m_18992_((Level)this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)stack);
        this.inventory.setStackInSlot(1, new ItemStack((ItemLike)stack.m_41720_(), this.inventory.getStackInSlot(1).m_41613_() + stack.m_41613_()));
    }

    private boolean hasRecipe() {
        boolean hasCraftingItem = this.inventory.getStackInSlot(0).m_41720_() == Items.f_42461_;
        return hasCraftingItem;
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }
}

