/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.block.custom.tailoringcase;

import com.shengchanshe.chang_sheng_jue.block.ChangShengJueBlocksEntities;
import com.shengchanshe.chang_sheng_jue.block.custom.tailoringcase.TailoringCase;
import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.tailoringcase.TailoringCaseMenu;
import com.shengchanshe.chang_sheng_jue.recipe.TailoringCaseRecipe;
import com.shengchanshe.chang_sheng_jue.sound.ChangShengJueSound;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TailoringCaseEntity
extends BlockEntity
implements MenuProvider,
GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final DirectionProperty FACING = TailoringCase.FACING;
    private final ItemStackHandler itemHandler = new ItemStackHandler(10);
    public static final int SLOT_OUTPUT = 9;
    private LazyOptional<ItemStackHandler> itemHandlerLazy = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6499_() {
            return 2;
        }

        public int m_6413_(int i) {
            return switch (i) {
                case 0 -> TailoringCaseEntity.this.progress;
                case 1 -> TailoringCaseEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int i, int i1) {
            switch (i) {
                case 0: {
                    TailoringCaseEntity.this.progress = i1;
                    break;
                }
                case 1: {
                    TailoringCaseEntity.this.maxProgress = i1;
                }
            }
        }
    };
    public int progress = 0;
    public int maxProgress = 100;
    private Player currentUser;
    private TailoringCaseRecipe currentRecipe;
    private String currentRecipeGroup = "";

    @Nullable
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazy.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.itemHandlerLazy = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazy.invalidate();
    }

    public TailoringCaseEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ChangShengJueBlocksEntities.TAILORING_CASE_ENTITY.get(), pPos, pBlockState);
    }

    public void drop() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.chang_sheng_jue.tailoring_case");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        if (this.currentUser != null && this.currentUser != player) {
            return null;
        }
        if (this.currentUser == null) {
            this.currentUser = player;
        }
        return new TailoringCaseMenu(containerId, inventory, this, this.data);
    }

    public void onClose(Player player) {
        if (player == this.currentUser) {
            this.currentUser = null;
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("progress", this.progress);
        if (this.currentRecipe != null) {
            tag.m_128359_("current_recipe", this.currentRecipe.m_6423_().toString());
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.progress = tag.m_128451_("progress");
        if (tag.m_128441_("current_recipe")) {
            Optional recipe;
            ResourceLocation recipeId = new ResourceLocation(tag.m_128461_("current_recipe"));
            this.currentRecipe = this.f_58857_ != null ? ((recipe = this.f_58857_.m_7465_().m_44043_(recipeId)).isPresent() && recipe.get() instanceof TailoringCaseRecipe ? (TailoringCaseRecipe)recipe.get() : null) : null;
        } else {
            this.currentRecipe = null;
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.m_5776_()) {
            return;
        }
        if (this.progress > 0 && this.progress < this.maxProgress) {
            ++this.progress;
            this.m_6596_();
        } else if (this.progress >= this.maxProgress) {
            if (this.currentRecipe != null) {
                this.craftItem(this.currentRecipe.m_8043_(pLevel.m_9598_()));
            }
            this.progress = 0;
            this.m_6596_();
        }
    }

    public void craftItem(ItemStack result) {
        ItemStack output = this.itemHandler.getStackInSlot(9);
        ItemStack stack = new ItemStack((ItemLike)result.m_41720_());
        if (output.m_41619_()) {
            this.itemHandler.setStackInSlot(9, stack);
        } else {
            output.m_41769_(result.m_41613_());
        }
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void craftCurrentRecipe(Player player) {
        TailoringCaseRecipe recipeToUse = null;
        if (this.currentRecipe != null && this.hasEnoughMaterials(player.m_150109_(), this.currentRecipe)) {
            recipeToUse = this.currentRecipe;
        } else if (this.currentRecipe != null) {
            ItemStack resultItem = this.currentRecipe.m_8043_(this.f_58857_.m_9598_());
            RecipeManager recipeManager = this.f_58857_.m_7465_();
            TailoringCaseRecipe.Type recipeType = TailoringCaseRecipe.Type.INSTANCE;
            List allRecipes = recipeManager.m_44013_((RecipeType)recipeType);
            for (TailoringCaseRecipe recipe : allRecipes) {
                if (!ItemStack.m_150942_((ItemStack)recipe.m_8043_(this.f_58857_.m_9598_()), (ItemStack)resultItem) || !this.hasEnoughMaterials(player.m_150109_(), recipe)) continue;
                recipeToUse = recipe;
                break;
            }
        }
        if (recipeToUse == null) {
            return;
        }
        if (!this.itemHandler.getStackInSlot(9).m_41619_()) {
            return;
        }
        if (recipeToUse != this.currentRecipe) {
            this.setCurrentRecipe(recipeToUse);
        }
        if (this.hasEnoughMaterials(player.m_150109_(), recipeToUse)) {
            this.consumeMaterials(player.m_150109_(), recipeToUse);
            this.progress = 1;
            this.m_6596_();
        }
    }

    private boolean hasEnoughMaterials(Inventory playerInventory, TailoringCaseRecipe recipe) {
        ItemStack[] requiredMaterials;
        for (ItemStack required : requiredMaterials = this.getMaterialsFromRecipe(recipe)) {
            ItemStack stack;
            if (required.m_41619_()) continue;
            int needed = required.m_41613_();
            int found = 0;
            for (int i = 0; !(i >= playerInventory.m_6643_() || ItemStack.m_150942_((ItemStack)(stack = playerInventory.m_8020_(i)), (ItemStack)required) && (found += stack.m_41613_()) >= needed); ++i) {
            }
            if (found >= needed) continue;
            return false;
        }
        return true;
    }

    private void consumeMaterials(Inventory playerInventory, TailoringCaseRecipe recipe) {
        ItemStack[] requiredMaterials;
        block0: for (ItemStack required : requiredMaterials = this.getMaterialsFromRecipe(recipe)) {
            if (required.m_41619_()) continue;
            int needed = required.m_41613_();
            for (int i = 0; i < playerInventory.m_6643_(); ++i) {
                ItemStack stack = playerInventory.m_8020_(i);
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)required)) continue;
                int take = Math.min(needed, stack.m_41613_());
                stack.m_41774_(take);
                if ((needed -= take) <= 0) continue block0;
            }
        }
    }

    public ItemStack[] getMaterialsFromRecipe(TailoringCaseRecipe recipe) {
        return (ItemStack[])recipe.m_7527_().stream().map(ingredient -> ingredient.m_43908_().length > 0 ? ingredient.m_43908_()[0] : ItemStack.f_41583_).toArray(ItemStack[]::new);
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
    }

    public void setCurrentRecipe(TailoringCaseRecipe recipe) {
        this.setCurrentRecipe(recipe, recipe != null ? recipe.m_6076_() : null);
    }

    public void setCurrentRecipe(TailoringCaseRecipe recipe, String group) {
        this.currentRecipe = recipe;
        this.currentRecipeGroup = group != null ? group : "";
        for (int i = 0; i < 9; ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
        if (recipe != null) {
            NonNullList<Ingredient> ingredients = recipe.m_7527_();
            for (int i = 0; i < ingredients.size() && i < 9; ++i) {
                ItemStack[] matchingStacks = ((Ingredient)ingredients.get(i)).m_43908_();
                if (matchingStacks.length <= 0) continue;
                this.itemHandler.setStackInSlot(i, matchingStacks[0].m_41777_());
            }
        }
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public TailoringCaseRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public ItemStack getRecipeResultItem() {
        if (this.currentRecipe != null) {
            return this.currentRecipe.m_8043_(this.f_58857_.m_9598_());
        }
        return ItemStack.f_41583_;
    }

    public void setRecipeGroup(String group) {
        this.currentRecipeGroup = group != null ? group : "";
        this.m_6596_();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "work", 0, state -> {
            if (this.progress != 0) {
                state.setAndContinue(RawAnimation.begin().thenPlay("work"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }).setSoundKeyframeHandler(state -> {
            Player player = ClientUtils.getClientPlayer();
            Level level1 = ClientUtils.getLevel();
            level1.m_5594_(player, this.m_58899_(), (SoundEvent)ChangShengJueSound.TAILORING_CASE_SOUND.get(), SoundSource.BLOCKS, 0.1f, 1.0f);
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

