/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.block.custom.tool_table;

import com.shengchanshe.chang_sheng_jue.block.ChangShengJueBlocksEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolTableEntity
extends BlockEntity {
    private ItemStackHandler inventory = new ItemStackHandler(1){

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            ToolTableEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyOptional = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> ToolTableEntity.this.progress;
                case 1 -> ToolTableEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    ToolTableEntity.this.progress = pValue;
                    break;
                }
                case 1: {
                    ToolTableEntity.this.maxProgress = pValue;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 200;
    private final int INPUT_SLOT = 0;

    public ToolTableEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ChangShengJueBlocksEntities.TOOL_TABLE_ENTITY.get(), pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyOptional = LazyOptional.of(() -> this.inventory);
    }

    public boolean addItem(ItemStack itemStack) {
        ItemStack stackInSlot = this.inventory.getStackInSlot(0);
        if (stackInSlot.m_41619_()) {
            this.inventory.setStackInSlot(0, itemStack.m_41620_(1));
            this.m_6596_();
            return true;
        }
        return false;
    }

    public void drops() {
        SimpleContainer simpleContainer = new SimpleContainer(this.inventory.getSlots());
        simpleContainer.m_6836_(0, this.inventory.getStackInSlot(0));
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)simpleContainer);
    }

    public void drops(Player player) {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (!stack.m_41619_()) {
            boolean added = player.m_150109_().m_36054_(stack);
            if (!added || !stack.m_41619_()) {
                Containers.m_18992_((Level)this.f_58857_, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)stack);
            }
            this.inventory.setStackInSlot(0, ItemStack.f_41583_);
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.inventory.deserializeNBT(pTag.m_128469_("ToolTableInventory"));
        this.progress = pTag.m_128451_("ToolTableProgress");
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyOptional.invalidate();
    }

    private CompoundTag writeItems(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128365_("ToolTableInventory", (Tag)this.inventory.serializeNBT());
        compoundTag.m_128405_("ToolTableProgress", this.progress);
        return compoundTag;
    }

    protected void m_183515_(CompoundTag pTag) {
        this.writeItems(pTag);
    }

    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public Vec2 getItemOffset(int i) {
        float x = 0.0f;
        float y = 0.0f;
        Vec2 offset = new Vec2(x, y);
        return offset;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (this.hasRecipe()) {
            this.increaseCraftingProgress();
            ToolTableEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resrtProgress();
            }
        } else {
            this.resrtProgress();
        }
    }

    private void resrtProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.m_41763_()) {
            int maxDamage = stack.m_41776_();
            int damageValue = stack.m_41773_();
            int i = maxDamage - damageValue;
            stack.m_41721_(Math.max(0, damageValue - i));
            this.inventory.extractItem(0, 1, false);
        }
        BlockPos pos = this.m_58899_();
        Containers.m_18992_((Level)this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)stack);
        this.m_58904_().m_214150_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12574_, SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
    }

    private boolean hasRecipe() {
        boolean hasCraftingItem = this.inventory.getStackInSlot(0).m_41720_() == Items.f_42411_;
        return hasCraftingItem;
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }
}

