/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.block.custom.weaponrack;

import com.shengchanshe.chang_sheng_jue.block.ChangShengJueBlocksEntities;
import com.shengchanshe.chang_sheng_jue.block.custom.weaponrack.WeaponRackEntity;
import com.shengchanshe.chang_sheng_jue.item.ChangShengJueItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WeaponRack
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty LEFT = BooleanProperty.m_61465_((String)"left");
    public static final BooleanProperty RIGHT = BooleanProperty.m_61465_((String)"right");
    private static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)15.0, (double)13.0);
    private static final VoxelShape EAST_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)15.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)13.0);
    private static final VoxelShape WEST_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)15.0, (double)16.0);
    public static final IntegerProperty CONNECTION = IntegerProperty.m_61631_((String)"connection", (int)0, (int)2);
    public static final IntegerProperty MAIN = IntegerProperty.m_61631_((String)"main", (int)0, (int)1);

    public WeaponRack(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (level.m_5776_()) {
            return state;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (!direction.m_122434_().m_122479_()) {
            return state;
        }
        Direction leftDir = facing.m_122428_();
        Direction rightDir = facing.m_122427_();
        boolean leftConnected = false;
        boolean rightConnected = false;
        if (direction == leftDir || direction == rightDir) {
            leftConnected = this.checkConnection((BlockGetter)level, pos, leftDir, facing);
            rightConnected = this.checkConnection((BlockGetter)level, pos, rightDir, facing);
        }
        return (BlockState)((BlockState)state.m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(leftConnected))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(rightConnected));
    }

    private boolean checkConnection(BlockGetter level, BlockPos pos, Direction checkDir, Direction facing) {
        BlockState neighbor = level.m_8055_(pos.m_121945_(checkDir));
        return neighbor.m_60713_((Block)this) && neighbor.m_61143_((Property)FACING) == facing;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        switch (facing) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return NORTH_SHAPE;
    }

    private boolean isMiddleBlock(Direction facing, boolean left, boolean right) {
        return left && right;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, LEFT, RIGHT});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos pos = pContext.m_8083_();
        Direction facing = pContext.m_8125_().m_122424_();
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(this.checkConnection((BlockGetter)level, pos, facing.m_122428_(), facing)))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(this.checkConnection((BlockGetter)level, pos, facing.m_122427_(), facing)));
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new WeaponRackEntity(blockPos, blockState);
    }

    private boolean checkWeapon(ItemStack item) {
        return item.m_41720_().equals(Items.f_42420_) || item.m_41720_().equals(Items.f_42425_) || item.m_41720_().equals(Items.f_42383_) || item.m_41720_().equals(Items.f_42388_) || item.m_41720_().equals(Items.f_42430_) || item.m_41720_().equals(Items.f_42393_) || item.m_41720_().equals(Items.f_42713_);
    }

    private boolean checkModWeapon(ItemStack item) {
        return item.m_41720_().equals(ChangShengJueItems.BEAT_DOG_STICK.get()) || item.m_41720_().equals(ChangShengJueItems.YI_TIAN_JIAN.get()) || item.m_41720_().equals(ChangShengJueItems.TU_LONG_DAO.get()) || item.m_41720_().equals(ChangShengJueItems.BA_WANG_QIANG.get()) || item.m_41720_().equals(ChangShengJueItems.BRONZE_SWORD.get()) || item.m_41720_().equals(ChangShengJueItems.HAN_JIAN.get()) || item.m_41720_().equals(ChangShengJueItems.HENG_DAO.get()) || item.m_41720_().equals(ChangShengJueItems.LARGE_KNIFE.get()) || item.m_41720_().equals(ChangShengJueItems.RED_TASSELLED_SPEAR.get()) || item.m_41720_().equals(ChangShengJueItems.SOFT_SWORD.get()) || item.m_41720_().equals(ChangShengJueItems.PAN_HUA_GUN.get()) || item.m_41720_().equals(ChangShengJueItems.KITCHEN_KNIFE.get());
    }

    private boolean checkfather(ItemStack item) {
        return item.m_41720_() instanceof SwordItem;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof WeaponRackEntity) {
            WeaponRackEntity entity = (WeaponRackEntity)blockEntity;
            ItemStack item = pPlayer.m_21205_();
            if (item.m_41720_() instanceof TieredItem || item.m_41720_() instanceof TridentItem) {
                if (!pLevel.f_46443_) {
                    if (pPlayer.m_150110_().f_35937_) {
                        ItemStack itemcopy = item.m_41777_();
                        entity.addItem(itemcopy);
                        return InteractionResult.SUCCESS;
                    }
                    entity.addItem(item);
                }
            } else {
                entity.drops(pPlayer);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockentity = pLevel.m_7702_(pPos);
            if (blockentity instanceof WeaponRackEntity) {
                ((WeaponRackEntity)blockentity).drops();
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.f_46443_) {
            return null;
        }
        return WeaponRack.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ChangShengJueBlocksEntities.TOOL_TABLE_ENTITY.get()), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick(pLevel1, pPos, pState1));
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    private void updateNeighborState(BlockState state, LevelAccessor level, BlockPos pos, Direction direction) {
        BlockPos neighborPos;
        BlockState neighborState;
        if ((Integer)state.m_61143_((Property)MAIN) == 1 && (neighborState = level.m_8055_(neighborPos = pos.m_121945_(direction))).m_60713_((Block)this) && neighborState.m_61143_((Property)FACING) == state.m_61143_((Property)FACING)) {
            level.m_7731_(neighborPos, (BlockState)((BlockState)neighborState.m_61124_((Property)MAIN, (Comparable)Integer.valueOf(0))).m_61124_((Property)CONNECTION, (Comparable)Integer.valueOf(1)), 3);
        }
    }
}

