/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.block.food.cibei;

import com.shengchanshe.chang_sheng_jue.block.food.cibei.CiBeiTypeBlock;
import com.shengchanshe.chang_sheng_jue.effect.ChangShengJueEffects;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CiBeiTea
extends CiBeiTypeBlock {
    protected static final VoxelShape PLATE_SHAPE = Block.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)5.0, (double)10.5);
    protected static final VoxelShape PIE_SHAPE = Shapes.m_83148_((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.m_49796_((double)6.5, (double)1.0, (double)6.5, (double)9.5, (double)5.0, (double)9.5), (BooleanOp)BooleanOp.f_82695_);
    protected int eff;
    protected int fed;
    protected float fedpro;
    private static final Map<UUID, Boolean> HAS_REDUCED_DRUNKENNESS = new HashMap<UUID, Boolean>();

    public CiBeiTea(BlockBehaviour.Properties properties, boolean hasLeftovers, int fed, float fedpro, int eff) {
        super(properties, hasLeftovers, fed, fedpro);
        this.eff = eff;
        this.fed = fed;
        this.fedpro = fedpro;
    }

    @Override
    protected InteractionResult addFed(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand, int fed, float fedpro) {
        UUID playerUUID;
        boolean reduced;
        super.addFed(level, pos, state, player, hand, this.fed, this.fedpro);
        if (this.eff == 1) {
            player.m_7292_(new MobEffectInstance(ChangShengJueEffects.BILUOCHUN_TEAS.get(), 1200, 0));
        }
        if (this.eff == 2) {
            player.m_7292_(new MobEffectInstance(ChangShengJueEffects.LONG_JING_TEAS.get(), 1200, 0));
        }
        if (!(reduced = HAS_REDUCED_DRUNKENNESS.getOrDefault(playerUUID = player.m_20148_(), false).booleanValue())) {
            MobEffectInstance effect = player.m_21124_(ChangShengJueEffects.DRUNKEN.get());
            MobEffectInstance effect2 = player.m_21124_(MobEffect.m_19453_((int)9));
            if (effect != null) {
                int newDuration = Math.max(0, effect.m_19557_() - 600);
                player.m_21195_(ChangShengJueEffects.DRUNKEN.get());
                if (newDuration > 0) {
                    player.m_7292_(new MobEffectInstance(ChangShengJueEffects.DRUNKEN.get(), newDuration, effect.m_19564_(), effect.m_19571_(), effect.m_19572_()));
                }
                if (effect2 != null) {
                    int newDuration2 = Math.max(0, effect2.m_19557_() - 600);
                    player.m_21195_(MobEffect.m_19453_((int)9));
                    if (newDuration2 > 0) {
                        player.m_7292_(new MobEffectInstance(MobEffect.m_19453_((int)9), newDuration2, effect2.m_19564_(), effect2.m_19571_(), effect2.m_19572_()));
                    }
                }
                HAS_REDUCED_DRUNKENNESS.put(playerUUID, true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Integer)state.m_61143_((Property)TYPES) == 0 ? PLATE_SHAPE : PIE_SHAPE;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TYPES});
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            UUID playerUUID = player.m_20148_();
            boolean hasDrunkenEffect = player.m_21023_(ChangShengJueEffects.DRUNKEN.get());
            if (!hasDrunkenEffect && HAS_REDUCED_DRUNKENNESS.containsKey(playerUUID)) {
                HAS_REDUCED_DRUNKENNESS.remove(playerUUID);
            }
        }
    }
}

