/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.capability.quest;

import com.shengchanshe.chang_sheng_jue.ChangShengJue;
import com.shengchanshe.chang_sheng_jue.entity.custom.wuxia.gangleader.AbstractGangLeader;
import com.shengchanshe.chang_sheng_jue.entity.custom.wuxia.gangleader.GangleaderVariant2;
import com.shengchanshe.chang_sheng_jue.entity.custom.wuxia.gangleader.clubbed.ClubbedGangLeader;
import com.shengchanshe.chang_sheng_jue.entity.custom.wuxia.gangleader.other.GangLeader;
import com.shengchanshe.chang_sheng_jue.event.quest.PlayerQuestEvent;
import com.shengchanshe.chang_sheng_jue.network.ChangShengJueMessages;
import com.shengchanshe.chang_sheng_jue.network.packet.gui.playerquest.SyncQuestDataPacket;
import com.shengchanshe.chang_sheng_jue.quest.Quest;
import com.shengchanshe.chang_sheng_jue.quest.QuestLoader;
import com.shengchanshe.chang_sheng_jue.quest.QuestManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;

public class PlayerQuestCapability {
    private final Map<UUID, List<Quest>> playerQuests = new ConcurrentHashMap<UUID, List<Quest>>();
    private final Map<UUID, Integer> questCompletionCounts = new ConcurrentHashMap<UUID, Integer>();
    private final Set<UUID> completedQuests = ConcurrentHashMap.newKeySet();
    private final Set<UUID> acceptedQuests = ConcurrentHashMap.newKeySet();
    private boolean firstLargeTransactionTrigger = true;

    public void copyFrom(PlayerQuestCapability source) {
        this.playerQuests.clear();
        this.playerQuests.putAll(source.playerQuests);
        this.questCompletionCounts.clear();
        this.questCompletionCounts.putAll(source.questCompletionCounts);
        this.completedQuests.clear();
        this.completedQuests.addAll(source.completedQuests);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag playersTag = new ListTag();
        this.playerQuests.forEach((uuid, quests) -> {
            if (uuid == null || quests == null) {
                return;
            }
            CompoundTag playerTag = new CompoundTag();
            playerTag.m_128362_("PlayerId", uuid);
            ListTag questsTag = new ListTag();
            quests.stream().filter(Objects::nonNull).forEach(quest -> {
                CompoundTag questTag = quest.toNbt();
                if (questTag != null) {
                    questsTag.add((Object)questTag);
                }
            });
            playerTag.m_128365_("Quests", (Tag)questsTag);
            playersTag.add((Object)playerTag);
        });
        tag.m_128365_("PlayerQuests", (Tag)playersTag);
        CompoundTag countsTag = new CompoundTag();
        this.questCompletionCounts.forEach((uuid, count) -> {
            if (uuid != null) {
                countsTag.m_128405_(uuid.toString(), count.intValue());
            }
        });
        tag.m_128365_("QuestCompletionCounts", (Tag)countsTag);
        ListTag completedTag = new ListTag();
        this.completedQuests.stream().filter(Objects::nonNull).forEach(uuid -> completedTag.add((Object)NbtUtils.m_129226_((UUID)uuid)));
        tag.m_128365_("CompletedQuests", (Tag)completedTag);
        ListTag acceptedTag = new ListTag();
        this.acceptedQuests.stream().filter(Objects::nonNull).forEach(uuid -> acceptedTag.add((Object)NbtUtils.m_129226_((UUID)uuid)));
        tag.m_128365_("AcceptedQuests", (Tag)acceptedTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("PlayerQuests", 9)) {
            ListTag playersTag = tag.m_128437_("PlayerQuests", 10);
            for (Tag t : playersTag) {
                UUID playerId;
                if (!(t instanceof CompoundTag)) continue;
                CompoundTag playerTag = (CompoundTag)t;
                UUID uUID = playerId = playerTag.m_128403_("PlayerId") ? playerTag.m_128342_("PlayerId") : null;
                if (playerId == null) continue;
                ArrayList<Quest> quests = new ArrayList<Quest>();
                if (playerTag.m_128425_("Quests", 9)) {
                    ListTag questsTag = playerTag.m_128437_("Quests", 10);
                    for (Tag q : questsTag) {
                        CompoundTag questTag;
                        Quest quest;
                        if (!(q instanceof CompoundTag) || !(quest = new Quest(questTag = (CompoundTag)q)).isValid()) continue;
                        quests.add(quest);
                    }
                }
                if (tag.m_128425_("AcceptedQuests", 9)) {
                    ListTag acceptedTag = tag.m_128437_("AcceptedQuests", 11);
                    acceptedTag.stream().map(NbtUtils::m_129233_).forEach(this.acceptedQuests::add);
                }
                if (quests.isEmpty()) continue;
                this.playerQuests.put(playerId, quests);
            }
        }
        if (tag.m_128425_("QuestCompletionCounts", 10)) {
            CompoundTag countsTag = tag.m_128469_("QuestCompletionCounts");
            for (String key : countsTag.m_128431_()) {
                try {
                    UUID questId = UUID.fromString(key);
                    this.questCompletionCounts.put(questId, countsTag.m_128451_(key));
                }
                catch (IllegalArgumentException e) {
                    ChangShengJue.LOGGER.warn("Invalid quest UUID in saved data: {}", (Object)key);
                }
            }
        }
        if (tag.m_128425_("CompletedQuests", 9)) {
            ListTag completedTag = tag.m_128437_("CompletedQuests", 11);
            completedTag.stream().map(NbtUtils::m_129233_).forEach(this.completedQuests::add);
        }
    }

    public List<Quest> triggerGangQuest(Player player, AbstractGangLeader questNpc, Float triggerChance) {
        if (!this.validateTriggerConditions(player, questNpc.m_20148_(), triggerChance)) {
            return null;
        }
        List quests = this.playerQuests.computeIfAbsent(player.m_20148_(), k -> new CopyOnWriteArrayList());
        Optional<Quest> existingQuest = this.findExistingQuest(quests, questNpc.m_20148_());
        if (existingQuest.isEmpty()) {
            return this.tryCreateNewQuests(player, questNpc, triggerChance.floatValue(), quests);
        }
        return this.handleExistingQuests(player, questNpc, triggerChance.floatValue(), quests);
    }

    private boolean validateTriggerConditions(Player player, UUID questNpcId, Float chance) {
        if (player == null || questNpcId == null) {
            return false;
        }
        return !(player.m_217043_().m_188501_() >= chance.floatValue());
    }

    private Optional<Quest> findExistingQuest(List<Quest> quests, UUID npcId) {
        return quests.stream().filter(Objects::nonNull).filter(q -> npcId.equals(q.getQuestNpcId())).findFirst();
    }

    private List<Quest> tryCreateNewQuests(Player player, AbstractGangLeader questNpc, float chance, List<Quest> existingQuests) {
        ArrayList<Quest> newQuests = new ArrayList<Quest>();
        List<Quest> allAvailableQuests = QuestLoader.loadAllAvailableQuests(questNpc.m_20148_(), this.completedQuests);
        if (allAvailableQuests.isEmpty()) {
            ChangShengJue.LOGGER.error("\u6ca1\u6709\u53ef\u7528\u7684\u4efb\u52a1: {}", (Object)questNpc.m_20148_());
            return newQuests;
        }
        ArrayList<Quest> validQuests = new ArrayList<Quest>();
        for (Quest quest : allAvailableQuests) {
            if (!this.validateNewQuest(player, quest, questNpc)) continue;
            validQuests.add(quest);
        }
        newQuests.addAll(validQuests);
        this.syncToClient((ServerPlayer)player);
        return newQuests;
    }

    private boolean validateNewQuest(Player player, Quest quest, AbstractGangLeader questNpc) {
        GangLeader gangLeader;
        GangleaderVariant2 variant;
        if (quest.isNeedCompletePreQuest() && !quest.checkPrerequisiteQuests(this)) {
            return false;
        }
        if (quest.isConflictQuest() && quest.checkConflictQuests(this)) {
            return false;
        }
        if (quest.getQuestId().equals(PlayerQuestEvent.VEGETARIAN_FOOD_QUEST_ID) && (questNpc instanceof GangLeader ? (variant = (gangLeader = (GangLeader)questNpc).getVariant()) != GangleaderVariant2.TEXTURES_0 : !(questNpc instanceof ClubbedGangLeader))) {
            return false;
        }
        if (player.m_9236_().m_46791_() == Difficulty.PEACEFUL && quest.getQuestType() == Quest.QuestType.KILL) {
            return false;
        }
        if (!quest.isRepeatable() && this.completedQuests.contains(quest.getQuestId())) {
            return false;
        }
        return quest.isValid();
    }

    private List<Quest> handleExistingQuests(Player player, AbstractGangLeader questNpc, float chance, List<Quest> quests) {
        ArrayList<Quest> validQuests = new ArrayList<Quest>();
        for (Quest existingQuest : quests) {
            if (existingQuest == null || !questNpc.m_20148_().equals(existingQuest.getQuestNpcId())) continue;
            validQuests.add(existingQuest);
        }
        if (validQuests.isEmpty()) {
            return this.tryCreateNewQuests(player, questNpc, chance, quests);
        }
        return validQuests;
    }

    public void triggerQuest(Player player, UUID questId, Float f, UUID mobId) {
        if (player == null || questId == null) {
            ChangShengJue.LOGGER.warn("\u89e6\u53d1\u4efb\u52a1\u5931\u8d25\uff1a\u73a9\u5bb6ID\u6216\u4efb\u52a1ID\u4e3anull");
            return;
        }
        List quests = this.playerQuests.computeIfAbsent(player.m_20148_(), k -> new CopyOnWriteArrayList());
        Optional<Quest> existingQuest = quests.stream().filter(Objects::nonNull).filter(q -> questId.equals(q.getQuestId())).findFirst();
        if (existingQuest.isEmpty()) {
            Quest newQuest;
            if (player.m_217043_().m_188501_() < f.floatValue() && (newQuest = QuestLoader.loadSpecificQuest(questId, mobId != null ? mobId : player.m_20148_())) != null) {
                if (player.m_9236_().m_46791_() == Difficulty.PEACEFUL && newQuest.getQuestType() == Quest.QuestType.KILL) {
                    return;
                }
                boolean checkConflictQuests = newQuest.checkConflictQuests(this);
                boolean checkPrerequisiteQuests = newQuest.checkPrerequisiteQuests(this);
                if (checkPrerequisiteQuests && !checkConflictQuests) {
                    if (this.isQuestCompleted(questId) && !newQuest.isRepeatable()) {
                        return;
                    }
                    if (newQuest.isValid()) {
                        if (newQuest.getQuestType() == Quest.QuestType.AUTOMATIC && !newQuest.getQuestId().equals(PlayerQuestEvent.REN_WO_XING_QUEST_ID)) {
                            newQuest.setComplete(true);
                        }
                        if (mobId != null) {
                            newQuest.setQuestNpcId(mobId);
                        }
                        newQuest.setAcceptedBy(player.m_20148_());
                        quests.add(newQuest);
                        this.markQuestAccepted(newQuest.getQuestId());
                        QuestManager.getInstance().spawnTargetForQuest((ServerPlayer)player, newQuest, newQuest.getRequiredKills());
                        player.m_213846_(PlayerQuestEvent.getColoredTranslation("quest.chang_sheng_jue.trigger", PlayerQuestEvent.getColoredTranslation(newQuest.getQuestName(), new Object[0])));
                    }
                }
                this.syncToClient((ServerPlayer)player);
            }
        } else {
            Quest quest = existingQuest.get();
            if (quest.getQuestId().equals(PlayerQuestEvent.REN_WO_XING_QUEST_ID)) {
                if (quest.getQuestCurrentDay() < 7) {
                    quest.setQuestCurrentDay(quest.getQuestCurrentDay() + 1);
                } else if (quest.getQuestCurrentDay() >= 7 && !quest.isComplete()) {
                    quest.setComplete(true);
                    quest.setQuestCurrentDay(0);
                    player.m_213846_(PlayerQuestEvent.getColoredTranslation("quest.chang_sheng_jue.finish", PlayerQuestEvent.getColoredTranslation(quest.getQuestName(), new Object[0])));
                }
            } else if (quest.getQuestId().equals(PlayerQuestEvent.VEGETARIAN_FOOD_QUEST_ID)) {
                if (quest.getQuestCurrentDay() < 2) {
                    quest.setQuestCurrentDay(quest.getQuestCurrentDay() + 1);
                } else if (quest.getQuestCurrentDay() >= 2 && !quest.isComplete()) {
                    quest.setComplete(true);
                    quest.setQuestCurrentDay(0);
                    player.m_213846_(PlayerQuestEvent.getColoredTranslation("quest.chang_sheng_jue.finish", PlayerQuestEvent.getColoredTranslation(quest.getQuestName(), new Object[0])));
                }
            }
        }
    }

    public void syncToClient(ServerPlayer player) {
        CompoundTag data = new CompoundTag();
        ListTag questsTag = new ListTag();
        this.getQuests(player.m_20148_()).forEach(q -> questsTag.add((Object)q.toNbt()));
        data.m_128365_("Quests", (Tag)questsTag);
        ChangShengJueMessages.sendToPlayer(new SyncQuestDataPacket(player.m_20148_(), data), player);
    }

    public void removeQuestFromPlayer(UUID playerId, UUID questId) {
        List<Quest> playerQuestList = this.playerQuests.get(playerId);
        if (playerQuestList != null) {
            playerQuestList.removeIf(quest -> quest.getQuestId().equals(questId));
            if (playerQuestList.isEmpty()) {
                this.playerQuests.remove(playerId);
            }
        }
    }

    public List<Quest> getQuests(UUID playerId) {
        return Collections.unmodifiableList(this.playerQuests.computeIfAbsent(playerId, k -> new ArrayList()));
    }

    public void setQuests(Quest quest, UUID playerId) {
        List quests = this.playerQuests.computeIfAbsent(playerId, k -> new CopyOnWriteArrayList());
        for (int i = 0; i < quests.size(); ++i) {
            Quest existingQuest = (Quest)quests.get(i);
            if (existingQuest == null || !existingQuest.getQuestId().equals(quest.getQuestId())) continue;
            quests.set(i, quest);
            return;
        }
        quests.add(quest);
    }

    public int getCompletionCount(UUID questId) {
        return this.questCompletionCounts.getOrDefault(questId, 0);
    }

    public void setCompletionCount(UUID questId) {
        this.questCompletionCounts.merge(questId, 1, Integer::sum);
    }

    public void markQuestCompleted(UUID questId) {
        if (questId != null) {
            this.completedQuests.add(questId);
        }
    }

    public boolean isQuestCompleted(UUID questId) {
        return questId != null && this.completedQuests.contains(questId);
    }

    public void resetQuestCompletion(UUID questId) {
        if (questId != null) {
            this.completedQuests.remove(questId);
        }
    }

    public void markQuestAccepted(UUID questId) {
        if (questId != null) {
            this.acceptedQuests.add(questId);
        }
    }

    public boolean isQuestAccepted(UUID questId) {
        return questId != null && !this.acceptedQuests.contains(questId);
    }

    public void resetQuestAcceptance(UUID questId) {
        if (questId != null) {
            this.acceptedQuests.remove(questId);
        }
    }

    public boolean isFirstLargeTransactionTrigger() {
        return this.firstLargeTransactionTrigger;
    }

    public void setFirstLargeTransactionTrigger(boolean firstLargeTransactionTrigger) {
        this.firstLargeTransactionTrigger = firstLargeTransactionTrigger;
    }
}

