/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.cilent.gui.screens.button;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TexturedButtonWithText
extends ImageButton {
    private int originalX;
    private int originalY;
    private float currentScale;
    private final float targetScale;
    private final float hoverScale;
    private final float animationSpeed = 0.1f;
    private final Component buttonText;
    private final int textColor;
    private final int hoverTextColor;
    private final float textScale;
    private final boolean pDropShadow;
    private ResourceLocation iconTexture;
    private int iconX;
    private int iconY;
    private int iconWidth;
    private int iconHeight;
    private int iconTextureWidth;
    private int iconTextureHeight;
    private float iconScale;
    private IconPosition iconPosition;
    private ItemStack itemIcon;
    private float itemIconScale;
    private IconPosition itemIconPosition;

    public TexturedButtonWithText(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffTex, ResourceLocation resourceLocation, int textureWidth, int textureHeight, Button.OnPress onPress, Component text, int textColor, int hoverTextColor, float textScale) {
        super(x, y, width, height, xTexStart, yTexStart, yDiffTex, resourceLocation, textureWidth, textureHeight, onPress, text);
        this.originalX = x;
        this.originalY = y;
        this.currentScale = 1.0f;
        this.targetScale = 1.0f;
        this.hoverScale = 1.1f;
        this.buttonText = text;
        this.textColor = textColor;
        this.hoverTextColor = hoverTextColor;
        this.textScale = textScale;
        this.pDropShadow = false;
        this.iconScale = 1.0f;
        this.iconPosition = IconPosition.LEFT;
        this.itemIconScale = 1.0f;
        this.itemIconPosition = IconPosition.LEFT;
    }

    public TexturedButtonWithText(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffTex, ResourceLocation resourceLocation, int textureWidth, int textureHeight, Button.OnPress onPress, Component text, int textColor, int hoverTextColor, float textScale, boolean pDropShadow) {
        super(x, y, width, height, xTexStart, yTexStart, yDiffTex, resourceLocation, textureWidth, textureHeight, onPress, text);
        this.originalX = x;
        this.originalY = y;
        this.currentScale = 1.0f;
        this.targetScale = 1.0f;
        this.hoverScale = 1.1f;
        this.buttonText = text;
        this.textColor = textColor;
        this.hoverTextColor = hoverTextColor;
        this.textScale = textScale;
        this.pDropShadow = pDropShadow;
        this.iconScale = 1.0f;
        this.iconPosition = IconPosition.LEFT;
        this.itemIconScale = 1.0f;
        this.itemIconPosition = IconPosition.LEFT;
    }

    public TexturedButtonWithText(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffTex, ResourceLocation resourceLocation, int textureWidth, int textureHeight, Button.OnPress onPress, Component text, int textColor, int hoverTextColor, float textScale, float currentScale, float targetScale, float hoverScale) {
        super(x, y, width, height, xTexStart, yTexStart, yDiffTex, resourceLocation, textureWidth, textureHeight, onPress, text);
        this.originalX = x;
        this.originalY = y;
        this.currentScale = currentScale;
        this.targetScale = targetScale;
        this.hoverScale = hoverScale;
        this.buttonText = text;
        this.textColor = textColor;
        this.hoverTextColor = hoverTextColor;
        this.textScale = textScale;
        this.pDropShadow = false;
        this.iconScale = 1.0f;
        this.iconPosition = IconPosition.LEFT;
        this.itemIconScale = 1.0f;
        this.itemIconPosition = IconPosition.LEFT;
    }

    public TexturedButtonWithText setIcon(ResourceLocation texture, int x, int y, int width, int height, int textureWidth, int textureHeight) {
        this.iconTexture = texture;
        this.iconX = x;
        this.iconY = y;
        this.iconWidth = width;
        this.iconHeight = height;
        this.iconTextureWidth = textureWidth;
        this.iconTextureHeight = textureHeight;
        return this;
    }

    public TexturedButtonWithText setItemIcon(ItemStack itemStack) {
        this.itemIcon = itemStack;
        return this;
    }

    public TexturedButtonWithText setItemIconScale(float scale) {
        this.itemIconScale = scale;
        return this;
    }

    public TexturedButtonWithText setItemIconPosition(IconPosition position) {
        this.itemIconPosition = position;
        return this;
    }

    public TexturedButtonWithText setIconPosition(IconPosition position) {
        this.iconPosition = position;
        return this;
    }

    public TexturedButtonWithText setIconScale(float scale) {
        this.iconScale = scale;
        return this;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.currentScale = Mth.m_14179_((float)0.1f, (float)this.currentScale, (float)(this.m_198029_() ? this.hoverScale : this.targetScale));
        this.m_252865_(this.originalX);
        this.m_253211_(this.originalY);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        float centerX = (float)this.originalX + (float)this.f_93618_ / 2.0f;
        float centerY = (float)this.originalY + (float)this.f_93619_ / 2.0f;
        poseStack.m_252880_(centerX, centerY, 0.0f);
        poseStack.m_85841_(this.currentScale, this.currentScale, 1.0f);
        poseStack.m_252880_(-centerX, -centerY, 0.0f);
        super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderIconAndText(guiGraphics, poseStack);
        poseStack.m_85849_();
    }

    private void renderIconAndText(GuiGraphics guiGraphics, PoseStack poseStack) {
        Font font = Minecraft.m_91087_().f_91062_;
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        if (this.itemIcon != null) {
            this.renderItemIconAndText(guiGraphics, poseStack, font, itemRenderer);
        } else if (this.iconTexture != null) {
            this.renderTextureIconAndText(guiGraphics, poseStack, font);
        } else {
            this.renderTextOnly(guiGraphics, poseStack, font);
        }
    }

    private void renderItemIconAndText(GuiGraphics guiGraphics, PoseStack poseStack, Font font, ItemRenderer itemRenderer) {
        double textStartY;
        double iconY;
        double textStartX;
        double iconX;
        List lines = font.m_92923_((FormattedText)this.buttonText, (int)((float)(this.f_93618_ - 8) / this.textScale));
        double buttonCenterX = (double)this.m_252754_() + (double)this.f_93618_ / 2.0;
        double buttonCenterY = (double)this.m_252907_() + (double)this.f_93619_ / 2.0;
        int itemIconSize = (int)(16.0f * this.itemIconScale);
        int n = lines.size();
        Objects.requireNonNull(font);
        int totalTextHeight = (int)((float)(n * 9) * this.textScale);
        double maxTextWidth = this.getMaxLineWidth(font, lines) * (double)this.textScale;
        switch (this.itemIconPosition) {
            case LEFT: 
            case RIGHT: {
                double totalWidth = maxTextWidth + (double)itemIconSize + 4.0;
                iconX = buttonCenterX - totalWidth / 2.0;
                textStartX = iconX + (double)itemIconSize + 4.0;
                iconY = buttonCenterY - (double)itemIconSize / 2.0;
                textStartY = buttonCenterY - (double)totalTextHeight / 2.0;
                if (this.itemIconPosition != IconPosition.RIGHT) break;
                iconX = buttonCenterX + totalWidth / 2.0 - (double)itemIconSize;
                textStartX = iconX - maxTextWidth - 4.0;
                break;
            }
            case TOP: 
            case BOTTOM: {
                double totalHeight = totalTextHeight + itemIconSize + 4;
                iconX = buttonCenterX - (double)itemIconSize / 2.0;
                textStartX = buttonCenterX - maxTextWidth / 2.0;
                iconY = buttonCenterY - totalHeight / 2.0;
                textStartY = iconY + (double)itemIconSize + 4.0;
                if (this.itemIconPosition != IconPosition.BOTTOM) break;
                iconY = buttonCenterY + totalHeight / 2.0 - (double)itemIconSize;
                textStartY = iconY - (double)totalTextHeight - 4.0;
                break;
            }
            default: {
                iconX = buttonCenterX - (double)itemIconSize / 2.0;
                iconY = buttonCenterY - (double)itemIconSize / 2.0;
                textStartY = 0.0;
                textStartX = 0.0;
            }
        }
        poseStack.m_85836_();
        poseStack.m_85837_(iconX, iconY, 0.0);
        poseStack.m_85841_(this.itemIconScale, this.itemIconScale, 1.0f);
        poseStack.m_85837_(-iconX, -iconY, 0.0);
        guiGraphics.m_280480_(this.itemIcon, (int)iconX, (int)iconY);
        poseStack.m_85849_();
        if (this.itemIconPosition != IconPosition.CENTER && !lines.isEmpty()) {
            this.renderTextLines(guiGraphics, font, lines, textStartX, textStartY, poseStack);
        }
    }

    private void renderTextureIconAndText(GuiGraphics guiGraphics, PoseStack poseStack, Font font) {
        double buttonCenterX = (double)this.m_252754_() + (double)this.f_93618_ / 2.0;
        double buttonCenterY = (double)this.m_252907_() + (double)this.f_93619_ / 2.0;
        int iconRenderWidth = (int)((float)this.iconWidth * this.iconScale);
        int iconRenderHeight = (int)((float)this.iconHeight * this.iconScale);
        double iconX = buttonCenterX - (double)iconRenderWidth / 2.0;
        double iconY = buttonCenterY - (double)iconRenderHeight / 2.0;
        poseStack.m_85836_();
        poseStack.m_85837_(iconX, iconY, 0.0);
        poseStack.m_85841_(this.iconScale, this.iconScale, 1.0f);
        poseStack.m_85837_(-iconX, -iconY, 0.0);
        guiGraphics.m_280411_(this.iconTexture, (int)iconX, (int)iconY, iconRenderWidth, iconRenderHeight, (float)this.iconX, (float)this.iconY, this.iconWidth, this.iconHeight, this.iconTextureWidth, this.iconTextureHeight);
        poseStack.m_85849_();
    }

    private void renderTextOnly(GuiGraphics guiGraphics, PoseStack poseStack, Font font) {
        List lines = font.m_92923_((FormattedText)this.buttonText, (int)((float)(this.f_93618_ - 8) / this.textScale));
        double buttonCenterX = (double)this.m_252754_() + (double)this.f_93618_ / 2.0;
        double buttonCenterY = (double)this.m_252907_() + (double)this.f_93619_ / 2.0;
        int n = lines.size();
        Objects.requireNonNull(font);
        int totalTextHeight = (int)((float)(n * 9) * this.textScale);
        double textStartY = buttonCenterY - (double)totalTextHeight / 2.0;
        this.renderTextLines(guiGraphics, font, lines, buttonCenterX, textStartY, poseStack);
    }

    private void renderTextLines(GuiGraphics guiGraphics, Font font, List<FormattedCharSequence> lines, double centerX, double startY, PoseStack poseStack) {
        int color = this.m_198029_() ? this.hoverTextColor : this.textColor;
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = lines.get(i);
            double lineWidth = (float)font.m_92724_(line) * this.textScale;
            double x = centerX - lineWidth / 2.0;
            Objects.requireNonNull(font);
            double y = startY + (double)((float)(i * 9) * this.textScale);
            poseStack.m_85836_();
            poseStack.m_85837_(x, y, 0.0);
            poseStack.m_85841_(this.textScale, this.textScale, 1.0f);
            poseStack.m_85837_(-x, -y, 0.0);
            guiGraphics.m_280649_(font, line, (int)Math.round(x), (int)Math.round(y), color, this.pDropShadow);
            poseStack.m_85849_();
        }
    }

    private double getMaxLineWidth(Font font, List<FormattedCharSequence> lines) {
        return lines.stream().mapToDouble(arg_0 -> ((Font)font).m_92724_(arg_0)).max().orElse(0.0);
    }

    public void m_264152_(int x, int y) {
        super.m_264152_(x, y);
        this.originalX = x;
        this.originalY = y;
    }

    public static enum IconPosition {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        CENTER;

    }
}

