/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.cilent.gui.screens.forgeblock;

import com.shengchanshe.chang_sheng_jue.block.ChangShengJueBlocks;
import com.shengchanshe.chang_sheng_jue.block.custom.forgeblock.ForgeBlockEntity;
import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.ChangShengJueMenuTypes;
import com.shengchanshe.chang_sheng_jue.recipe.ForgeBlockRecipe;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ForgeBlockMenu
extends AbstractContainerMenu {
    public final ForgeBlockEntity blockEntity;
    public final Level level;
    public final ContainerData data;
    ForgeBlockRecipe currentRecipe = null;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 10;

    public ForgeBlockMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(2));
    }

    public ForgeBlockMenu(int pContainerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)ChangShengJueMenuTypes.FORGE_BLOCK_MENU.get(), pContainerId);
        ForgeBlockMenu.m_38869_((Container)inv, (int)10);
        this.blockEntity = (ForgeBlockEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.currentRecipe = this.blockEntity.getCurrentRecipe();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            this.m_38897_((Slot)new ReadOnlySlot((IItemHandler)handler, 0, 135, 46));
            this.m_38897_((Slot)new ReadOnlySlot((IItemHandler)handler, 1, 153, 46));
            this.m_38897_((Slot)new ReadOnlySlot((IItemHandler)handler, 2, 171, 46));
            this.m_38897_((Slot)new ReadOnlySlot((IItemHandler)handler, 3, 135, 64));
            this.m_38897_((Slot)new ReadOnlySlot((IItemHandler)handler, 4, 153, 64));
            this.m_38897_((Slot)new ReadOnlySlot((IItemHandler)handler, 5, 171, 64));
            this.m_38897_((Slot)new ReadOnlySlot((IItemHandler)handler, 6, 135, 82));
            this.m_38897_((Slot)new ReadOnlySlot((IItemHandler)handler, 7, 153, 82));
            this.m_38897_((Slot)new ReadOnlySlot((IItemHandler)handler, 8, 171, 82));
        });
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> this.m_38897_((Slot)new OutputSlot((IItemHandler)handler, 9, 229, 63)));
        this.m_38884_(data);
        if (this.currentRecipe != null) {
            this.updateRecipeSlots();
        }
    }

    public void setCurrentRecipe(ForgeBlockRecipe recipe) {
        this.currentRecipe = recipe;
        this.updateRecipeSlots();
        if (!this.level.f_46443_) {
            this.blockEntity.setCurrentRecipe(recipe);
            this.blockEntity.m_6596_();
        }
    }

    public ForgeBlockRecipe getCurrentRecipe() {
        if (this.currentRecipe != null) {
            return this.currentRecipe;
        }
        if (this.blockEntity != null) {
            return this.blockEntity.getCurrentRecipe();
        }
        return null;
    }

    void updateRecipeSlots() {
        this.clearAllSlots();
        if (this.currentRecipe != null) {
            ItemStack[] materials = this.getMaterialsFromRecipe(this.currentRecipe);
            for (int i = 0; i < materials.length && i < 9; ++i) {
                int slotIndex = i;
                ItemStack material = materials[i].m_41777_();
                this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> handler.insertItem(slotIndex, material, false));
            }
        }
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.blockEntity.onClose(player);
        if (!this.isCrafting()) {
            this.clearAllSlots();
            this.blockEntity.setCurrentRecipe(null);
        }
    }

    public boolean isCrafting() {
        return this.data.m_6413_(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        int progressArrowSize = 26;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public ItemStack[] getMaterialsFromRecipe(ForgeBlockRecipe recipe) {
        ItemStack[] materials = new ItemStack[recipe.m_7527_().size()];
        for (int i = 0; i < recipe.m_7527_().size(); ++i) {
            Ingredient ingredient = (Ingredient)recipe.m_7527_().get(i);
            materials[i] = ingredient.m_43908_().length > 0 ? ingredient.m_43908_()[0].m_41777_() : ItemStack.f_41583_;
        }
        return materials;
    }

    void clearAllSlots() {
        int i = 0;
        while (i < 9) {
            int finalI = i++;
            this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> handler.extractItem(finalI, 64, false));
        }
    }

    public boolean craftItem(Player player) {
        if (this.currentRecipe == null || this.level.m_5776_()) {
            return false;
        }
        if (!this.blockEntity.getItemHandler().getStackInSlot(9).m_41619_()) {
            return false;
        }
        if (this.hasEnoughMaterials(player.m_150109_())) {
            this.consumeMaterials(player.m_150109_());
            this.blockEntity.progress = 1;
            this.blockEntity.m_6596_();
            return true;
        }
        return false;
    }

    boolean hasEnoughMaterials(Inventory playerInventory) {
        ItemStack[] requiredMaterials;
        if (this.currentRecipe == null) {
            return false;
        }
        InvWrapper playerItems = new InvWrapper((Container)playerInventory);
        for (ItemStack required : requiredMaterials = this.getMaterialsFromRecipe(this.currentRecipe)) {
            if (required.m_41619_()) continue;
            int needed = required.m_41613_();
            int found = 0;
            for (int i = 0; i < playerItems.getSlots(); ++i) {
                ItemStack stack = playerItems.getStackInSlot(i);
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)required)) continue;
                if (stack.m_41613_() >= needed) {
                    found = needed;
                    break;
                }
                if ((found += stack.m_41613_()) >= needed) break;
            }
            if (found >= needed) continue;
            return false;
        }
        return true;
    }

    void consumeMaterials(Inventory playerInventory) {
        ItemStack[] requiredMaterials;
        if (this.currentRecipe == null) {
            return;
        }
        block0: for (ItemStack required : requiredMaterials = this.getMaterialsFromRecipe(this.currentRecipe)) {
            if (required.m_41619_()) continue;
            int needed = required.m_41613_();
            for (int i = 0; i < playerInventory.m_6643_(); ++i) {
                ItemStack stack = playerInventory.m_8020_(i);
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)required)) continue;
                int take = Math.min(needed, stack.m_41613_());
                stack.m_41774_(take);
                if ((needed -= take) <= 0) continue block0;
            }
        }
    }

    public ItemStack m_7648_(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.f_38839_.get(pIndex);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (pIndex < 46) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player player) {
        return ForgeBlockMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)ChangShengJueBlocks.FORGE_BLOCK.get()));
    }

    public BlockPos getBlockPos() {
        return this.blockEntity.m_58899_();
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 89 + l * 18, 115 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 89 + i * 18, 173));
        }
    }

    public boolean hasEnoughOfMaterial(Inventory playerInventory, ItemStack required) {
        if (required.m_41619_()) {
            return true;
        }
        InvWrapper playerItems = new InvWrapper((Container)playerInventory);
        int needed = required.m_41613_();
        int found = 0;
        for (int i = 0; i < playerItems.getSlots(); ++i) {
            ItemStack stack = playerItems.getStackInSlot(i);
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)required) || (found += stack.m_41613_()) < needed) continue;
            return true;
        }
        return false;
    }

    public static class OutputSlot
    extends SlotItemHandler {
        public OutputSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }
    }

    public static class ReadOnlySlot
    extends SlotItemHandler {
        public ReadOnlySlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public boolean m_8010_(Player playerIn) {
            return false;
        }
    }

    public static class ForgeRecipe {
        private final ItemStack result;
        private final ItemStack[] materials;

        public ForgeRecipe(ItemStack result, ItemStack ... materials) {
            this.result = result;
            this.materials = materials;
        }

        public ItemStack getResult() {
            return this.result.m_41777_();
        }

        public ItemStack[] getMaterials() {
            return (ItemStack[])Arrays.stream(this.materials).map(ItemStack::m_41777_).toArray(ItemStack[]::new);
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("result", (Tag)this.result.serializeNBT());
            ListTag materialsList = new ListTag();
            for (ItemStack material : this.materials) {
                materialsList.add((Object)material.serializeNBT());
            }
            tag.m_128365_("materials", (Tag)materialsList);
            return tag;
        }

        public static ForgeRecipe deserializeNBT(CompoundTag tag) {
            ItemStack result = ItemStack.m_41712_((CompoundTag)tag.m_128469_("result"));
            ListTag materialsList = tag.m_128437_("materials", 10);
            ItemStack[] materials = new ItemStack[materialsList.size()];
            for (int i = 0; i < materialsList.size(); ++i) {
                materials[i] = ItemStack.m_41712_((CompoundTag)materialsList.m_128728_(i));
            }
            return new ForgeRecipe(result, materials);
        }
    }
}

