/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.cilent.gui.screens.tailoringcase;

import com.shengchanshe.chang_sheng_jue.block.ChangShengJueBlocks;
import com.shengchanshe.chang_sheng_jue.block.custom.tailoringcase.TailoringCaseEntity;
import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.ChangShengJueMenuTypes;
import com.shengchanshe.chang_sheng_jue.item.ChangShengJueItems;
import com.shengchanshe.chang_sheng_jue.recipe.TailoringCaseRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class TailoringCaseMenu
extends AbstractContainerMenu {
    public final TailoringCaseEntity blockEntity;
    private final Level level;
    public final ContainerData data;
    TailoringCaseRecipe currentRecipe = null;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 10;
    public static final Map<ResourceLocation, TailoringRecipe> RECIPE_MAP = new HashMap<ResourceLocation, TailoringRecipe>();
    public static final List<TailoringRecipe> RECIPES = new ArrayList<TailoringRecipe>();

    public TailoringCaseMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(2));
    }

    public TailoringCaseMenu(int pContainerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)ChangShengJueMenuTypes.TAILORING_CASE_MENU.get(), pContainerId);
        TailoringCaseMenu.m_38869_((Container)inv, (int)10);
        this.blockEntity = (TailoringCaseEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.currentRecipe = this.blockEntity.getCurrentRecipe();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            this.m_38897_((Slot)new ReadOnlySlot((IItemHandler)handler, 0, 135, 46));
            this.m_38897_((Slot)new ReadOnlySlot((IItemHandler)handler, 1, 153, 46));
            this.m_38897_((Slot)new ReadOnlySlot((IItemHandler)handler, 2, 171, 46));
            this.m_38897_((Slot)new ReadOnlySlot((IItemHandler)handler, 3, 135, 64));
            this.m_38897_((Slot)new ReadOnlySlot((IItemHandler)handler, 4, 153, 64));
            this.m_38897_((Slot)new ReadOnlySlot((IItemHandler)handler, 5, 171, 64));
            this.m_38897_((Slot)new ReadOnlySlot((IItemHandler)handler, 6, 135, 82));
            this.m_38897_((Slot)new ReadOnlySlot((IItemHandler)handler, 7, 153, 82));
            this.m_38897_((Slot)new ReadOnlySlot((IItemHandler)handler, 8, 171, 82));
        });
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> this.m_38897_((Slot)new OutputSlot((IItemHandler)handler, 9, 229, 63)));
        this.m_38884_(data);
        if (this.currentRecipe != null) {
            this.updateRecipeSlots();
        }
    }

    public TailoringCaseRecipe getCurrentRecipe() {
        if (this.currentRecipe != null) {
            return this.currentRecipe;
        }
        if (this.blockEntity != null) {
            return this.blockEntity.getCurrentRecipe();
        }
        return null;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.blockEntity.onClose(player);
        if (!this.isCrafting()) {
            this.clearAllSlots();
            this.blockEntity.setCurrentRecipe(null);
        }
    }

    public boolean isCrafting() {
        return this.data.m_6413_(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        int progressArrowSize = 26;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public void setCurrentRecipe(TailoringCaseRecipe recipe) {
        this.currentRecipe = recipe;
        this.updateRecipeSlots();
        if (!this.level.f_46443_) {
            this.blockEntity.setCurrentRecipe(recipe);
            this.blockEntity.m_6596_();
        }
    }

    void updateRecipeSlots() {
        this.clearAllSlots();
        if (this.currentRecipe != null) {
            ItemStack[] materials = this.getMaterialsFromRecipe(this.currentRecipe);
            for (int i = 0; i < materials.length && i < 9; ++i) {
                int slotIndex = i;
                ItemStack material = materials[i].m_41777_();
                this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> handler.insertItem(slotIndex, material, false));
            }
        }
    }

    void clearAllSlots() {
        int i = 0;
        while (i < 9) {
            int finalI = i++;
            this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> handler.extractItem(finalI, 64, false));
        }
    }

    boolean hasEnoughMaterials(Inventory playerInventory) {
        ItemStack[] requiredMaterials;
        if (this.currentRecipe == null) {
            return false;
        }
        InvWrapper playerItems = new InvWrapper((Container)playerInventory);
        for (ItemStack required : requiredMaterials = this.getMaterialsFromRecipe(this.currentRecipe)) {
            if (required.m_41619_()) continue;
            int needed = required.m_41613_();
            int found = 0;
            for (int i = 0; i < playerItems.getSlots(); ++i) {
                ItemStack stack = playerItems.getStackInSlot(i);
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)required)) continue;
                if (stack.m_41613_() >= needed) {
                    found = needed;
                    break;
                }
                if ((found += stack.m_41613_()) >= needed) break;
            }
            if (found >= needed) continue;
            return false;
        }
        return true;
    }

    private void consumeMaterials(Inventory playerInventory) {
        ItemStack[] requiredMaterials;
        if (this.currentRecipe == null) {
            return;
        }
        block0: for (ItemStack required : requiredMaterials = this.getMaterialsFromRecipe(this.currentRecipe)) {
            if (required.m_41619_()) continue;
            int needed = required.m_41613_();
            for (int i = 0; i < playerInventory.m_6643_(); ++i) {
                ItemStack stack = playerInventory.m_8020_(i);
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)required)) continue;
                int take = Math.min(needed, stack.m_41613_());
                stack.m_41774_(take);
                if ((needed -= take) <= 0) continue block0;
            }
        }
    }

    public ItemStack m_7648_(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.f_38839_.get(pIndex);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (pIndex < 46) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player player) {
        return TailoringCaseMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)ChangShengJueBlocks.TAILORING_CASE.get()));
    }

    public BlockPos getBlockPos() {
        return this.blockEntity.m_58899_();
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 89 + l * 18, 115 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 89 + i * 18, 173));
        }
    }

    public boolean hasEnoughOfMaterial(Inventory playerInventory, ItemStack required) {
        if (required.m_41619_()) {
            return true;
        }
        InvWrapper playerItems = new InvWrapper((Container)playerInventory);
        int needed = required.m_41613_();
        int found = 0;
        for (int i = 0; i < playerItems.getSlots(); ++i) {
            ItemStack stack = playerItems.getStackInSlot(i);
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)required) || (found += stack.m_41613_()) < needed) continue;
            return true;
        }
        return false;
    }

    public ItemStack[] getMaterialsFromRecipe(TailoringCaseRecipe recipe) {
        ItemStack[] materials = new ItemStack[recipe.m_7527_().size()];
        for (int i = 0; i < recipe.m_7527_().size(); ++i) {
            ItemStack[] items = ((Ingredient)recipe.m_7527_().get(i)).m_43908_();
            materials[i] = items.length > 0 ? items[0].m_41777_() : ItemStack.f_41583_;
        }
        return materials;
    }

    public static void registerRecipe(TailoringRecipe recipe) {
        ResourceLocation key = new ResourceLocation(ForgeRegistries.ITEMS.getKey((Object)recipe.result.m_41720_()).toString() + "_" + recipe.result.m_41613_());
        if (!RECIPE_MAP.containsKey(key)) {
            RECIPE_MAP.put(key, recipe);
            RECIPES.add(recipe);
        }
    }

    public static Optional<TailoringRecipe> findRecipe(ItemStack result) {
        if (result.m_41619_()) {
            return Optional.empty();
        }
        ResourceLocation key = new ResourceLocation(ForgeRegistries.ITEMS.getKey((Object)result.m_41720_()).toString() + "_" + result.m_41613_());
        return Optional.ofNullable(RECIPE_MAP.get(key));
    }

    static {
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.MALE_TAOIST_HELMET.get()), new ItemStack((ItemLike)ChangShengJueItems.SILK.get(), 5)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.MALE_TAOIST_CHESTPLATE.get()), new ItemStack((ItemLike)ChangShengJueItems.SILK.get(), 8)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.TAOIST_LEGGINGS.get()), new ItemStack((ItemLike)ChangShengJueItems.SILK.get(), 7)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.TAOIST_BOOTS.get()), new ItemStack((ItemLike)ChangShengJueItems.SILK.get(), 4)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.FEMALE_TAOIST_CHESTPLATE.get()), new ItemStack((ItemLike)ChangShengJueItems.SILK.get(), 8)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.MALE_CHINESE_WEDDING_DRESS_KYLIN_BUFU.get()), new ItemStack((ItemLike)ChangShengJueItems.SILK.get(), 7), new ItemStack((ItemLike)Items.f_42417_, 1)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.CHINESE_WEDDING_DRESS_GOLDEN_THREAD_SHOES.get()), new ItemStack((ItemLike)ChangShengJueItems.SILK.get(), 2), new ItemStack((ItemLike)Items.f_42417_, 2)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.FEMALE_CHINESE_WEDDING_DRESS_QUEEN_CLOTHING.get()), new ItemStack((ItemLike)ChangShengJueItems.SILK.get(), 7), new ItemStack((ItemLike)Items.f_42417_, 1)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.WHITE_COTTON_HELMET.get()), new ItemStack((ItemLike)Items.f_42454_, 2), new ItemStack((ItemLike)ChangShengJueItems.COTTON.get(), 2), new ItemStack((ItemLike)ChangShengJueItems.WHITE_PEACOCK_FEATHERS.get(), 1)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.COTTON_HELMET.get()), new ItemStack((ItemLike)Items.f_42454_, 2), new ItemStack((ItemLike)ChangShengJueItems.COTTON.get(), 2), new ItemStack((ItemLike)ChangShengJueItems.PEACOCK_FEATHERS.get(), 1)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.COTTON_CHESTPLATE.get()), new ItemStack((ItemLike)Items.f_42454_, 4), new ItemStack((ItemLike)ChangShengJueItems.COTTON.get(), 4)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.COTTON_LEGGINGS.get()), new ItemStack((ItemLike)Items.f_42454_, 4), new ItemStack((ItemLike)ChangShengJueItems.COTTON.get(), 3)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.COTTON_BOOTS.get()), new ItemStack((ItemLike)Items.f_42454_, 2), new ItemStack((ItemLike)ChangShengJueItems.COTTON.get(), 2)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.MOUNTAIN_PATTERN_DEERSKIN_TIBIAL_ARMOR.get()), new ItemStack((ItemLike)Items.f_42416_, 5), new ItemStack((ItemLike)Items.f_42454_, 2)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.MOUNTAIN_PATTERN_CLOUD_BLACK_BOOTS.get()), new ItemStack((ItemLike)Items.f_42416_, 2), new ItemStack((ItemLike)Items.f_42454_, 2)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.WALKER_CHESTPLATE.get()), new ItemStack((ItemLike)ChangShengJueItems.SILK.get(), 6), new ItemStack((ItemLike)Items.f_42534_, 1), new ItemStack((ItemLike)Items.f_42416_, 1)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.WALKER_TIGER_SKIN_SKIRT.get()), new ItemStack((ItemLike)ChangShengJueItems.SILK.get(), 5), new ItemStack((ItemLike)ChangShengJueItems.TIGER_SKIN.get(), 2)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.WALKER_SHORT_BOOTS.get()), new ItemStack((ItemLike)Items.f_42454_, 2), new ItemStack((ItemLike)Items.f_42416_, 2)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.FLY_FISH_CLOUD_VEIL_CROWN.get()), new ItemStack((ItemLike)ChangShengJueItems.SILK.get(), 5)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.FLY_FISH_CHESTPLATE.get()), new ItemStack((ItemLike)ChangShengJueItems.SILK.get(), 7), new ItemStack((ItemLike)Items.f_42417_, 1), new ItemStack((ItemLike)ChangShengJueItems.CROC_SKIN.get(), 1)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.FLY_FISH_LONG_BOOTS.get()), new ItemStack((ItemLike)ChangShengJueItems.CROC_SKIN.get(), 1), new ItemStack((ItemLike)Items.f_42416_, 3)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.LEATHER_INNER_ARMOR.get()), new ItemStack((ItemLike)ChangShengJueItems.CROC_SKIN.get(), 8)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.CONFUCIAN_HELMET.get()), new ItemStack((ItemLike)ChangShengJueItems.SILK.get(), 4), new ItemStack((ItemLike)Items.f_42415_, 1)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.CONFUCIAN_INK_CHESTPLATE.get()), new ItemStack((ItemLike)ChangShengJueItems.SILK.get(), 7), new ItemStack((ItemLike)Items.f_42616_, 1)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.CONFUCIAN_INK_LEGGINGS.get()), new ItemStack((ItemLike)ChangShengJueItems.SILK.get(), 7)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.CONFUCIAN_INK_BOOTS.get()), new ItemStack((ItemLike)ChangShengJueItems.SILK.get(), 3)));
        TailoringCaseMenu.registerRecipe(new TailoringRecipe(new ItemStack((ItemLike)ChangShengJueItems.THE_GREAT_GENERAL_MING_GUANG_ANIMAL_SKIN_BOOTS.get()), new ItemStack((ItemLike)Items.f_42454_, 2), new ItemStack((ItemLike)ChangShengJueItems.CROC_SKIN.get(), 2)));
    }

    public static class TailoringRecipe {
        private final ItemStack result;
        private final ItemStack[] materials;

        public TailoringRecipe(ItemStack result, ItemStack ... materials) {
            this.result = result;
            this.materials = materials;
        }

        public ItemStack getResult() {
            return this.result.m_41777_();
        }

        public ItemStack[] getMaterials() {
            return (ItemStack[])Arrays.stream(this.materials).map(ItemStack::m_41777_).toArray(ItemStack[]::new);
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("result", (Tag)this.result.serializeNBT());
            ListTag materialsList = new ListTag();
            for (ItemStack material : this.materials) {
                materialsList.add((Object)material.serializeNBT());
            }
            tag.m_128365_("materials", (Tag)materialsList);
            return tag;
        }

        public static TailoringRecipe deserializeNBT(CompoundTag tag) {
            ItemStack result = ItemStack.m_41712_((CompoundTag)tag.m_128469_("result"));
            ListTag materialsList = tag.m_128437_("materials", 10);
            ItemStack[] materials = new ItemStack[materialsList.size()];
            for (int i = 0; i < materialsList.size(); ++i) {
                materials[i] = ItemStack.m_41712_((CompoundTag)materialsList.m_128728_(i));
            }
            return new TailoringRecipe(result, materials);
        }
    }

    public static class OutputSlot
    extends SlotItemHandler {
        public OutputSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }
    }

    public static class ReadOnlySlot
    extends SlotItemHandler {
        public ReadOnlySlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public boolean m_8010_(Player playerIn) {
            return false;
        }
    }
}

