/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.cilent.gui.screens.tailoringcase;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.shengchanshe.chang_sheng_jue.block.ChangShengJueBlocks;
import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.button.TexturedButtonWithText;
import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.tailoringcase.TailoringCaseMenu;
import com.shengchanshe.chang_sheng_jue.network.ChangShengJueMessages;
import com.shengchanshe.chang_sheng_jue.network.packet.gui.craftitem.TailoringCraftPacket;
import com.shengchanshe.chang_sheng_jue.network.packet.gui.craftitem.TailoringSyncRecipePacket;
import com.shengchanshe.chang_sheng_jue.recipe.TailoringCaseRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.joml.Quaternionf;

public class TailoringCaseScreen
extends AbstractContainerScreen<TailoringCaseMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("chang_sheng_jue", "textures/gui/tailoring_case_menu.png");
    private static final ResourceLocation BOTTON = new ResourceLocation("chang_sheng_jue", "textures/gui/botton.png");
    private final List<CustomButton> customButtons = new ArrayList<CustomButton>();
    private ItemStack currentSelectedItem = ItemStack.f_41583_;
    private ArmorStand armorStandEntity;
    private float rotation = 0.0f;
    private TexturedButtonWithText craftButton;
    private int scrollOffset = 0;
    private static final int VISIBLE_ROWS = 8;
    private static final int TOTAL_ROWS = 10;
    private boolean isDragging = false;
    private int scrollBarHeight = 0;
    private int scrollBarY = 0;
    private int scrollBarX = 0;
    private final List<ItemStack> currentMaterials = new ArrayList<ItemStack>();
    private List<TailoringCaseRecipe> cachedRecipes = new ArrayList<TailoringCaseRecipe>();
    private final Map<String, List<TailoringCaseRecipe>> recipesByGroup = new HashMap<String, List<TailoringCaseRecipe>>();
    private int currentRecipeIndex = 0;
    private int carouselTick = 0;
    private static final int CAROUSEL_INTERVAL = 20;
    private boolean isCarouselPaused = false;
    private List<TailoringCaseRecipe> currentRecipeGroup = new ArrayList<TailoringCaseRecipe>();
    private TailoringCaseRecipe localCurrentRecipe = null;

    public TailoringCaseScreen(TailoringCaseMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 276;
        this.f_97727_ = 216;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.customButtons.clear();
        this.scrollOffset = 0;
        this.createArmorStandEntity();
        this.refreshRecipes();
        this.refreshItemButtons();
        TailoringCaseRecipe serverRecipe = ((TailoringCaseMenu)this.f_97732_).getCurrentRecipe();
        if (serverRecipe != null || ((TailoringCaseMenu)this.f_97732_).isCrafting()) {
            this.currentMaterials.clear();
            this.currentMaterials.addAll(Arrays.asList(this.getMaterialsFromRecipe(serverRecipe)));
            if (serverRecipe != null) {
                this.currentSelectedItem = serverRecipe.m_8043_(this.getRegistryAccess());
            }
        }
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.craftButton = (TexturedButtonWithText)this.m_142416_((GuiEventListener)new TexturedButtonWithText(x + 192, y + 95, 55, 17, 0, 106, 17, BOTTON, 256, 256, button -> {
            ChangShengJueMessages.sendToServer(new TailoringCraftPacket(((TailoringCaseMenu)this.f_97732_).getBlockPos()));
            this.isCarouselPaused = true;
            this.carouselTick = 0;
        }, (Component)Component.m_237115_((String)"gui.chang_sheng_jue.tailoring_case.craft"), 0xFFFFFF, 0xFFFFFF, 1.0f, true));
    }

    private void refreshRecipes() {
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            try {
                RecipeManager recipeManager = this.f_96541_.f_91073_.m_7465_();
                TailoringCaseRecipe.Type recipeType = TailoringCaseRecipe.Type.INSTANCE;
                this.cachedRecipes = recipeManager.m_44013_((RecipeType)recipeType);
                this.recipesByGroup.clear();
                for (TailoringCaseRecipe recipe : this.cachedRecipes) {
                    String group = recipe.m_6076_();
                    if (group.isEmpty()) continue;
                    this.recipesByGroup.computeIfAbsent(group, k -> new ArrayList()).add(recipe);
                }
            }
            catch (Exception e) {
                this.cachedRecipes = new ArrayList<TailoringCaseRecipe>();
                this.recipesByGroup.clear();
                e.printStackTrace();
            }
        } else {
            this.cachedRecipes.clear();
            this.recipesByGroup.clear();
        }
    }

    private void refreshItemButtons() {
        ItemStack previouslySelectedItem = this.currentSelectedItem.m_41777_();
        for (CustomButton button : this.customButtons) {
            this.m_169411_((GuiEventListener)button);
        }
        this.customButtons.clear();
        int row = 0;
        int col = 0;
        int startIndex = this.scrollOffset * 5;
        int maxScrollOffset = Math.max(0, (this.cachedRecipes.size() + 4) / 5 - 8);
        if (this.scrollOffset > maxScrollOffset) {
            this.scrollOffset = maxScrollOffset;
        }
        ArrayList<ItemStack> addedItems = new ArrayList<ItemStack>();
        for (int i = startIndex; i < this.cachedRecipes.size() && row < 8; ++i) {
            TailoringCaseRecipe recipe = this.cachedRecipes.get(i);
            ItemStack resultItem = recipe.m_8043_(this.getRegistryAccess());
            boolean alreadyAdded = false;
            for (ItemStack addedItem : addedItems) {
                if (!ItemStack.m_150942_((ItemStack)addedItem, (ItemStack)resultItem)) continue;
                alreadyAdded = true;
                break;
            }
            if (alreadyAdded) continue;
            addedItems.add(resultItem);
            this.createButton(col, row, resultItem, recipe);
            if (++col < 5) continue;
            col = 0;
            ++row;
        }
        if (this.cachedRecipes.isEmpty()) {
            this.refreshRecipes();
        }
        if (!previouslySelectedItem.m_41619_()) {
            for (CustomButton button : this.customButtons) {
                if (!ItemStack.m_150942_((ItemStack)button.itemStack, (ItemStack)previouslySelectedItem)) continue;
                button.COUNT = 1;
                break;
            }
        }
    }

    private void createButton(int x, int y, ItemStack item, TailoringCaseRecipe recipe) {
        int centerX = (this.f_96543_ - this.f_97726_) / 2 - 13 + x * 18;
        int centerY = (this.f_96544_ - this.f_97727_) / 2 + 45 + y * 18;
        CustomButton button = new CustomButton(centerX, centerY, 18, 18, (Component)Component.m_237113_((String)" "), button1 -> {
            for (CustomButton btn : this.customButtons) {
                btn.COUNT = 0;
            }
            ((CustomButton)button1).COUNT = 1;
            this.currentSelectedItem = ((CustomButton)button1).itemStack;
            String group = recipe.m_6076_();
            if (!group.isEmpty() && this.recipesByGroup.containsKey(group)) {
                this.currentRecipeGroup = new ArrayList<TailoringCaseRecipe>((Collection)this.recipesByGroup.get(group));
                this.currentRecipeIndex = this.currentRecipeGroup.indexOf(recipe);
                this.updateSlotsForSelectedItem(this.currentRecipeGroup.get(this.currentRecipeIndex));
            } else {
                this.currentRecipeGroup.clear();
                this.currentRecipeIndex = 0;
                this.updateSlotsForSelectedItem(recipe);
            }
        }, item, recipe);
        button.f_93623_ = !((TailoringCaseMenu)this.f_97732_).isCrafting();
        button.m_93650_(((TailoringCaseMenu)this.f_97732_).isCrafting() ? 0.5f : 1.0f);
        this.m_142416_((GuiEventListener)button);
        this.customButtons.add(button);
    }

    private void updateSlotsForSelectedItem(TailoringCaseRecipe recipe) {
        if (((TailoringCaseMenu)this.f_97732_).isCrafting()) {
            return;
        }
        String group = recipe.m_6076_();
        if (!group.isEmpty() && this.recipesByGroup.containsKey(group)) {
            this.currentRecipeGroup = new ArrayList<TailoringCaseRecipe>((Collection)this.recipesByGroup.get(group));
            this.currentRecipeIndex = this.currentRecipeGroup.indexOf(recipe);
        } else {
            this.currentRecipeGroup.clear();
            this.currentRecipeIndex = 0;
        }
        this.currentMaterials.clear();
        if (recipe != null) {
            ItemStack[] materials = this.getMaterialsFromRecipe(recipe);
            this.currentMaterials.addAll(Arrays.asList(materials));
        }
        ((TailoringCaseMenu)this.f_97732_).setCurrentRecipe(recipe);
        this.localCurrentRecipe = recipe;
        ChangShengJueMessages.sendToServer(new TailoringSyncRecipePacket(((TailoringCaseMenu)this.f_97732_).getBlockPos(), recipe));
        ((TailoringCaseMenu)this.f_97732_).updateRecipeSlots();
    }

    private void updateSlotsForCraftingRecipe(TailoringCaseRecipe recipe) {
        String group = recipe.m_6076_();
        if (!group.isEmpty() && this.recipesByGroup.containsKey(group)) {
            this.currentRecipeGroup = new ArrayList<TailoringCaseRecipe>((Collection)this.recipesByGroup.get(group));
            this.currentRecipeIndex = this.currentRecipeGroup.indexOf(recipe);
        } else {
            this.currentRecipeGroup.clear();
            this.currentRecipeIndex = 0;
        }
        this.currentMaterials.clear();
        if (recipe != null) {
            ItemStack[] materials = this.getMaterialsFromRecipe(recipe);
            this.currentMaterials.addAll(Arrays.asList(materials));
        }
        ((TailoringCaseMenu)this.f_97732_).setCurrentRecipe(recipe);
        this.localCurrentRecipe = recipe;
        ChangShengJueMessages.sendToServer(new TailoringSyncRecipePacket(((TailoringCaseMenu)this.f_97732_).getBlockPos(), recipe));
        ((TailoringCaseMenu)this.f_97732_).updateRecipeSlots();
    }

    private Level getMenuLevel() {
        return this.f_96541_.f_91073_;
    }

    private RegistryAccess getRegistryAccess() {
        return this.getMenuLevel().m_9598_();
    }

    private ItemStack[] getMaterialsFromRecipe(TailoringCaseRecipe recipe) {
        if (recipe == null) {
            return new ItemStack[0];
        }
        ItemStack[] materials = (ItemStack[])recipe.m_7527_().stream().map(ingredient -> {
            ItemStack[] items = ingredient.m_43908_();
            if (items.length > 0) {
                return items[0];
            }
            return ItemStack.f_41583_;
        }).toArray(ItemStack[]::new);
        return materials;
    }

    private void createArmorStandEntity() {
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            return;
        }
        this.armorStandEntity = new ArmorStand((Level)this.f_96541_.f_91073_, 0.0, 0.0, 0.0);
        this.armorStandEntity.m_31678_(true);
        this.armorStandEntity.m_31675_(true);
        this.armorStandEntity.m_6842_(false);
        this.armorStandEntity.m_5618_(0.0f);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280163_(TEXTURE, x - 20, y - 20, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 512);
        this.renderCustomProgressBar(guiGraphics, x, y);
        this.scrollBarX = x - 13 + 90;
        this.scrollBarY = y + 45;
        this.scrollBarHeight = 144;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                ItemStack required;
                int slotIndex = row * 3 + col;
                int slotX = x + 134 + col * 18;
                int slotY = y + 45 + row * 18;
                if (slotIndex >= this.currentMaterials.size() || (required = this.currentMaterials.get(slotIndex)).m_41619_()) continue;
                boolean isMaterialEnough = ((TailoringCaseMenu)this.f_97732_).hasEnoughOfMaterial(this.f_96541_.f_91074_.m_150109_(), required);
                int textureV = isMaterialEnough ? 217 : 235;
                guiGraphics.m_280163_(TEXTURE, slotX, slotY, 18.0f, (float)textureV, 18, 18, 512, 512);
            }
        }
        int maxScrollOffset = Math.max(0, (this.cachedRecipes.size() + 4) / 5 - 8);
        float scrollProgress = maxScrollOffset > 0 ? (float)this.scrollOffset / (float)maxScrollOffset : 0.0f;
        int sliderHeight = Math.max(15, (int)(8.0f / (float)Math.max(1, (this.cachedRecipes.size() + 4) / 5) * (float)this.scrollBarHeight));
        int sliderY = this.scrollBarY + (int)(scrollProgress * (float)(this.scrollBarHeight - sliderHeight));
        int scrollerTextureV = this.isDragging ? 6 : 0;
        guiGraphics.m_280163_(TEXTURE, this.scrollBarX + 1, sliderY, (float)scrollerTextureV, 271.0f, 6, 15, 512, 512);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int maxScrollOffset = Math.max(0, (this.cachedRecipes.size() + 4) / 5 - 8);
        if (delta > 0.0 && this.scrollOffset > 0) {
            --this.scrollOffset;
            this.refreshItemButtons();
            return true;
        }
        if (delta < 0.0 && this.scrollOffset < maxScrollOffset) {
            ++this.scrollOffset;
            this.refreshItemButtons();
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int maxScrollOffset = Math.max(0, (this.cachedRecipes.size() + 4) / 5 - 8);
        if (maxScrollOffset > 0) {
            float scrollProgress = maxScrollOffset > 0 ? (float)this.scrollOffset / (float)maxScrollOffset : 0.0f;
            int sliderHeight = Math.max(15, (int)(8.0f / (float)Math.max(1, (this.cachedRecipes.size() + 4) / 5) * (float)this.scrollBarHeight));
            int sliderY = this.scrollBarY + (int)(scrollProgress * (float)(this.scrollBarHeight - sliderHeight));
            if (mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + 6) && mouseY >= (double)sliderY && mouseY <= (double)(sliderY + sliderHeight)) {
                this.isDragging = true;
                return true;
            }
            if (mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + 6) && mouseY >= (double)this.scrollBarY && mouseY <= (double)(this.scrollBarY + this.scrollBarHeight)) {
                float clickProgress = (float)(mouseY - (double)this.scrollBarY) / (float)this.scrollBarHeight;
                int newScrollOffset = Math.round(clickProgress * (float)maxScrollOffset);
                this.scrollOffset = Math.max(0, Math.min(maxScrollOffset, newScrollOffset));
                this.refreshItemButtons();
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging) {
            this.updateScrollFromMousePos(mouseY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    private void updateScrollFromMousePos(double mouseY) {
        int maxScrollOffset = Math.max(0, (this.cachedRecipes.size() + 4) / 5 - 8);
        if (maxScrollOffset <= 0) {
            return;
        }
        float scrollSensitivity = 0.2f;
        float relativeY = (float)(mouseY - (double)this.scrollBarY) / ((float)this.scrollBarHeight * scrollSensitivity);
        relativeY = Math.max(0.0f, Math.min(1.0f, relativeY));
        this.scrollOffset = (int)(relativeY * (float)maxScrollOffset);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, maxScrollOffset));
        this.refreshItemButtons();
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isDragging) {
            this.isDragging = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        if (((TailoringCaseMenu)this.f_97732_).isCrafting()) {
            guiGraphics.m_280218_(TEXTURE, x + 79, y + 34, 176, 0, 8, ((TailoringCaseMenu)this.f_97732_).getScaledProgress());
        }
    }

    private void renderArmorStandWithItem(GuiGraphics guiGraphics) {
        if (this.armorStandEntity == null) {
            return;
        }
        this.updateArmorStandEquipment();
        int armorStandX = this.f_96543_ / 2 - 30;
        int armorStandY = this.f_96544_ / 2 - 15;
        this.renderEntityInInventory(guiGraphics, armorStandX, armorStandY, 25, this.rotation, 180.0f, (Entity)this.armorStandEntity);
        this.rotation = (this.rotation + 0.5f) % 360.0f;
    }

    private void updateArmorStandEquipment() {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            this.armorStandEntity.m_8061_(slot, ItemStack.f_41583_);
        }
        this.armorStandEntity.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        Item item = this.currentSelectedItem.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            this.armorStandEntity.m_8061_(armor.m_40402_(), this.currentSelectedItem);
        } else {
            this.armorStandEntity.m_21008_(InteractionHand.MAIN_HAND, this.currentSelectedItem);
        }
    }

    private void renderEntityInInventory(GuiGraphics guiGraphics, int posX, int posY, int scale, float rotationY, float rotationX, Entity entity) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)posX, (double)posY, 50.0);
        poseStack.m_85841_((float)scale, (float)scale, (float)scale);
        Quaternionf rotationQuat = new Quaternionf().rotationXYZ((float)Math.toRadians(rotationX), (float)Math.toRadians(rotationY), 0.0f);
        poseStack.m_252781_(rotationQuat);
        EntityRenderDispatcher renderer = Minecraft.m_91087_().m_91290_();
        renderer.m_252923_(rotationQuat);
        renderer.m_114468_(false);
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        renderer.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)buffer, 0xF000F0);
        buffer.m_109911_();
        renderer.m_114468_(true);
        poseStack.m_85849_();
    }

    protected void m_280003_(GuiGraphics transform, int x, int y) {
        boolean isChinese = Minecraft.m_91087_().f_91066_.f_92075_.startsWith("zh_");
        if (!isChinese) {
            int fontWidth = this.f_96547_.m_92852_((FormattedText)Component.m_237115_((String)((Block)ChangShengJueBlocks.TAILORING_CASE.get()).m_7705_()));
            int k = 25 + this.f_97726_ / 2 - fontWidth / 2;
            transform.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)((Block)ChangShengJueBlocks.TAILORING_CASE.get()).m_7705_()), k, 35, 0x404040, false);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        for (CustomButton button : this.customButtons) {
            if (!button.m_274382_() || button.getItemStack().m_41619_()) continue;
            this.renderToolTip(guiGraphics, mouseX, mouseY, button.getItemStack());
        }
        this.m_280072_(guiGraphics, mouseX, mouseY);
        this.renderArmorStandWithItem(guiGraphics);
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null && this.f_96541_.f_91073_.m_46467_() % 20L == 0L) {
            this.refreshRecipes();
            this.refreshItemButtons();
        }
        if (!this.currentRecipeGroup.isEmpty() && !((TailoringCaseMenu)this.f_97732_).isCrafting()) {
            ++this.carouselTick;
            if (this.carouselTick >= 20) {
                this.carouselTick = 0;
                this.currentRecipeIndex = (this.currentRecipeIndex + 1) % this.currentRecipeGroup.size();
                CustomButton selectedButton = null;
                for (CustomButton btn : this.customButtons) {
                    if (btn.COUNT != 1) continue;
                    selectedButton = btn;
                    break;
                }
                if (selectedButton != null && !selectedButton.itemStack.m_41619_() && !this.currentRecipeGroup.isEmpty() && ItemStack.m_150942_((ItemStack)selectedButton.itemStack, (ItemStack)this.currentRecipeGroup.get(this.currentRecipeIndex).m_8043_(this.getRegistryAccess()))) {
                    this.updateSlotsForSelectedItem(this.currentRecipeGroup.get(this.currentRecipeIndex));
                }
            }
        }
        if (((TailoringCaseMenu)this.f_97732_).isCrafting()) {
            this.carouselTick = 0;
            TailoringCaseRecipe blockEntityRecipe = ((TailoringCaseMenu)this.f_97732_).blockEntity.getCurrentRecipe();
            if (blockEntityRecipe != null && this.localCurrentRecipe != blockEntityRecipe) {
                this.updateSlotsForCraftingRecipe(blockEntityRecipe);
            } else if (this.localCurrentRecipe != null) {
                this.updateSlotsForCraftingRecipe(this.localCurrentRecipe);
            }
        }
    }

    private boolean isAir(int guix, int guiy, int mouseX, int mouseY) {
        return mouseX >= guix && mouseX < guix + 18 && mouseY >= guiy && mouseY < guiy + 18;
    }

    private void renderToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY, ItemStack stack) {
        int tooltipX = mouseX + 10;
        int tooltipY = mouseY + 10;
        guiGraphics.m_280153_(this.f_96547_, stack, tooltipX, tooltipY);
    }

    private void renderCustomProgressBar(GuiGraphics guiGraphics, int x, int y) {
        int progressBarX = x + 191;
        int progressBarY = y + 59;
        int progressBarWidth = 32;
        int progressBarHeight = 22;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280163_(TEXTURE, progressBarX, progressBarY, 0.0f, 308.0f, progressBarWidth, progressBarHeight, 512, 512);
        if (((TailoringCaseMenu)this.f_97732_).isCrafting()) {
            int scaledProgress = ((TailoringCaseMenu)this.f_97732_).getScaledProgress();
            guiGraphics.m_280163_(TEXTURE, progressBarX, progressBarY, 0.0f, 286.0f, scaledProgress + 5, progressBarHeight, 512, 512);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 258 && !this.currentRecipeGroup.isEmpty()) {
            this.isCarouselPaused = true;
            this.carouselTick = 0;
            this.currentRecipeIndex = (this.currentRecipeIndex + 1) % this.currentRecipeGroup.size();
            this.updateSlotsForSelectedItem(this.currentRecipeGroup.get(this.currentRecipeIndex));
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_94757_(double mouseX, double mouseY) {
        super.m_94757_(mouseX, mouseY);
    }

    private class CustomButton
    extends Button {
        private ItemStack itemStack;
        private static final int TEXTURE_Y_NORMAL = 217;
        private static final int TEXTURE_Y_PRESS = 235;
        int COUNT;
        private TailoringCaseRecipe recipe;
        private boolean isHovered;

        protected CustomButton(int pX, int pY, int pWidth, int pHeight, Component pMessage, Button.OnPress pOnPress, ItemStack itemStack, TailoringCaseRecipe recipe) {
            super(pX, pY, pWidth, pHeight, pMessage, pOnPress, Button.f_252438_);
            this.COUNT = 0;
            this.itemStack = itemStack;
            this.recipe = recipe;
            this.isHovered = false;
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_) {
                int textureY = this.COUNT == 1 ? 235 : 217;
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
                guiGraphics.m_280163_(TEXTURE, this.m_252754_(), this.m_252907_(), 0.0f, (float)textureY, 18, 18, 512, 512);
                ItemStack displayStack = this.itemStack.m_41777_();
                guiGraphics.m_280480_(displayStack, this.m_252754_() + 1, this.m_252907_() + 1);
                if (!this.itemStack.m_41619_() && TailoringCaseScreen.this.isAir(this.m_252754_(), this.m_252907_(), mouseX, mouseY)) {
                    TailoringCaseScreen.this.renderToolTip(guiGraphics, mouseX, mouseY, displayStack);
                }
                if (TailoringCaseScreen.this.craftButton != null) {
                    boolean isCrafting = ((TailoringCaseMenu)TailoringCaseScreen.this.f_97732_).isCrafting();
                    TailoringCaseScreen.this.craftButton.f_93623_ = !isCrafting;
                    TailoringCaseScreen.this.craftButton.f_93624_ = !isCrafting;
                }
            }
        }

        public boolean m_198029_() {
            return this.COUNT == 1 || super.m_198029_();
        }

        public void m_5691_() {
            super.m_5691_();
        }

        public boolean m_274382_() {
            return this.isHovered;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }
    }
}

