/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.cilent.gui.screens.wuxia.blacksmith;

import com.mojang.blaze3d.systems.RenderSystem;
import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.wuxia.blacksmith.BlacksmithMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSelectTradePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlacksmithScreen
extends AbstractContainerScreen<BlacksmithMenu> {
    private static final ResourceLocation VILLAGER_LOCATION = new ResourceLocation("chang_sheng_jue", "textures/gui/container/blacksmith_trading.png");
    private static final ResourceLocation BOTTON = new ResourceLocation("chang_sheng_jue", "textures/gui/botton.png");
    private static final int TEXTURE_WIDTH = 512;
    private static final int TEXTURE_HEIGHT = 512;
    private static final int MERCHANT_MENU_PART_X = 99;
    private static final int PROGRESS_BAR_X = 136;
    private static final int PROGRESS_BAR_Y = 59;
    private static final int SELL_ITEM_1_X = 5;
    private static final int SELL_ITEM_2_X = 35;
    private static final int BUY_ITEM_X = 68;
    private static final int LABEL_Y = 6;
    private static final int NUMBER_OF_OFFER_BUTTONS = 7;
    private static final int TRADE_BUTTON_X = 7;
    private static final int TRADE_BUTTON_HEIGHT = 20;
    private static final int TRADE_BUTTON_WIDTH = 87;
    private static final int SCROLLER_HEIGHT = 27;
    private static final int SCROLLER_WIDTH = 6;
    private static final int SCROLL_BAR_HEIGHT = 139;
    private static final int SCROLL_BAR_TOP_POS_Y = 61;
    private static final int SCROLL_BAR_START_X = 94;
    private static final Component TRADES_LABEL = Component.m_237115_((String)"merchant.trades");
    private static final Component LEVEL_SEPARATOR = Component.m_237113_((String)" - ");
    private static final Component DEPRECATED_TOOLTIP = Component.m_237115_((String)"merchant.deprecated");
    private int shopItem;
    private final TradeOfferButton[] tradeOfferButtons = new TradeOfferButton[7];
    int scrollOff;
    private boolean isDragging;

    public BlacksmithScreen(BlacksmithMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 276;
        this.f_97727_ = 209;
        this.f_97730_ = 107;
        this.f_97731_ = this.f_97727_ - 94;
    }

    private void postButtonClick() {
        ((BlacksmithMenu)this.f_97732_).setSelectionHint(this.shopItem);
        ((BlacksmithMenu)this.f_97732_).tryMoveItems(this.shopItem);
        this.f_96541_.m_91403_().m_104955_((Packet)new ServerboundSelectTradePacket(this.shopItem));
    }

    protected void m_7856_() {
        super.m_7856_();
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        int buttonY = top + 59 + 2;
        for (int i = 0; i < 7; ++i) {
            this.tradeOfferButtons[i] = (TradeOfferButton)this.m_142416_((GuiEventListener)new TradeOfferButton(left + 7, buttonY, i, button -> {
                if (button instanceof TradeOfferButton) {
                    this.shopItem = ((TradeOfferButton)button).getIndex() + this.scrollOff;
                    this.postButtonClick();
                }
            }));
            buttonY += 20;
        }
    }

    protected void m_280003_(GuiGraphics transform, int x, int y) {
        boolean isChinese = Minecraft.m_91087_().f_91066_.f_92075_.startsWith("zh_");
        if (!isChinese) {
            int level = ((BlacksmithMenu)this.f_97732_).getTraderLevel();
            if (level > 0 && level <= 5 && ((BlacksmithMenu)this.f_97732_).showProgressBar()) {
                MutableComponent component = this.f_96539_.m_6881_().m_7220_(LEVEL_SEPARATOR).m_7220_((Component)Component.m_237115_((String)("merchant.level." + level)));
                int fontWidth = this.f_96547_.m_92852_((FormattedText)component);
                int k = 49 + this.f_97726_ / 2 - fontWidth / 2;
                transform.m_280614_(this.f_96547_, (Component)component, k, 6, 0x404040, false);
            } else {
                transform.m_280614_(this.f_96547_, this.f_96539_, 49 + this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, 48, 0x404040, false);
            }
        }
        transform.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
        int l = this.f_96547_.m_92852_((FormattedText)TRADES_LABEL);
        transform.m_280614_(this.f_96547_, TRADES_LABEL, 5 - l / 2 + 48, 48, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics transform, float partialTicks, int x, int y) {
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        transform.m_280398_(VILLAGER_LOCATION, left, top, 0, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 512);
        MerchantOffers merchantoffers = ((BlacksmithMenu)this.f_97732_).getOffers();
        if (!merchantoffers.isEmpty()) {
            int k = this.shopItem;
            if (k < 0 || k >= merchantoffers.size()) {
                return;
            }
            MerchantOffer merchantoffer = (MerchantOffer)merchantoffers.get(k);
            if (merchantoffer.m_45380_()) {
                transform.m_280398_(VILLAGER_LOCATION, this.f_97735_ + 83 + 99, this.f_97736_ + 35, 0, 311.0f, 0.0f, 28, 21, 512, 512);
            }
        }
    }

    private void renderProgressBar(GuiGraphics transform, int x, int y) {
        int level = ((BlacksmithMenu)this.f_97732_).getTraderLevel();
        int xp = ((BlacksmithMenu)this.f_97732_).getTraderXp();
        if (level < 5) {
            transform.m_280398_(VILLAGER_LOCATION, x + 136, y + 59, 0, 0.0f, 186.0f, 102, 5, 512, 512);
            int k = 15;
            if (xp >= k && level > 1) {
                float f = 100.0f / (float)(300 - k);
                int progress = Math.min(Mth.m_14143_((float)(f * (float)(xp - k))), 100);
                transform.m_280398_(VILLAGER_LOCATION, x + 136, y + 59, 0, 0.0f, 191.0f, progress + 1, 5, 512, 512);
                int addXp = ((BlacksmithMenu)this.f_97732_).getFutureTraderXp();
                if (addXp > 0) {
                    int addProgress = Math.min(Mth.m_14143_((float)((float)addXp * f)), 100 - progress);
                    transform.m_280398_(VILLAGER_LOCATION, x + 136 + progress + 1, y + 59 + 1, 0, 2.0f, 182.0f, addProgress, 3, 512, 512);
                }
            }
        }
    }

    private void renderScroller(GuiGraphics transform, int x, int y, MerchantOffers offers) {
        int overSize = offers.size() + 1 - 7;
        if (overSize > 1) {
            int overHeight = 139 - (27 + (overSize - 1) * 139 / overSize);
            int index = 1 + overHeight / overSize + 139 / overSize;
            int scrollY = Math.min(113, this.scrollOff * index);
            if (this.scrollOff == overSize - 1) {
                scrollY = 113;
            }
            transform.m_280398_(VILLAGER_LOCATION, x + 94, y + 61 + scrollY, 0, 0.0f, 249.0f, 6, 27, 512, 512);
        } else {
            transform.m_280398_(VILLAGER_LOCATION, x + 94, y + 61, 0, 6.0f, 249.0f, 6, 27, 512, 512);
        }
    }

    public void m_88315_(GuiGraphics transform, int x, int y, float partialTicks) {
        this.m_280273_(transform);
        super.m_88315_(transform, x, y, partialTicks);
        MerchantOffers merchantoffers = ((BlacksmithMenu)this.f_97732_).getOffers();
        if (!merchantoffers.isEmpty()) {
            int left = (this.f_96543_ - this.f_97726_) / 2;
            int top = (this.f_96544_ - this.f_97727_) / 2;
            int merchantY = top + 59 + 1;
            int costAX = left + 7 + 5;
            this.renderScroller(transform, left, top, merchantoffers);
            int index = 0;
            for (MerchantOffer merchantoffer : merchantoffers) {
                if (!this.canScroll(merchantoffers.size()) || index >= this.scrollOff && index < 7 + this.scrollOff) {
                    ItemStack baseCostA = merchantoffer.m_45352_();
                    ItemStack costA = merchantoffer.m_45358_();
                    ItemStack costB = merchantoffer.m_45364_();
                    ItemStack result = merchantoffer.m_45368_();
                    transform.m_280168_().m_85836_();
                    transform.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
                    int itemY = merchantY + 2;
                    this.renderAndDecorateCostA(transform, costA, baseCostA, costAX, itemY);
                    if (!costB.m_41619_()) {
                        transform.m_280203_(costB, left + 5 + 35, itemY);
                        transform.m_280370_(this.f_96547_, costB, left + 5 + 35, itemY);
                    }
                    this.renderButtonArrows(transform, merchantoffer, left, itemY);
                    transform.m_280203_(result, left + 5 + 68, itemY);
                    transform.m_280370_(this.f_96547_, result, left + 5 + 68, itemY);
                    transform.m_280168_().m_85849_();
                    merchantY += 20;
                }
                ++index;
            }
            MerchantOffer currentOffer = (MerchantOffer)merchantoffers.get(this.shopItem);
            if (((BlacksmithMenu)this.f_97732_).showProgressBar()) {
                this.renderProgressBar(transform, left, top);
            }
            if (currentOffer.m_45380_() && this.m_6774_(186, 35, 22, 21, x, y) && ((BlacksmithMenu)this.f_97732_).canRestock()) {
                transform.m_280557_(this.f_96547_, DEPRECATED_TOOLTIP, x, y);
            }
            for (TradeOfferButton tradeOfferButton : this.tradeOfferButtons) {
                if (tradeOfferButton.m_198029_()) {
                    tradeOfferButton.renderToolTip(transform, x, y);
                }
                tradeOfferButton.f_93624_ = tradeOfferButton.index < ((BlacksmithMenu)this.f_97732_).getOffers().size();
            }
            RenderSystem.enableDepthTest();
        }
        this.m_280072_(transform, x, y);
    }

    private void renderButtonArrows(GuiGraphics transform, MerchantOffer offer, int x, int y) {
        if (offer.m_45380_()) {
            transform.m_280398_(VILLAGER_LOCATION, x + 5 + 35 + 20, y + 3, 0, 10.0f, 276.0f, 10, 9, 512, 512);
        } else {
            transform.m_280398_(VILLAGER_LOCATION, x + 5 + 35 + 20, y + 3, 0, 0.0f, 276.0f, 10, 9, 512, 512);
        }
    }

    private void renderAndDecorateCostA(GuiGraphics transform, ItemStack baseCostA, ItemStack costA, int x, int y) {
        transform.m_280203_(baseCostA, x, y);
        if (costA.m_41613_() == baseCostA.m_41613_()) {
            transform.m_280370_(this.f_96547_, baseCostA, x, y);
        } else {
            transform.m_280302_(this.f_96547_, costA, x, y, costA.m_41613_() == 1 ? "1" : null);
            transform.m_280168_().m_85836_();
            transform.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
            String count = baseCostA.m_41613_() == 1 ? "1" : String.valueOf(baseCostA.m_41613_());
            this.f_96547_.m_272078_(count, (float)(x + 14) + 19.0f - 2.0f - (float)this.f_96547_.m_92895_(count), (float)(y + 6) + 3.0f, 0xFFFFFF, true, transform.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)transform.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0, false);
            transform.m_280168_().m_85849_();
            transform.m_280168_().m_85836_();
            transform.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
            transform.m_280398_(VILLAGER_LOCATION, x + 7, y + 12, 0, 0.0f, 286.0f, 9, 2, 512, 512);
            transform.m_280168_().m_85849_();
        }
    }

    private boolean canScroll(int size) {
        return size > 7;
    }

    public boolean m_6050_(double x, double y, double delta) {
        int size = ((BlacksmithMenu)this.f_97732_).getOffers().size();
        if (this.canScroll(size)) {
            int overSize = size - 7;
            this.scrollOff = Mth.m_14045_((int)((int)((double)this.scrollOff - delta)), (int)0, (int)overSize);
        }
        return true;
    }

    public boolean m_7979_(double fromX, double fromY, int activeButton, double toX, double toY) {
        int size = ((BlacksmithMenu)this.f_97732_).getOffers().size();
        if (this.isDragging) {
            int scrollTop = this.f_97736_ + 61;
            int scrollBottom = scrollTop + 139;
            int overSize = size - 7;
            float scrollIndex = ((float)fromY - (float)scrollTop - 13.5f) / ((float)(scrollBottom - scrollTop) - 27.0f);
            scrollIndex = scrollIndex * (float)overSize + 0.5f;
            this.scrollOff = Mth.m_14045_((int)((int)scrollIndex), (int)0, (int)overSize);
            return true;
        }
        return super.m_7979_(fromX, fromY, activeButton, toX, toY);
    }

    public boolean m_6375_(double x, double y, int mouseButton) {
        this.isDragging = false;
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        if (this.canScroll(((BlacksmithMenu)this.f_97732_).getOffers().size()) && x > (double)(left + 94) && x < (double)(left + 94 + 6) && y > (double)(top + 61) && y <= (double)(top + 61 + 139 + 1)) {
            this.isDragging = true;
        }
        return super.m_6375_(x, y, mouseButton);
    }

    @OnlyIn(value=Dist.CLIENT)
    class TradeOfferButton
    extends Button {
        final int index;

        public TradeOfferButton(int x, int y, int index, Button.OnPress onPress) {
            super(x, y, 87, 20, CommonComponents.f_237098_, onPress, f_252438_);
            this.index = index;
            this.f_93624_ = false;
        }

        public int getIndex() {
            return this.index;
        }

        protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            Minecraft minecraft = Minecraft.m_91087_();
            pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            pGuiGraphics.m_280027_(BOTTON, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 20, 4, 200, 20, 0, this.m_274533_());
            pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            int i = this.getFGColor();
            this.m_280139_(pGuiGraphics, minecraft.f_91062_, i | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
        }

        private int m_274533_() {
            int i = 1;
            if (!this.f_93623_) {
                i = 0;
            } else if (this.m_198029_()) {
                i = 2;
            }
            return 46 + i * 20;
        }

        public void renderToolTip(GuiGraphics transform, int x, int y) {
            if (this.f_93622_ && ((BlacksmithMenu)BlacksmithScreen.this.f_97732_).getOffers().size() > this.index + BlacksmithScreen.this.scrollOff) {
                if (x < this.m_252754_() + 20) {
                    ItemStack itemstack = ((MerchantOffer)((BlacksmithMenu)BlacksmithScreen.this.f_97732_).getOffers().get(this.index + BlacksmithScreen.this.scrollOff)).m_45358_();
                    transform.m_280153_(BlacksmithScreen.this.f_96547_, itemstack, x, y);
                } else if (x < this.m_252754_() + 50 && x > this.m_252754_() + 30) {
                    ItemStack itemstack2 = ((MerchantOffer)((BlacksmithMenu)BlacksmithScreen.this.f_97732_).getOffers().get(this.index + BlacksmithScreen.this.scrollOff)).m_45364_();
                    if (!itemstack2.m_41619_()) {
                        transform.m_280153_(BlacksmithScreen.this.f_96547_, itemstack2, x, y);
                    }
                } else if (x > this.m_252754_() + 65) {
                    ItemStack itemstack1 = ((MerchantOffer)((BlacksmithMenu)BlacksmithScreen.this.f_97732_).getOffers().get(this.index + BlacksmithScreen.this.scrollOff)).m_45368_();
                    transform.m_280153_(BlacksmithScreen.this.f_96547_, itemstack1, x, y);
                }
            }
        }
    }
}

