/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.cilent.gui.screens.wuxia.gangleader;

import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.ChangShengJueMenuTypes;
import com.shengchanshe.chang_sheng_jue.quest.Quest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.npc.ClientSideMerchant;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;

public class GangQuestsMenu
extends AbstractContainerMenu {
    private final List<Quest> availableQuests;
    private int currentPage = 0;
    private final Merchant trader;
    private final Player player;

    public GangQuestsMenu(int id, Inventory inventory, FriendlyByteBuf extraData) {
        this(id, inventory, (Merchant)new ClientSideMerchant(inventory.f_35978_), GangQuestsMenu.readQuestsFromBuffer(extraData));
    }

    public GangQuestsMenu(int containerId, Inventory inv, Merchant merchant, List<Quest> availableQuests) {
        super((MenuType)ChangShengJueMenuTypes.GANG_QUESTS_MENU.get(), containerId);
        this.player = inv.f_35978_;
        this.availableQuests = availableQuests != null ? this.sortQuestsByWeight(availableQuests) : new ArrayList();
        this.trader = merchant;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)inv, col + row * 9 + 9, 8 + col * 18, 100000));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)inv, col, 8 + col * 18, 100000));
        }
    }

    private List<Quest> sortQuestsByWeight(List<Quest> quests) {
        ArrayList<Quest> sortedQuests = new ArrayList<Quest>(quests);
        sortedQuests.sort((q1, q2) -> {
            int weightCompare = Integer.compare(q2.getWeight(), q1.getWeight());
            if (weightCompare != 0) {
                return weightCompare;
            }
            return q1.getQuestId().compareTo(q2.getQuestId());
        });
        return sortedQuests;
    }

    private static List<Quest> readQuestsFromBuffer(FriendlyByteBuf extraData) {
        ArrayList<Quest> quests = new ArrayList<Quest>();
        int questCount = extraData.readInt();
        for (int i = 0; i < questCount; ++i) {
            Quest quest = new Quest(Objects.requireNonNull(extraData.m_130260_()));
            quests.add(quest);
        }
        return quests;
    }

    public void nextPage() {
        this.currentPage = this.currentPage < this.getTotalPages() - 1 ? ++this.currentPage : 0;
    }

    public void previousPage() {
        this.currentPage = this.currentPage > 0 ? --this.currentPage : this.getTotalPages() - 1;
    }

    public Quest getCurrentQuest() {
        if (this.availableQuests.isEmpty()) {
            return null;
        }
        if (this.currentPage >= 0 && this.currentPage < this.availableQuests.size()) {
            return this.availableQuests.get(this.currentPage);
        }
        return this.availableQuests.get(0);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getTotalPages() {
        return Math.max(1, this.availableQuests.size());
    }

    public List<Quest> getAllAvailableQuests() {
        return this.availableQuests;
    }

    public void updateAvailableQuests(List<Quest> newQuests) {
        this.availableQuests.clear();
        List<Quest> sorted = this.sortQuestsByWeight(newQuests);
        this.availableQuests.addAll(sorted);
        if (this.availableQuests.isEmpty()) {
            this.currentPage = 0;
        } else if (this.currentPage >= this.availableQuests.size()) {
            this.currentPage = this.availableQuests.size() - 1;
        } else if (this.currentPage < 0) {
            this.currentPage = 0;
        }
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public void m_6199_(Container container) {
        super.m_6199_(container);
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public Merchant getTrader() {
        return this.trader;
    }

    public Player getPlayer() {
        return this.player;
    }
}

