/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.cilent.gui.screens.wuxia.gangleader;

import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.button.TexturedButtonWithText;
import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.wuxia.gangleader.GangQuestsMenu;
import com.shengchanshe.chang_sheng_jue.network.ChangShengJueMessages;
import com.shengchanshe.chang_sheng_jue.network.packet.gui.quest.AcceptGangQuestsPacket;
import com.shengchanshe.chang_sheng_jue.quest.Quest;
import com.shengchanshe.chang_sheng_jue.util.GuiEntityGraphics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GangQuestsScreen
extends AbstractContainerScreen<GangQuestsMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("chang_sheng_jue", "textures/gui/container/gang_quests.png");
    private static final ResourceLocation BOTTON = new ResourceLocation("chang_sheng_jue", "textures/gui/botton.png");
    private static final int TEXTURE_WIDTH = 512;
    private static final int TEXTURE_HEIGHT = 512;
    private static final int PROGRESS_BAR_Y = 180;
    private static final int SLOT_SIZE = 18;
    private static final int REQ_SLOTS_X = 28;
    private static final int REQ_SLOTS_Y = 150;
    private static final int REWARD_SLOTS_X = 28;
    private static final int REWARD_SLOTS_Y = 170;
    private static final int BUTTON_WIDTH = 200;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_SPACING = 8;
    private static final int PAGE_BUTTON_WIDTH = 10;
    private static final int PAGE_BUTTON_HEIGHT = 11;
    private TexturedButtonWithText actionButton;
    private TexturedButtonWithText onPageButton;
    private TexturedButtonWithText nextPageButton;
    private int scrollTick = 0;
    private static final int HEAD_SIZE = 8;
    private static final int MAX_VISIBLE_HEADS = 5;
    private static final Map<EntityType<?>, Entity> ENTITY_CACHE = new HashMap();

    public GangQuestsScreen(GangQuestsMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 270;
        this.f_97727_ = 209;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280163_(TEXTURE, x, y, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 512);
        int currentPage = ((GangQuestsMenu)this.f_97732_).getCurrentPage() + 1;
        String pageInfo = String.format("%d/%d", currentPage, ((GangQuestsMenu)this.f_97732_).getTotalPages());
        guiGraphics.m_280056_(this.f_96547_, pageInfo, x + this.f_97726_ - (currentPage >= 10 ? 35 : 30), y + 52, 0x404040, false);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Quest currentQuest = ((GangQuestsMenu)this.f_97732_).getCurrentQuest();
        if (currentQuest != null) {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)currentQuest.getQuestName()), (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)Component.m_237115_((String)currentQuest.getQuestName()))) / 2, 67, 0x404040, false);
            List lines = this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)currentQuest.getQuestDescription()), this.f_97726_ - 45);
            for (int i = 0; i < lines.size(); ++i) {
                FormattedCharSequence formattedCharSequence = (FormattedCharSequence)lines.get(i);
                Objects.requireNonNull(this.f_96547_);
                guiGraphics.m_280649_(this.f_96547_, formattedCharSequence, 28, 95 + i * 9, 0x404040, false);
            }
            int requirementsTitleWidth = this.f_96547_.m_92852_((FormattedText)Component.m_237115_((String)"quest.chang_sheng_jue.requirements"));
            int descriptionStartX = 28 + requirementsTitleWidth + (currentQuest.getSecondTargetEntity() != null && !currentQuest.getSecondTargetEntity().isEmpty() ? 30 : (currentQuest.getTargetEntity() != null && !currentQuest.getTargetEntity().isEmpty() ? 20 : 5));
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"quest.chang_sheng_jue.requirements"), 28, 141, ChatFormatting.RED.m_126665_().intValue(), false);
            String requirementsText = currentQuest.getQuestRequirementsDescription();
            MutableComponent fullDescriptionComponent = Component.m_237115_((String)requirementsText);
            int fullTextWidth = this.f_96547_.m_92852_((FormattedText)fullDescriptionComponent);
            int maxAvailableWidth = this.f_97726_ - 50 - descriptionStartX;
            if (fullTextWidth > maxAvailableWidth && maxAvailableWidth > 0) {
                ++this.scrollTick;
                String visibleText = this.getString((Component)fullDescriptionComponent);
                guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)visibleText), descriptionStartX, 141, ChatFormatting.RED.m_126665_().intValue(), false);
            } else {
                List lines1 = this.f_96547_.m_92923_((FormattedText)fullDescriptionComponent, this.f_97726_ - 50);
                for (int i = 0; i < lines1.size(); ++i) {
                    FormattedCharSequence formattedCharSequence = (FormattedCharSequence)lines1.get(i);
                    Objects.requireNonNull(this.f_96547_);
                    guiGraphics.m_280649_(this.f_96547_, formattedCharSequence, descriptionStartX, 141 + i * 9, ChatFormatting.RED.m_126665_().intValue(), false);
                }
            }
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"quest.chang_sheng_jue.rewards"), 28, 161, ChatFormatting.YELLOW.m_126665_().intValue(), false);
        } else {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"quest.chang_sheng_jue.no_action_quest"), (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)Component.m_237115_((String)"quest.chang_sheng_jue.no_action_quest"))) / 2, 100, ChatFormatting.RED.m_126665_().intValue(), true);
        }
    }

    @NotNull
    private String getString(Component requirementsText) {
        Object visibleText;
        int scrollSpeed = 15;
        int visibleChars = Math.min(30, requirementsText.getString().length());
        String textWithSpacing = requirementsText.getString() + "    ";
        int totalLength = textWithSpacing.length();
        int startPos = this.scrollTick / scrollSpeed % totalLength;
        if (startPos + visibleChars <= totalLength) {
            visibleText = textWithSpacing.substring(startPos, startPos + visibleChars);
        } else {
            int part1Length = totalLength - startPos;
            int part2Length = visibleChars - part1Length;
            visibleText = textWithSpacing.substring(startPos) + textWithSpacing.substring(0, part2Length);
        }
        return visibleText;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        Quest currentQuest = this.getCurrentQuest();
        if (currentQuest != null) {
            ItemStack stack;
            int i;
            int x = (this.f_96543_ - this.f_97726_) / 2;
            int y = (this.f_96544_ - this.f_97727_) / 2;
            int requirementsTitleWidth = this.f_96547_.m_92852_((FormattedText)Component.m_237115_((String)"quest.chang_sheng_jue.requirements"));
            int descriptionStartX = x + 28 + requirementsTitleWidth + 5;
            int rewardsTitleWidth = this.f_96547_.m_92852_((FormattedText)Component.m_237115_((String)"quest.chang_sheng_jue.rewards"));
            int rewardsDescriptionStartX = x + 28 + rewardsTitleWidth + 5;
            if (currentQuest.getQuestType() == Quest.QuestType.KILL) {
                GuiEntityGraphics.getInstance(this.f_96547_, 8, 5, ENTITY_CACHE).renderKillTargetHead(guiGraphics, descriptionStartX, y + 150 - 2, currentQuest.getTargetEntity(), currentQuest.getCurrentKills(), currentQuest.getRequiredKills());
                if (currentQuest.getSecondTargetEntity() != null && !currentQuest.getSecondTargetEntity().isEmpty()) {
                    GuiEntityGraphics.getInstance(this.f_96547_, 8, 5, ENTITY_CACHE).renderKillTargetHead(guiGraphics, descriptionStartX + 15, y + 150 - 2, currentQuest.getSecondTargetEntity(), currentQuest.getSecondCurrentKills(), currentQuest.getSecondRequiredKills());
                }
            } else if (currentQuest.getQuestType() == Quest.QuestType.GATHER) {
                List<ItemStack> reqs = currentQuest.getQuestRequirements();
                for (i = 0; i < Math.min(3, reqs.size()); ++i) {
                    stack = reqs.get(i);
                    this.renderItemAt(guiGraphics, descriptionStartX + i * 18, y + 150 - 13, stack);
                }
            }
            List<ItemStack> rewards = currentQuest.getQuestRewards();
            for (i = 0; i < Math.min(3, rewards.size()); ++i) {
                stack = rewards.get(i);
                this.renderItemAt(guiGraphics, rewardsDescriptionStartX + i * 18, y + 170 - 13, stack);
            }
            this.renderTooltips(guiGraphics, mouseX, mouseY, x, y, currentQuest);
        }
    }

    private Quest getCurrentQuest() {
        if (((GangQuestsMenu)this.f_97732_).getAllAvailableQuests().isEmpty()) {
            return ((GangQuestsMenu)this.f_97732_).getCurrentQuest();
        }
        if (((GangQuestsMenu)this.f_97732_).getCurrentPage() >= 0 && ((GangQuestsMenu)this.f_97732_).getCurrentPage() < ((GangQuestsMenu)this.f_97732_).getAllAvailableQuests().size()) {
            return ((GangQuestsMenu)this.f_97732_).getAllAvailableQuests().get(((GangQuestsMenu)this.f_97732_).getCurrentPage());
        }
        return null;
    }

    private void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y, Quest quest) {
        int requirementsTitleWidth = this.f_96547_.m_92852_((FormattedText)Component.m_237115_((String)"quest.chang_sheng_jue.requirements"));
        int descriptionStartX = x + 28 + requirementsTitleWidth + 5;
        int rewardsTitleWidth = this.f_96547_.m_92852_((FormattedText)Component.m_237115_((String)"quest.chang_sheng_jue.rewards"));
        int rewardsDescriptionStartX = x + 28 + rewardsTitleWidth + 5;
        List<ItemStack> reqs = quest.getQuestRequirements();
        for (int i = 0; i < Math.min(3, reqs.size()); ++i) {
            if (!this.isMouseOverSlot(mouseX, mouseY, descriptionStartX + i * 18, y + 150 - 13, 18, 18)) continue;
            guiGraphics.m_280153_(this.f_96547_, reqs.get(i), mouseX, mouseY);
            return;
        }
        List<ItemStack> rewards = quest.getQuestRewards();
        for (int i = 0; i < Math.min(3, rewards.size()); ++i) {
            if (!this.isMouseOverSlot(mouseX, mouseY, rewardsDescriptionStartX + i * 18, y + 170 - 13, 18, 18)) continue;
            guiGraphics.m_280153_(this.f_96547_, rewards.get(i), mouseX, mouseY);
            return;
        }
    }

    private boolean isMouseOverSlot(int mouseX, int mouseY, int slotX, int slotY, int width, int height) {
        return mouseX >= slotX && mouseX <= slotX + width && mouseY >= slotY && mouseY <= slotY + height;
    }

    private void renderItemAt(GuiGraphics guiGraphics, int x, int y, ItemStack stack) {
        guiGraphics.m_280480_(stack, x, y);
        guiGraphics.m_280370_(this.f_96547_, stack, x, y);
    }

    protected void m_7856_() {
        super.m_7856_();
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        int buttonY = top + 180 + 2;
        int buttonX = left + (this.f_97726_ - 200) / 2;
        if (this.getCurrentQuest() != null) {
            this.actionButton = (TexturedButtonWithText)this.m_142416_((GuiEventListener)new TexturedButtonWithText(buttonX, buttonY, 200, 20, 0, 66, 20, BOTTON, 256, 256, this::handleActionButtonClick, (Component)Component.m_237115_((String)"quest.chang_sheng_jue.accept.button"), 0xFFFFFF, 0xFFFFFF, 1.0f, true));
        }
        int pageButtonY = top + 65;
        int pageButtonX = left + (this.f_97726_ - 10) / 2;
        this.onPageButton = (TexturedButtonWithText)this.m_142416_((GuiEventListener)new TexturedButtonWithText(pageButtonX - 108, pageButtonY, 10, 11, 14, 211, 11, TEXTURE, 512, 512, button -> ((GangQuestsMenu)this.f_97732_).previousPage(), CommonComponents.f_237098_, 0xFFFFFF, 0xFFFFFF, 1.0f, 1.5f, 1.5f, 1.6f));
        this.nextPageButton = (TexturedButtonWithText)this.m_142416_((GuiEventListener)new TexturedButtonWithText(pageButtonX + 112, pageButtonY, 10, 11, 0, 211, 11, TEXTURE, 512, 512, button -> ((GangQuestsMenu)this.f_97732_).nextPage(), CommonComponents.f_237098_, 0xFFFFFF, 0xFFFFFF, 1.0f, 1.5f, 1.5f, 1.6f));
    }

    private void handleActionButtonClick(Button button) {
        ChangShengJueMessages.sendToServer(new AcceptGangQuestsPacket(((GangQuestsMenu)this.f_97732_).getCurrentQuest().getQuestId()));
    }

    public void refreshUI() {
        this.m_169413_();
        this.f_169369_.clear();
        this.m_7856_();
        this.m_267719_();
    }

    public void forceRefresh(List<Quest> newQuests) {
        ((GangQuestsMenu)this.f_97732_).updateAvailableQuests(newQuests);
        this.refreshUI();
    }
}

