/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.cilent.gui.screens.wuxia.playerquest;

import com.shengchanshe.chang_sheng_jue.capability.quest.PlayerQuestCapabilityProvider;
import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.ChangShengJueMenuTypes;
import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.wuxia.playerquest.ClientQuestDataCache;
import com.shengchanshe.chang_sheng_jue.quest.Quest;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class PlayerQuestMenu
extends AbstractContainerMenu {
    private List<Quest> quests;
    private int currentPage;
    private Player player;

    public PlayerQuestMenu(int containerId, Inventory playerInv, Player player) {
        super((MenuType)ChangShengJueMenuTypes.PLAYER_QUEST_MENU.get(), containerId);
        this.player = player;
        this.refreshQuests();
        this.currentPage = 0;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 100000));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, 100000));
        }
    }

    public void refreshQuests() {
        this.quests = this.player.m_9236_().f_46443_ ? ClientQuestDataCache.get().getPlayerQuests(this.player.m_20148_()) : this.player.getCapability(PlayerQuestCapabilityProvider.PLAYER_QUEST_CAPABILITY).map(cap -> cap.getQuests(this.player.m_20148_())).orElse(Collections.emptyList());
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public ItemStack m_7648_(Player player, int i) {
        return ItemStack.f_41583_;
    }

    public Optional<Quest> getCurrentQuest(int page) {
        if (this.quests.isEmpty() || page < 0 || page >= this.quests.size()) {
            return Optional.empty();
        }
        Quest quest = this.quests.get(page);
        if (quest.getAcceptedBy() == null) {
            return Optional.empty();
        }
        return Optional.of(quest);
    }

    public boolean hasPrevPage() {
        return this.currentPage > 0;
    }

    public boolean hasNextPage() {
        return this.currentPage + 1 < this.quests.size();
    }

    public void nextPage() {
        this.currentPage = this.hasNextPage() ? ++this.currentPage : 0;
    }

    public void prevPage() {
        this.currentPage = this.hasPrevPage() ? --this.currentPage : this.quests.size() - 1;
    }

    public void adjustPageAfterQuestRemoval() {
        Quest currentQuest;
        this.refreshQuests();
        if (this.quests.isEmpty()) {
            this.currentPage = 0;
            return;
        }
        if (this.currentPage >= this.quests.size()) {
            this.currentPage = this.quests.size() - 1;
        }
        if (this.currentPage >= 0 && this.currentPage < this.quests.size() && (currentQuest = this.quests.get(this.currentPage)).getAcceptedBy() == null) {
            this.findNearestValidPage();
        }
    }

    private void findNearestValidPage() {
        int i;
        if (this.quests.isEmpty()) {
            this.currentPage = 0;
            return;
        }
        for (i = this.currentPage; i >= 0; --i) {
            if (i >= this.quests.size() || this.quests.get(i).getAcceptedBy() == null) continue;
            this.currentPage = i;
            return;
        }
        for (i = this.currentPage; i < this.quests.size(); ++i) {
            if (this.quests.get(i).getAcceptedBy() == null) continue;
            this.currentPage = i;
            return;
        }
        this.currentPage = 0;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getTotalPages() {
        return Math.max(1, this.quests.size());
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }
}

